/*
 * Decompiled with CFR 0.152.
 */
package io.github.naverz.antonio;

import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import io.github.naverz.antonio.core.AntonioModel;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Objects;

public interface GenericAntonioFindable {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    default public Pair<Class<?>, Class<?>> findAntonioClass() {
        try {
            for (Class<?> cls = this.getClass(); cls != Object.class && cls != null; cls = cls.getSuperclass()) {
                Class<?> result = GenericAntonioFindable.findOnGeneric(cls, AntonioModel.class);
                if (result == null) continue;
                return new Pair(cls.getSuperclass(), result);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public static Class<?> findOnGeneric(Class<?> target, Class<?> toFind) {
        try {
            Type[] types;
            Type[] typeArray = types = ((ParameterizedType)Objects.requireNonNull(target.getGenericSuperclass())).getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            if (n2 < n) {
                Type t = typeArray[n2];
                if (GenericAntonioFindable.isInParent((Class)t, toFind).booleanValue()) {
                    return (Class)t;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static Boolean isInParent(Class<?> target, Class<?> toFind) {
        HashSet<String> parentClassNames = new HashSet<String>();
        for (Class<?> cls = target; cls != Object.class && cls != null; cls = cls.getSuperclass()) {
            parentClassNames.add(target.getName());
            GenericAntonioFindable.recursiveFindInterfaceAndAdd(parentClassNames, cls.getInterfaces());
        }
        return parentClassNames.contains(toFind.getName());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void recursiveFindInterfaceAndAdd(HashSet<String> to, Class<?>[] interfaces) {
        for (Class<?> anInterface : interfaces) {
            to.add(anInterface.getName());
            GenericAntonioFindable.recursiveFindInterfaceAndAdd(to, anInterface.getInterfaces());
        }
    }
}

