/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.validator.builtin;

import io.github.nambach.excelutil.validator.Constraint;
import io.github.nambach.excelutil.validator.builtin.DecimalValidator;
import io.github.nambach.excelutil.validator.builtin.IntegerValidator;
import io.github.nambach.excelutil.validator.builtin.StringValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TypeValidator {
    static final Constraint NotNull = new Constraint("[Validator] not null", Objects::nonNull, "must not be null");
    static final ArrayList<Constraint> BasedConstraints = new ArrayList();
    protected Constraint.Set constraints = new Constraint.Set();

    TypeValidator() {
    }

    public static TypeValidator init() {
        return new TypeValidator();
    }

    public static StringValidator string() {
        return new StringValidator();
    }

    public static IntegerValidator integer() {
        return new IntegerValidator();
    }

    public static DecimalValidator decimal() {
        return new DecimalValidator();
    }

    public static TypeValidator custom(Predicate<?> condition, String message) {
        return new TypeValidator().customValidator(condition, message);
    }

    public String quickTest(Object value) {
        return this.constraints.stream().filter(constraint -> constraint.notOk(value)).map(Constraint::getMessage).findFirst().orElse(null);
    }

    public List<String> test(Object value) {
        return this.constraints.stream().filter(constraint -> constraint.notOk(value)).map(Constraint::getMessage).collect(Collectors.toList());
    }

    public TypeValidator notNull() {
        this.constraints.add(NotNull);
        return this;
    }

    public TypeValidator notNull(String message) {
        this.constraints.add(NotNull.withMessage(message));
        return this;
    }

    protected void copy(TypeValidator other) {
        this.constraints.addAll(other.constraints);
    }

    public StringValidator isString() {
        StringValidator validator = new StringValidator();
        validator.copy(this);
        return validator;
    }

    public IntegerValidator isInteger() {
        IntegerValidator validator = new IntegerValidator();
        validator.copy(this);
        return validator;
    }

    public DecimalValidator isDecimal() {
        DecimalValidator validator = new DecimalValidator();
        validator.copy(this);
        return validator;
    }

    public <T> TypeValidator customValidator(Predicate<T> condition, String message) {
        String name = "[Custom] " + UUID.randomUUID();
        this.constraints.add(new Constraint(name, condition, message));
        return this;
    }

    Constraint.Set getConstraints() {
        return this.constraints;
    }

    static {
        BasedConstraints.add(NotNull);
    }
}

