/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.validator.builtin;

import io.github.nambach.excelutil.validator.Constraint;
import io.github.nambach.excelutil.validator.builtin.DecimalConstraint;
import io.github.nambach.excelutil.validator.builtin.TypeValidator;

public class DecimalValidator
extends TypeValidator {
    DecimalValidator() {
        Constraint.Set temp = new Constraint.Set();
        temp.add(DecimalConstraint.IsDecimal);
        temp.addAll(this.constraints);
        this.constraints = temp;
    }

    @Override
    public DecimalValidator notNull() {
        super.notNull();
        return this;
    }

    @Override
    public DecimalValidator notNull(String message) {
        super.notNull(message);
        return this;
    }

    public DecimalValidator min(double min) {
        this.constraints.add(DecimalConstraint.MinDecimal.apply(min));
        return this;
    }

    public DecimalValidator min(double min, String message) {
        this.constraints.add(DecimalConstraint.MinDecimal.apply(min).withMessage(message));
        return this;
    }

    public DecimalValidator max(double max) {
        this.constraints.add(DecimalConstraint.MaxDecimal.apply(max));
        return this;
    }

    public DecimalValidator max(double max, String message) {
        this.constraints.add(DecimalConstraint.MaxDecimal.apply(max).withMessage(message));
        return this;
    }

    public DecimalValidator between(double min, double max) {
        this.constraints.add(DecimalConstraint.BetweenDecimal.apply(min, max));
        return this;
    }

    public DecimalValidator between(double min, double max, String message) {
        this.constraints.add(DecimalConstraint.BetweenDecimal.apply(min, max).withMessage(message));
        return this;
    }

    public DecimalValidator greaterThan(double min) {
        this.constraints.add(DecimalConstraint.GreaterThanDecimal.apply(min));
        return this;
    }

    public DecimalValidator greaterThan(double min, String message) {
        this.constraints.add(DecimalConstraint.GreaterThanDecimal.apply(min).withMessage(message));
        return this;
    }

    public DecimalValidator lessThan(double max) {
        this.constraints.add(DecimalConstraint.LessThanDecimal.apply(max));
        return this;
    }

    public DecimalValidator lessThan(double max, String message) {
        this.constraints.add(DecimalConstraint.LessThanDecimal.apply(max).withMessage(message));
        return this;
    }

    public DecimalValidator betweenExclusive(double min, double max) {
        this.constraints.add(DecimalConstraint.BetweenDecimalExclusive.apply(min, max));
        return this;
    }

    public DecimalValidator betweenExclusive(double min, double max, String message) {
        this.constraints.add(DecimalConstraint.BetweenDecimalExclusive.apply(min, max).withMessage(message));
        return this;
    }
}

