/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.validator.builtin;

import io.github.nambach.excelutil.validator.Constraint;
import io.github.nambach.excelutil.validator.builtin.Util;
import java.util.function.BiFunction;
import java.util.function.Function;

class DecimalConstraint {
    static final Constraint IsDecimal = new Constraint("[Decimal] is decimal", o -> Util.isInstanceOf(Util.DECIMAL, o), "must be a decimal").nullable();
    static final Function<Double, Constraint> MinDecimal = min -> new Constraint("[Decimal] min value", o -> {
        if (Util.isInstanceOf(Util.DECIMAL, o)) {
            return Util.compareWithDouble(o, min) >= 0;
        }
        return false;
    }, String.format("minimum value is %f", min)).nullable();
    static final Function<Double, Constraint> MaxDecimal = max -> new Constraint("[Decimal] max value", o -> {
        if (Util.isInstanceOf(Util.DECIMAL, o)) {
            return Util.compareWithDouble(o, max) <= 0;
        }
        return false;
    }, String.format("maximum value is %f", max)).nullable();
    static final BiFunction<Double, Double, Constraint> BetweenDecimal = (min, max) -> new Constraint("[Decimal] inclusively between", o -> {
        if (Util.isInstanceOf(Util.DECIMAL, o)) {
            return Util.compareWithDouble(o, min) >= 0 && Util.compareWithDouble(o, max) <= 0;
        }
        return false;
    }, String.format("value must be from %f to %f", min, max)).nullable();
    static final Function<Double, Constraint> GreaterThanDecimal = min -> new Constraint("[Decimal] greater than value", o -> {
        if (Util.isInstanceOf(Util.DECIMAL, o)) {
            return Util.compareWithDouble(o, min) > 0;
        }
        return false;
    }, String.format("value must be greater than %f", min)).nullable();
    static final Function<Double, Constraint> LessThanDecimal = max -> new Constraint("[Decimal] less than value", o -> {
        if (Util.isInstanceOf(Util.DECIMAL, o)) {
            return Util.compareWithDouble(o, max) < 0;
        }
        return false;
    }, String.format("value must be less than %f", max)).nullable();
    static final BiFunction<Double, Double, Constraint> BetweenDecimalExclusive = (min, max) -> new Constraint("[Decimal] exclusively between", o -> {
        if (Util.isInstanceOf(Util.DECIMAL, o)) {
            return Util.compareWithDouble(o, min) > 0 && Util.compareWithDouble(o, max) < 0;
        }
        return false;
    }, String.format("value must be greater than %f and less than %f", min, max)).nullable();

    DecimalConstraint() {
    }
}

