/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.util;

import io.github.nambach.excelutil.util.Copyable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public interface Readable {
    public Object getValue();

    default public Optional<String> getString() {
        Object value = this.getValue();
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    default public Optional<Long> getLong() {
        Object value = this.getValue();
        if (value instanceof Long) {
            return Optional.of((Long)value);
        }
        return Optional.empty();
    }

    default public long getUnsafeLong() {
        return this.getLong().get();
    }

    default public Optional<Integer> getInt() {
        Object value = this.getValue();
        if (value instanceof Integer) {
            return Optional.of((Integer)value);
        }
        return Optional.empty();
    }

    default public int getUnsafeInt() {
        return this.getInt().get();
    }

    default public Optional<Short> getShort() {
        Object value = this.getValue();
        if (value instanceof Short) {
            return Optional.of((Short)value);
        }
        return Optional.empty();
    }

    default public short getUnsafeShort() {
        return this.getShort().get();
    }

    default public Optional<Double> getDouble() {
        Object value = this.getValue();
        if (value instanceof Double) {
            return Optional.of((Double)value);
        }
        return Optional.empty();
    }

    default public double getUnsafeDouble() {
        return this.getDouble().get();
    }

    default public Optional<Float> getFloat() {
        Object value = this.getValue();
        if (value instanceof Float) {
            return Optional.of((Float)value);
        }
        return Optional.empty();
    }

    default public float getUnsafeFloat() {
        return this.getFloat().get().floatValue();
    }

    default public Optional<Boolean> getBoolean() {
        Object value = this.getValue();
        if (value instanceof Boolean) {
            return Optional.of((Boolean)value);
        }
        return Optional.empty();
    }

    default public boolean getUnsafeBoolean() {
        return this.getBoolean().get();
    }

    default public <T> Optional<T> getAny(Class<T> clazz) {
        return Optional.ofNullable(this.getValue());
    }

    default public boolean isNull() {
        return this.getValue() == null;
    }

    default public boolean isNullOrEmpty() {
        Object value = this.getValue();
        if (value == null) {
            return true;
        }
        if (value instanceof Iterable) {
            return !((Iterable)value).iterator().hasNext();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        return false;
    }

    default public boolean hasValue() {
        return !this.isNullOrEmpty();
    }

    default public Object copyValue() {
        Object value = this.getValue();
        if (value instanceof Copyable) {
            return ((Copyable)value).makeCopy();
        }
        if (value instanceof Iterable) {
            ArrayList list = new ArrayList();
            ((Iterable)value).forEach(list::add);
            return list;
        }
        if (value instanceof Map) {
            return new HashMap((Map)value);
        }
        return value;
    }
}

