/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.util;

import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class PixelUtil {
    public static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
    public static final short EXCEL_ROW_HEIGHT_FACTOR = 20;
    public static final int UNIT_OFFSET_LENGTH = 7;
    protected static final int[] UNIT_OFFSET_MAP = new int[]{0, 36, 73, 109, 146, 182, 219};

    private PixelUtil() {
    }

    public static short pixel2WidthUnits(int pxs) {
        short widthUnits = (short)(256 * (pxs / 7));
        widthUnits = (short)(widthUnits + UNIT_OFFSET_MAP[pxs % 7]);
        return widthUnits;
    }

    public static int widthUnits2Pixel(short widthUnits) {
        int pixels = widthUnits / 256 * 7;
        int offsetWidthUnits = widthUnits % 256;
        pixels = (int)((double)pixels + Math.floor((float)offsetWidthUnits / 36.57143f));
        return pixels;
    }

    public static int heightUnits2Pixel(short heightUnits) {
        int pixels = heightUnits / 20;
        int offsetWidthUnits = heightUnits % 20;
        pixels = (int)((double)pixels + Math.floor((float)offsetWidthUnits / 2.857143f));
        return pixels;
    }

    public static void setRowHeight(Row row, int pixels) {
        row.setHeight(PixelUtil.pixel2WidthUnits(pixels));
    }

    public static void setColumnWidth(Sheet sheet, int colIndex, int pixels) {
        sheet.setColumnWidth(colIndex, (int)PixelUtil.pixel2WidthUnits(pixels));
    }

    public static void setDefaultColumnWidth(Sheet sheet, int pixels) {
        sheet.setDefaultColumnWidth((int)PixelUtil.pixel2WidthUnits(pixels));
    }
}

