/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.util;

import io.github.nambach.excelutil.util.Direction;
import io.github.nambach.excelutil.util.NullPolicy;
import io.github.nambach.excelutil.util.ReflectUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Criterion<T> {
    private static final Logger log = LogManager.getLogger(Criterion.class);
    private Function<T, ?> valueExtractor;
    private Direction direction = Direction.ASC;
    private NullPolicy nullPolicy = NullPolicy.EVALUATE_LESS;
    private String fieldName;

    Criterion() {
    }

    public Criterion<T> value(Function<T, ?> valueExtractor) {
        Objects.requireNonNull(valueExtractor);
        this.valueExtractor = valueExtractor;
        return this;
    }

    public Criterion<T> field(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public Criterion<T> direction(String direction) {
        if ("desc".equalsIgnoreCase(direction)) {
            this.direction = Direction.DESC;
        }
        return this;
    }

    public Criterion<T> evaluateNull(NullPolicy nullPolicy) {
        if (nullPolicy != null) {
            this.nullPolicy = nullPolicy;
        }
        return this;
    }

    public Criterion<T> asc() {
        this.direction = Direction.ASC;
        return this;
    }

    public Criterion<T> desc() {
        this.direction = Direction.DESC;
        return this;
    }

    private Object extractValue(T object) {
        if (this.valueExtractor != null) {
            return this.valueExtractor.apply(object);
        }
        Class<?> tClass = object.getClass();
        PropertyDescriptor pd = ReflectUtil.getField(this.fieldName, tClass);
        if (pd != null) {
            try {
                return pd.getReadMethod().invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("Cannot read field '" + this.fieldName + "' of class '" + tClass.getName() + "'.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    int compare(T o1, T o2) {
        int nullWeight = this.nullPolicy.equals((Object)NullPolicy.EVALUATE_LESS) ? 1 : -1;
        Object val1 = this.extractValue(o1);
        Object val2 = this.extractValue(o2);
        if (val1 == null && val2 == null) {
            return 0;
        }
        int compared = val1 == null ? -1 * nullWeight : (val2 == null ? nullWeight : (val1 instanceof String ? Collator.getInstance(Locale.getDefault()).compare((String)val1, (String)val2) : (val1 instanceof Comparable ? ((Comparable)val1).compareTo(val2) : 0)));
        int directionVal = this.direction == Direction.ASC ? 1 : (this.direction == Direction.DESC ? -1 : 0);
        return compared * directionVal;
    }

    Function<T, ?> getValueExtractor() {
        return this.valueExtractor;
    }

    Direction getDirection() {
        return this.direction;
    }

    NullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    String getFieldName() {
        return this.fieldName;
    }
}

