/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.style;

import io.github.nambach.excelutil.style.Border;
import io.github.nambach.excelutil.style.Style;
import io.github.nambach.excelutil.style.StyleColor;
import io.github.nambach.excelutil.style.StyleHandler;
import io.github.nambach.excelutil.style.StyleProperty;
import io.github.nambach.excelutil.style.XSSFColorCache;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XSSFStyleHandler
extends StyleHandler {
    private final XSSFWorkbook workbook;
    private final XSSFColorCache colorCache;

    public XSSFStyleHandler(XSSFWorkbook workbook, XSSFColorCache colorCache) {
        this.workbook = workbook;
        this.colorCache = colorCache;
    }

    @Override
    Workbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public CellStyle renderCellStyle(Style style) {
        if (style == null) {
            return null;
        }
        XSSFCellStyle cellStyle = (XSSFCellStyle)super.renderCellStyle(style);
        style.getProperty(StyleProperty.BackgroundColor).getAny(StyleColor.class).ifPresent(color -> {
            if (color.isCustom()) {
                cellStyle.setFillForegroundColor(this.colorCache.getColor((StyleColor)color));
            }
        });
        return cellStyle;
    }

    @Override
    protected Font renderFont(Style style) {
        XSSFFont font = (XSSFFont)super.renderFont(style);
        style.getProperty(StyleProperty.FontColor).getAny(StyleColor.class).ifPresent(color -> {
            if (color.isCustom()) {
                font.setColor(this.colorCache.getColor((StyleColor)color));
            }
        });
        return font;
    }

    @Override
    public void setBorderTop(Border border, CellStyle cellStyle) {
        cellStyle.setBorderTop(border.getBorderStyle());
        StyleColor color = border.getColor();
        if (color.isPreset()) {
            cellStyle.setTopBorderColor(color.toIndexedColor().index);
        } else {
            ((XSSFCellStyle)cellStyle).setTopBorderColor(this.colorCache.getColor(color));
        }
    }

    @Override
    public void setBorderBottom(Border border, CellStyle cellStyle) {
        cellStyle.setBorderBottom(border.getBorderStyle());
        StyleColor color = border.getColor();
        if (color.isPreset()) {
            cellStyle.setBottomBorderColor(color.toIndexedColor().index);
        } else {
            ((XSSFCellStyle)cellStyle).setBottomBorderColor(this.colorCache.getColor(color));
        }
    }

    @Override
    public void setBorderLeft(Border border, CellStyle cellStyle) {
        cellStyle.setBorderLeft(border.getBorderStyle());
        StyleColor color = border.getColor();
        if (color.isPreset()) {
            cellStyle.setLeftBorderColor(color.toIndexedColor().index);
        } else {
            ((XSSFCellStyle)cellStyle).setLeftBorderColor(this.colorCache.getColor(color));
        }
    }

    @Override
    public void setBorderRight(Border border, CellStyle cellStyle) {
        cellStyle.setBorderRight(border.getBorderStyle());
        StyleColor color = border.getColor();
        if (color.isPreset()) {
            cellStyle.setRightBorderColor(color.toIndexedColor().index);
        } else {
            ((XSSFCellStyle)cellStyle).setRightBorderColor(this.colorCache.getColor(color));
        }
    }

    @Override
    public int countColors() {
        return this.colorCache.size();
    }
}

