/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.style;

import io.github.nambach.excelutil.util.Copyable;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.IndexedColors;

class StyleColor
extends Color
implements Copyable<StyleColor>,
Comparable<StyleColor> {
    private static final Map<Integer, HSSFColor.HSSFColorPredefined> PredefinedMap = new HashMap<Integer, HSSFColor.HSSFColorPredefined>();
    private final transient HSSFColor hssfColor;

    private StyleColor(int r, int g, int b, HSSFColor hssfColor) {
        super(r, g, b);
        this.hssfColor = hssfColor;
    }

    private StyleColor(int rgb, HSSFColor hssfColor) {
        super(rgb);
        this.hssfColor = hssfColor;
    }

    public static StyleColor fromPredefined(IndexedColors color) {
        HSSFColor predefined = PredefinedMap.get(color.index).getColor();
        short[] rgb = predefined.getTriplet();
        return new StyleColor((int)rgb[0], (int)rgb[1], (int)rgb[2], predefined);
    }

    public static StyleColor fromRGB(int r, int g, int b) {
        HSSFColor predefined = StyleColor.findInMap((short)r, (short)g, (short)b);
        return new StyleColor(r, g, b, predefined);
    }

    public static StyleColor fromHex(String hexColor) {
        Color color = Color.decode(hexColor);
        HSSFColor predefined = StyleColor.findInMap((short)color.getRed(), (short)color.getGreen(), (short)color.getBlue());
        return new StyleColor(color.getRGB(), predefined);
    }

    private static HSSFColor findInMap(short r, short g, short b) {
        for (HSSFColor.HSSFColorPredefined value : PredefinedMap.values()) {
            short[] rgb = value.getTriplet();
            if (rgb[0] != r || rgb[1] != g || rgb[2] != b) continue;
            return value.getColor();
        }
        return null;
    }

    @Override
    public StyleColor makeCopy() {
        return new StyleColor(this.getRGB(), this.hssfColor);
    }

    IndexedColors toIndexedColor() {
        if (this.hssfColor != null) {
            return IndexedColors.fromInt((int)this.hssfColor.getIndex());
        }
        return null;
    }

    public boolean isPreset() {
        return this.hssfColor != null;
    }

    public boolean isCustom() {
        return this.hssfColor == null;
    }

    @Override
    public int compareTo(StyleColor o) {
        return this.getRGB() - o.getRGB();
    }

    public short[] getTriplet() {
        return new short[]{(short)this.getRed(), (short)this.getGreen(), (short)this.getBlue()};
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StyleColor)) {
            return false;
        }
        StyleColor other = (StyleColor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof StyleColor;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public HSSFColor getHssfColor() {
        return this.hssfColor;
    }

    static {
        for (HSSFColor.HSSFColorPredefined value : HSSFColor.HSSFColorPredefined.values()) {
            PredefinedMap.put(Integer.valueOf(value.getIndex()), value);
        }
    }
}

