/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.style;

import io.github.nambach.excelutil.style.Border;
import io.github.nambach.excelutil.style.BorderSide;
import io.github.nambach.excelutil.style.StyleColor;
import io.github.nambach.excelutil.style.StyleProperty;
import io.github.nambach.excelutil.util.Copyable;
import io.github.nambach.excelutil.util.CopyableList;
import io.github.nambach.excelutil.util.Readable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class Style
implements Copyable<Style>,
Serializable {
    private static final long serialVersionUID = -3301075124198499750L;
    private final String uuid;
    private final Map<String, StyleProperty> styleMap = new HashMap<String, StyleProperty>();

    private Style(String uuid) {
        this.uuid = uuid;
    }

    private static Style newRandomStyle() {
        return new Style(UUID.randomUUID().toString());
    }

    public static StyleBuilder builder() {
        return new StyleBuilder(Style.newRandomStyle());
    }

    public static StyleBuilder builder(Style style) {
        if (style != null) {
            return new StyleBuilder(style.makeCopy());
        }
        return Style.builder();
    }

    void put(StyleProperty styleProperty) {
        this.styleMap.put(styleProperty.getName(), styleProperty);
    }

    StyleProperty getProperty(StyleProperty any) {
        return this.styleMap.getOrDefault(any.getName(), any);
    }

    StyleProperty getOrDefault(StyleProperty any) {
        StyleProperty property = this.styleMap.get(any.getName());
        if (property == null) {
            this.put(any);
            property = any;
        }
        return property;
    }

    boolean hasNoProperty() {
        return this.styleMap.isEmpty() || this.styleMap.values().stream().allMatch(Readable::isNullOrEmpty);
    }

    @Override
    public Style makeCopy() {
        Style copy = Style.newRandomStyle();
        this.styleMap.forEach((name, property) -> copy.styleMap.put((String)name, property.makeCopy()));
        return copy;
    }

    Style accumulate(Style other) {
        if (this == other || other == null || other.hasNoProperty()) {
            return this;
        }
        Style accumulated = this.makeCopy();
        other.styleMap.values().stream().filter(Readable::hasValue).forEach(accumulated::put);
        return accumulated;
    }

    public String getUuid() {
        return this.uuid;
    }

    public static class StyleBuilder {
        private final Style style;

        private StyleBuilder(Style style) {
            this.style = style;
        }

        public StyleBuilder fontName(String s) {
            this.style.put(StyleProperty.FontName.withValue(s));
            return this;
        }

        public StyleBuilder fontSize(short i) {
            this.style.put(StyleProperty.FontSize.withValue(i));
            return this;
        }

        public StyleBuilder bold(boolean b) {
            this.style.put(StyleProperty.Bold.withValue(b));
            return this;
        }

        public StyleBuilder underline(boolean b) {
            this.style.put(StyleProperty.Underline.withValue(b));
            return this;
        }

        public StyleBuilder indentation(short i) {
            this.style.put(StyleProperty.Indentation.withValue(i));
            return this;
        }

        public StyleBuilder wrapText(boolean b) {
            this.style.put(StyleProperty.WrapText.withValue(b));
            return this;
        }

        public StyleBuilder datePattern(String s) {
            return this.dataFormat(s);
        }

        public StyleBuilder dataFormat(String s) {
            this.style.put(StyleProperty.DataFormat.withValue(s));
            return this;
        }

        public StyleBuilder fontColor(IndexedColors color) {
            this.style.put(StyleProperty.FontColor.withValue(StyleColor.fromPredefined(color)));
            return this;
        }

        public StyleBuilder fontColorInHex(String hex) {
            this.style.put(StyleProperty.FontColor.withValue(StyleColor.fromHex(hex)));
            return this;
        }

        public StyleBuilder fontColorInRGB(int r, int g, int b) {
            this.style.put(StyleProperty.FontColor.withValue(StyleColor.fromRGB(r, g, b)));
            return this;
        }

        public StyleBuilder backgroundColor(IndexedColors color) {
            this.style.put(StyleProperty.BackgroundColor.withValue(StyleColor.fromPredefined(color)));
            return this;
        }

        public StyleBuilder backgroundColorInHex(String hex) {
            this.style.put(StyleProperty.BackgroundColor.withValue(StyleColor.fromHex(hex)));
            return this;
        }

        public StyleBuilder backgroundColorInRGB(int r, int g, int b) {
            this.style.put(StyleProperty.BackgroundColor.withValue(StyleColor.fromRGB(r, g, b)));
            return this;
        }

        public StyleBuilder horizontalAlignment(HorizontalAlignment alignment) {
            this.style.getOrDefault(StyleProperty.Alignments.withValue(new CopyableList())).getAny(CopyableList.class).ifPresent(l -> l.add(alignment));
            return this;
        }

        public StyleBuilder verticalAlignment(VerticalAlignment alignment) {
            this.style.getOrDefault(StyleProperty.Alignments.withValue(new CopyableList())).getAny(CopyableList.class).ifPresent(l -> l.add(alignment));
            return this;
        }

        private void addBorderSafely(Border border) {
            this.style.getOrDefault(StyleProperty.Borders.withValue(new CopyableList())).getAny(CopyableList.class).ifPresent(l -> l.add(border));
        }

        public StyleBuilder border(BorderSide borderSide) {
            this.addBorderSafely(new Border().side(borderSide));
            return this;
        }

        public StyleBuilder border(UnaryOperator<Border> borderBuilder) {
            Border border = (Border)borderBuilder.apply(new Border());
            this.addBorderSafely(border);
            return this;
        }

        public Style build() {
            return this.style;
        }
    }
}

