/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.style;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Node<T> {
    private final String id;
    private final Map<String, Node<T>> children;
    private T data;

    public Node(String id, T data) {
        this.id = id;
        this.data = data;
        this.children = new HashMap<String, Node<T>>();
    }

    public Node<T> getChild(String id) {
        return this.children.get(id);
    }

    public void addChild(String id, T data) {
        if (this.children.containsKey(id)) {
            return;
        }
        Node<T> child = new Node<T>(id, data);
        this.children.put(id, child);
    }

    public void addChild(Node<T> node) {
        if (this.children.containsKey(node.id)) {
            return;
        }
        this.children.put(node.id, node);
    }

    public Node<T> lookup(List<String> path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        Node current = this;
        for (String route : path) {
            if (current == null) break;
            current = current.children.getOrDefault(route, null);
        }
        return current;
    }

    public void updatePath(List<String> path, T newData) {
        Node<T> current = this;
        for (String route : path) {
            Node<Object> child = current.children.get(route);
            if (child == null) {
                child = new Node<Object>(route, null);
                current.children.put(child.id, child);
            }
            current = child;
        }
        current.setData(newData);
    }

    public int countAllChildren() {
        int total = this.data != null ? 1 : 0;
        for (Node<T> child : this.children.values()) {
            total += child.countAllChildren();
        }
        return total;
    }

    public String toString() {
        return String.format("[%s] %s (%d)", this.id, this.data.toString(), this.children.size());
    }

    public void setData(T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }
}

