/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.style;

import io.github.nambach.excelutil.style.StyleColor;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;

public class HSSFColorCache {
    private static final short MIN_INDEX = Stream.of(HSSFColor.HSSFColorPredefined.values()).map(HSSFColor.HSSFColorPredefined::getIndex).min(Short::compareTo).get();
    private static final short MAX_INDEX = Stream.of(HSSFColor.HSSFColorPredefined.values()).map(HSSFColor.HSSFColorPredefined::getIndex).max(Short::compareTo).get();
    private final HSSFPalette palette;
    private final HashMap<Integer, Short> cache = new HashMap();
    private Policy policy;

    public HSSFColorCache(HSSFWorkbook workbook, Policy policy) {
        this.palette = workbook.getCustomPalette();
        this.policy = policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public short getIndex(StyleColor color) {
        switch (this.policy) {
            case USE_MOST_SIMILAR: {
                if (color.isPreset()) {
                    return color.getHssfColor().getIndex();
                }
                return this.palette.findSimilarColor(color.getRed(), color.getGreen(), color.getBlue()).getIndex();
            }
            case OVERRIDE: {
                int rgb = color.getRGB();
                Short index = this.cache.get(rgb);
                if (index != null) {
                    return index;
                }
                index = this.findNextIndex();
                this.overridePalette(index, color.getTriplet());
                this.cache.put(rgb, index);
                return index;
            }
        }
        return HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex();
    }

    private void overridePalette(short index, short[] rgb) {
        this.palette.setColorAtIndex(index, (byte)rgb[0], (byte)rgb[1], (byte)rgb[2]);
    }

    private short findNextIndex() {
        for (short i = MIN_INDEX; i <= MAX_INDEX; i = (short)(i + 1)) {
            if (this.cache.containsValue(i)) continue;
            return i;
        }
        throw new RuntimeException("Exceeds limit colors of HSSFWorkbook");
    }

    int size() {
        return this.cache.size();
    }

    public static enum Policy {
        OVERRIDE,
        USE_MOST_SIMILAR;

    }
}

