/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.poi.ss.util.CellAddress;

interface Navigation<T extends Navigation<T>> {
    default public Collection<CellAddress> parseAddress(Collection<String> addresses) {
        if (addresses == null || addresses.isEmpty()) {
            return Collections.emptyList();
        }
        TreeSet<CellAddress> set = new TreeSet<CellAddress>(CellAddress::compareTo);
        for (String address : addresses) {
            if (address.contains(":")) {
                String[] split = address.split(":");
                CellAddress from = new CellAddress(split[0].trim());
                CellAddress to = new CellAddress(split[1].trim());
                for (int rowNo = from.getRow(); rowNo <= to.getRow(); ++rowNo) {
                    for (int colNo = from.getColumn(); colNo <= to.getColumn(); ++colNo) {
                        set.add(new CellAddress(rowNo, colNo));
                    }
                }
                continue;
            }
            set.add(new CellAddress(address.trim()));
        }
        return set;
    }

    public T goToCell(String var1);

    public T goToCell(int var1, int var2);

    public T next();

    public T next(int var1);

    public T down();

    public T down(int var1);

    public T enter();

    public T enter(int var1);
}

