/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.util.CellRangeAddress;

class MergeItem {
    private Object lastValue;
    private int fromRow;
    private int toRow;

    public MergeItem(Object lastValue, int fromRow, int toRow) {
        this.lastValue = lastValue;
        this.fromRow = fromRow;
        this.toRow = toRow;
    }

    public void handleMerge(Cell cell) {
        if (this.needMerge()) {
            cell.getCellStyle().setWrapText(true);
            cell.getSheet().addMergedRegionUnsafe(new CellRangeAddress(this.fromRow, this.toRow, cell.getColumnIndex(), cell.getColumnIndex()));
        }
    }

    public void reset(Object currentValue, int startRow) {
        this.fromRow = startRow;
        this.toRow = startRow;
        this.lastValue = currentValue;
    }

    public void increaseRange() {
        ++this.toRow;
    }

    public boolean needMerge() {
        return this.toRow - this.fromRow > 0;
    }

    public Object getLastValue() {
        return this.lastValue;
    }

    public int getFromRow() {
        return this.fromRow;
    }

    public int getToRow() {
        return this.toRow;
    }

    public void setLastValue(Object lastValue) {
        this.lastValue = lastValue;
    }

    public void setFromRow(int fromRow) {
        this.fromRow = fromRow;
    }

    public void setToRow(int toRow) {
        this.toRow = toRow;
    }
}

