/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.core.ReaderCell;
import io.github.nambach.excelutil.util.ReflectUtil;
import io.github.nambach.excelutil.validator.builtin.TypeValidator;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Handler<T> {
    private static final Logger log = LogManager.getLogger(Handler.class);
    private static final Map<Class<?>, Function<ReaderCell, Object>> FIELD_READERS = new HashMap();
    private Integer colAt;
    private Integer colFrom;
    private String colTitle;
    private String fieldName;
    private BiConsumer<T, ReaderCell> coreHandler;
    private TypeValidator typeValidator;

    Handler() {
    }

    public Handler<T> atColumn(int i) {
        this.colAt = i;
        return this;
    }

    public Handler<T> atColumn(String colTitle) {
        this.colTitle = colTitle;
        return this;
    }

    public Handler<T> fromColumn(int i) {
        this.colFrom = i;
        return this;
    }

    Handler<T> field(String s) {
        this.fieldName = s;
        return this;
    }

    public Handler<T> validate(TypeValidator typeValidator) {
        this.typeValidator = typeValidator;
        return this;
    }

    public Handler<T> validate(UnaryOperator<TypeValidator> builder) {
        this.typeValidator = (TypeValidator)builder.apply(TypeValidator.init());
        return this;
    }

    public Handler<T> handle(BiConsumer<T, ReaderCell> handler) {
        Objects.requireNonNull(handler);
        this.coreHandler = ReflectUtil.safeWrap(handler);
        return this;
    }

    boolean needValidation() {
        return this.typeValidator != null;
    }

    protected Handler<T> wrapHandleField(PropertyDescriptor pd) {
        Method setter = pd.getWriteMethod();
        Class<?> type = pd.getPropertyType();
        this.coreHandler = (object, cell) -> {
            Function<ReaderCell, Object> reader = FIELD_READERS.get(type);
            Object cellValue = reader == null ? null : reader.apply((ReaderCell)cell);
            try {
                setter.invoke(object, cellValue);
            }
            catch (Exception e) {
                log.error("Error while invoking setter.", (Throwable)e);
            }
        };
        return this;
    }

    Integer getColAt() {
        return this.colAt;
    }

    Integer getColFrom() {
        return this.colFrom;
    }

    String getColTitle() {
        return this.colTitle;
    }

    String getFieldName() {
        return this.fieldName;
    }

    BiConsumer<T, ReaderCell> getCoreHandler() {
        return this.coreHandler;
    }

    TypeValidator getTypeValidator() {
        return this.typeValidator;
    }

    void setColAt(Integer colAt) {
        this.colAt = colAt;
    }

    void setColFrom(Integer colFrom) {
        this.colFrom = colFrom;
    }

    void setColTitle(String colTitle) {
        this.colTitle = colTitle;
    }

    void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    void setCoreHandler(BiConsumer<T, ReaderCell> coreHandler) {
        this.coreHandler = coreHandler;
    }

    void setTypeValidator(TypeValidator typeValidator) {
        this.typeValidator = typeValidator;
    }

    static {
        Map<Class<?>, Function<ReaderCell, Object>> o = FIELD_READERS;
        o.put(String.class, ReaderCell::readString);
        o.put(Long.class, ReaderCell::readLong);
        o.put(Long.TYPE, ReaderCell::readLong);
        o.put(Integer.class, ReaderCell::readInt);
        o.put(Integer.TYPE, ReaderCell::readInt);
        o.put(Double.class, ReaderCell::readDouble);
        o.put(Double.TYPE, ReaderCell::readDouble);
        o.put(Float.class, ReaderCell::readFloat);
        o.put(Float.TYPE, ReaderCell::readFloat);
        o.put(Boolean.class, ReaderCell::readBoolean);
        o.put(Boolean.TYPE, ReaderCell::readBoolean);
        o.put(Date.class, ReaderCell::readDate);
        o.put(LocalDateTime.class, ReaderCell::readLocalDateTime);
    }
}

