/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.core.BaseEditor;
import io.github.nambach.excelutil.core.Handler;
import io.github.nambach.excelutil.core.HandlerMap;
import io.github.nambach.excelutil.core.Raw;
import io.github.nambach.excelutil.core.ReaderCell;
import io.github.nambach.excelutil.core.ReaderConfig;
import io.github.nambach.excelutil.core.ReaderRow;
import io.github.nambach.excelutil.core.Result;
import io.github.nambach.excelutil.validator.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

class BaseReader
implements BaseEditor {
    BaseReader() {
    }

    private <T> T createObject(Class<T> tClass) {
        try {
            return tClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Please provide a no argument constructor for class " + tClass.getName(), e);
        }
    }

    public <T> Result<T> readSheet(Sheet sheet, ReaderConfig<T> baseConfig, int rowAt, int colAt) {
        Result result = new Result(baseConfig.getTClass());
        if (sheet.getPhysicalNumberOfRows() == 0) {
            return result;
        }
        ReaderConfig<T> config = baseConfig.translate(rowAt, colAt);
        HandlerMap<T> handlerMap = config.getHandlerMap();
        HashMap<Integer, String> titleMap = new HashMap<Integer, String>();
        int rowTitleIndex = config.getTitleRowIndex();
        int rowTitleCount = rowTitleIndex >= 0 ? 1 : 0;
        this.readTitleRow(sheet, colAt, rowTitleIndex, titleMap);
        for (Row currentRow : sheet) {
            int rowIndex = currentRow.getRowNum();
            if (rowIndex < rowAt + rowTitleCount) continue;
            T object = this.createObject(config.getTClass());
            Raw<T> raw = new Raw<T>();
            raw.setData(object);
            for (Cell cell : currentRow) {
                String colTitle;
                HandlerMap.Handlers<T> handlers;
                int colIndex = cell.getColumnIndex();
                if (colIndex < colAt || (handlers = handlerMap.get(colIndex, colTitle = (String)titleMap.get(colIndex))) == null) continue;
                ReaderCell readerCell = new ReaderCell(cell, colTitle, config, result);
                for (Handler handler : handlers) {
                    Field<T> fieldValidator;
                    BiConsumer<T, ReaderCell> handle = handler.getCoreHandler();
                    String fieldName = handler.getFieldName();
                    if (handler.needValidation()) {
                        readerCell.validate(handler.getTypeValidator(), fieldName);
                    }
                    if (config.getValidator() != null && (fieldValidator = config.getValidator().getField(fieldName)) != null) {
                        readerCell.validate(fieldValidator.getTypeValidator(), fieldName);
                    }
                    if (handle != null) {
                        handle.accept(object, readerCell);
                    }
                    if (!readerCell.isExitNow()) continue;
                    return result;
                }
                if (!handlers.isEmpty()) continue;
                this.handleOther(raw, cell, colTitle);
            }
            ReaderRow readerRow = new ReaderRow(currentRow, config, result);
            config.handleBeforeAdd(object, readerRow);
            if (readerRow.isExitNow()) {
                return result;
            }
            if (readerRow.isSkipThisObject()) continue;
            result.addRaw(raw);
        }
        return result;
    }

    private void readTitleRow(Sheet sheet, int colAt, int titleIndex, Map<Integer, String> titleMap) {
        if (titleIndex < 0) {
            return;
        }
        Row titleRow = sheet.getRow(titleIndex);
        if (titleRow == null) {
            throw new RuntimeException("Title row at index " + titleIndex + " not found");
        }
        for (Cell cell : titleRow) {
            if (cell.getColumnIndex() < colAt) continue;
            titleMap.put(cell.getColumnIndex(), cell.getStringCellValue());
        }
    }

    private <T> void handleOther(Raw<T> raw, Cell cell, String colTitle) {
        String key = colTitle != null ? colTitle : cell.getColumnIndex() + "";
        switch (cell.getCellType()) {
            case STRING: 
            case FORMULA: {
                raw.getOtherData().put(key, cell.getStringCellValue());
                break;
            }
            case NUMERIC: {
                raw.getOtherData().put(key, cell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                raw.getOtherData().put(key, cell.getBooleanCellValue());
                break;
            }
        }
    }
}

