/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.core.PointerNavigation;
import io.github.nambach.excelutil.core.ReaderCell;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

interface BaseEditor {
    default public Row getRowAt(Sheet sheet, int rowAt) {
        Row row = sheet.getRow(rowAt);
        if (row == null) {
            row = sheet.createRow(rowAt);
        }
        return row;
    }

    default public Cell getCellAt(Row row, int colAt) {
        return row.getCell(colAt, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
    }

    default public Cell getCellAt(Sheet sheet, PointerNavigation navigation) {
        Row row = this.getRowAt(sheet, navigation.getRow());
        return this.getCellAt(row, navigation.getCol());
    }

    default public ReaderCell getReaderCellAt(Sheet sheet, PointerNavigation pointer) {
        Cell cell = this.getCellAt(this.getRowAt(sheet, pointer.getRow()), pointer.getCol());
        return ReaderCell.wrap(cell);
    }

    default public boolean isDateType(Object value) {
        return value instanceof Date || value instanceof LocalDateTime || value instanceof LocalDate;
    }
}

