/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.KeyPair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.exception.BatchWriteException;
import org.socialsignin.spring.data.dynamodb.repository.DynamoDBCrudRepository;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.EnableScanPermissions;
import org.socialsignin.spring.data.dynamodb.utils.ExceptionHandler;
import org.socialsignin.spring.data.dynamodb.utils.SortHandler;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class SimpleDynamoDBCrudRepository<T, ID>
implements DynamoDBCrudRepository<T, ID>,
SortHandler,
ExceptionHandler {
    protected DynamoDBEntityInformation<T, ID> entityInformation;
    protected Class<T> domainType;
    protected EnableScanPermissions enableScanPermissions;
    protected DynamoDBOperations dynamoDBOperations;

    public SimpleDynamoDBCrudRepository(DynamoDBEntityInformation<T, ID> entityInformation, DynamoDBOperations dynamoDBOperations, EnableScanPermissions enableScanPermissions) {
        Assert.notNull(entityInformation, (String)"entityInformation must not be null");
        Assert.notNull((Object)dynamoDBOperations, (String)"dynamoDBOperations must not be null");
        this.entityInformation = entityInformation;
        this.dynamoDBOperations = dynamoDBOperations;
        this.domainType = entityInformation.getJavaType();
        this.enableScanPermissions = enableScanPermissions;
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        T result = this.entityInformation.isRangeKeyAware() ? this.dynamoDBOperations.load(this.domainType, this.entityInformation.getHashKey(id), this.entityInformation.getRangeKey(id)) : this.dynamoDBOperations.load(this.domainType, this.entityInformation.getHashKey(id));
        return Optional.ofNullable(result);
    }

    public List<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given ids must not be null!");
        AtomicInteger idx = new AtomicInteger();
        List<KeyPair> keyPairs = StreamSupport.stream(ids.spliterator(), false).map(id -> {
            Assert.notNull((Object)id, (String)("The given id at position " + idx.getAndIncrement() + " must not be null!"));
            if (this.entityInformation.isRangeKeyAware()) {
                return new KeyPair().withHashKey(this.entityInformation.getHashKey(id)).withRangeKey(this.entityInformation.getRangeKey(id));
            }
            return new KeyPair().withHashKey(id);
        }).toList();
        Map<Class<?>, List<KeyPair>> keyPairsMap = Collections.singletonMap(this.domainType, keyPairs);
        return this.dynamoDBOperations.batchLoad(keyPairsMap);
    }

    public <S extends T> S save(S entity) {
        this.dynamoDBOperations.save(entity);
        return entity;
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) throws BatchWriteException, IllegalArgumentException {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        List<DynamoDBMapper.FailedBatch> failedBatches = this.dynamoDBOperations.batchSave(entities);
        if (failedBatches.isEmpty()) {
            return entities;
        }
        throw (BatchWriteException)this.repackageToException(failedBatches, BatchWriteException.class);
    }

    public boolean existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.findById(id).isPresent();
    }

    void assertScanEnabled(boolean scanEnabled, String methodName) {
        Assert.isTrue((boolean)scanEnabled, (String)("Scanning for unpaginated " + methodName + "() queries is not enabled.  To enable, re-implement the " + methodName + "() method in your repository interface and annotate with @EnableScan, or enable scanning for all repository methods by annotating your repository interface with @EnableScan"));
    }

    public List<T> findAll() {
        this.assertScanEnabled(this.enableScanPermissions.isFindAllUnpaginatedScanEnabled(), "findAll");
        DynamoDBScanExpression scanExpression = new DynamoDBScanExpression();
        return this.dynamoDBOperations.scan(this.domainType, scanExpression);
    }

    public long count() {
        this.assertScanEnabled(this.enableScanPermissions.isCountUnpaginatedScanEnabled(), "count");
        DynamoDBScanExpression scanExpression = new DynamoDBScanExpression();
        return this.dynamoDBOperations.count(this.domainType, scanExpression);
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        Optional<T> entity = this.findById(id);
        if (!entity.isPresent()) {
            throw new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.domainType, id), 1);
        }
        this.dynamoDBOperations.delete(entity.get());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The entity must not be null!");
        this.dynamoDBOperations.delete(entity);
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        List<Object> bla = StreamSupport.stream(ids.spliterator(), false).map(id -> id).toList();
        this.deleteAll(this.findAllById(bla));
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        this.dynamoDBOperations.batchDelete(entities);
    }

    public void deleteAll() {
        this.assertScanEnabled(this.enableScanPermissions.isDeleteAllUnpaginatedScanEnabled(), "deleteAll");
        this.dynamoDBOperations.batchDelete(this.findAll());
    }

    @NonNull
    public DynamoDBEntityInformation<T, ID> getEntityInformation() {
        return this.entityInformation;
    }
}

