/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.cdi;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.ProcessBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.repository.cdi.DynamoDBRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;

public class DynamoDBRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDBRepositoryExtension.class);
    private final Map<Set<Annotation>, Bean<AmazonDynamoDB>> amazonDynamoDBs = new HashMap<Set<Annotation>, Bean<AmazonDynamoDB>>();
    private final Map<Set<Annotation>, Bean<DynamoDBOperations>> dynamoDBOperationss = new HashMap<Set<Annotation>, Bean<DynamoDBOperations>>();
    private final Map<Set<Annotation>, Bean<DynamoDBMapperConfig>> dbMapperConfigs = new HashMap<Set<Annotation>, Bean<DynamoDBMapperConfig>>();
    private final Map<Set<Annotation>, Bean<DynamoDBMapper>> dbMapper = new HashMap<Set<Annotation>, Bean<DynamoDBMapper>>();

    public DynamoDBRepositoryExtension() {
        LOGGER.info("Activating CDI extension for Spring Data DynamoDB repositories.");
    }

    <X> void processBean(@Observes ProcessBean<X> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            HashSet qualifiers;
            if (type instanceof Class && AmazonDynamoDBClient.class.isAssignableFrom((Class)type)) {
                qualifiers = new HashSet(bean.getQualifiers());
                if (bean.isAlternative() || !this.amazonDynamoDBs.containsKey(qualifiers)) {
                    LOGGER.debug("Discovered '{}' with qualifiers {}.", (Object)AmazonDynamoDB.class.getName(), qualifiers);
                    this.amazonDynamoDBs.put(qualifiers, (Bean<AmazonDynamoDB>)bean);
                }
            }
            if (type instanceof Class && DynamoDBMapperConfig.class.isAssignableFrom((Class)type)) {
                qualifiers = new HashSet(bean.getQualifiers());
                if (bean.isAlternative() || !this.dbMapperConfigs.containsKey(qualifiers)) {
                    LOGGER.debug("Discovered '{}' with qualifiers {}.", (Object)DynamoDBMapperConfig.class.getName(), qualifiers);
                    this.dbMapperConfigs.put(qualifiers, (Bean<DynamoDBMapperConfig>)bean);
                }
            }
            if (!(type instanceof Class) || !DynamoDBMapper.class.isAssignableFrom((Class)type)) continue;
            qualifiers = new HashSet(bean.getQualifiers());
            if (!bean.isAlternative() && this.dbMapper.containsKey(qualifiers)) continue;
            LOGGER.debug("Discovered '{}' with qualifiers {}.", (Object)DynamoDBMapper.class.getName(), qualifiers);
            this.dbMapper.put(qualifiers, (Bean<DynamoDBMapper>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            Bean repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            LOGGER.info("Registering bean for '{}' with qualifiers {}.", (Object)repositoryType.getName(), (Object)qualifiers);
            afterBeanDiscovery.addBean(repositoryBean);
        }
    }

    private <T> Bean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<AmazonDynamoDB> amazonDynamoDBBean = this.amazonDynamoDBs.get(qualifiers);
        Bean<DynamoDBMapperConfig> dynamoDBMapperConfigBean = this.dbMapperConfigs.get(qualifiers);
        Bean<DynamoDBOperations> dynamoDBOperationsBean = this.dynamoDBOperationss.get(qualifiers);
        if (amazonDynamoDBBean == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", AmazonDynamoDBClient.class.getName(), qualifiers));
        }
        Bean<DynamoDBMapper> dynamoDBMapperBean = this.dbMapper.get(qualifiers);
        return new DynamoDBRepositoryBean<T>(beanManager, amazonDynamoDBBean, dynamoDBMapperConfigBean, dynamoDBOperationsBean, dynamoDBMapperBean, qualifiers, repositoryType);
    }
}

