/*
 * Decompiled with CFR 0.152.
 */
package com.privacylogistics;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FF3Cipher {
    private static final int NUM_ROUNDS = 8;
    private static final int BLOCK_SIZE = 16;
    private static final int TWEAK_LEN = 8;
    private static final int TWEAK_LEN_NEW = 7;
    private static final int HALF_TWEAK_LEN = 4;
    private static int MAX_RADIX = 256;
    private static final Logger logger = LogManager.getLogger((String)FF3Cipher.class.getName());
    public static int DOMAIN_MIN = 1000000;
    public static final String DIGITS = "0123456789";
    public static final String ASCII_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String ASCII_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final int radix;
    private final String alphabet;
    private byte[] tweakBytes;
    private final int minLen;
    private final int maxLen;
    private final Cipher aesCipher;

    public FF3Cipher(String key, String tweak) {
        this(key, tweak, 10);
    }

    public FF3Cipher(String key, String tweak, String alphabet) {
        this.alphabet = alphabet;
        this.radix = alphabet.length();
        byte[] keyBytes = FF3Cipher.hexStringToByteArray(key);
        this.minLen = (int)Math.ceil(Math.log(DOMAIN_MIN) / Math.log(this.radix));
        this.maxLen = (int)(2.0 * Math.floor(Math.log(Math.pow(2.0, 96.0)) / Math.log(this.radix)));
        int keyLen = keyBytes.length;
        if (keyLen != 16 && keyLen != 24 && keyLen != 32) {
            throw new IllegalArgumentException("key length " + keyLen + " but must be 128, 192, or 256 bits");
        }
        if (this.radix < 2 || this.radix > MAX_RADIX) {
            throw new IllegalArgumentException("radix must be between 2 and 256, inclusive");
        }
        if (this.minLen < 2 || this.maxLen < this.minLen) {
            throw new IllegalArgumentException("minLen or maxLen invalid, adjust your radix");
        }
        this.tweakBytes = FF3Cipher.hexStringToByteArray(tweak);
        try {
            this.reverseBytes(keyBytes);
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
            this.aesCipher = Cipher.getInstance("AES/ECB/NoPadding");
            this.aesCipher.init(1, keySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public FF3Cipher(String key, String tweak, int radix) {
        this(key, tweak, FF3Cipher.alphabetForBase(radix));
    }

    public String encrypt(String plaintext, String tweak) throws BadPaddingException, IllegalBlockSizeException {
        this.tweakBytes = FF3Cipher.hexStringToByteArray(tweak);
        return this.encrypt(plaintext);
    }

    public String encrypt(String plaintext) throws BadPaddingException, IllegalBlockSizeException {
        int n = plaintext.length();
        if (n < this.minLen || n > this.maxLen) {
            throw new IllegalArgumentException(String.format("message length %d is not within min %d and max %d bounds", n, this.minLen, this.maxLen));
        }
        int u = (int)Math.ceil((double)n / 2.0);
        int v = n - u;
        String A = plaintext.substring(0, u);
        String B = plaintext.substring(u);
        logger.trace("r {} A {} B {}", (Object)this.radix, (Object)A, (Object)B);
        if (this.tweakBytes.length != 8 && this.tweakBytes.length != 7) {
            throw new IllegalArgumentException(String.format("tweak length %d is invalid: tweak must be 56 or 64 bits", this.tweakBytes.length));
        }
        logger.trace("tweak: {}", (Object)FF3Cipher.byteArrayToHexString(this.tweakBytes));
        byte[] tweak64 = this.tweakBytes.length == 7 ? FF3Cipher.calculateTweak64_FF3_1(this.tweakBytes) : this.tweakBytes;
        byte[] Tl = Arrays.copyOf(tweak64, 4);
        byte[] Tr = Arrays.copyOfRange(tweak64, 4, 8);
        BigInteger modU = BigInteger.valueOf(this.radix).pow(u);
        BigInteger modV = BigInteger.valueOf(this.radix).pow(v);
        logger.trace("u {} v {} modU: {} modV: {}", (Object)u, (Object)v, (Object)modU, (Object)modV);
        logger.trace("tL: {} tR: {}", (Object)FF3Cipher.byteArrayToHexString(Tl), (Object)FF3Cipher.byteArrayToHexString(Tr));
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            byte[] W;
            int m;
            if (i % 2 == 0) {
                m = u;
                W = Tr;
            } else {
                m = v;
                W = Tl;
            }
            byte[] P = FF3Cipher.calculateP(i, this.alphabet, W, B);
            this.reverseBytes(P);
            byte[] S = this.aesCipher.doFinal(P);
            this.reverseBytes(S);
            logger.trace("\tS: {}", (Object)FF3Cipher.byteArrayToHexString(S));
            BigInteger y = new BigInteger(FF3Cipher.byteArrayToHexString(S), 16);
            BigInteger c = FF3Cipher.decode_int(FF3Cipher.reverseString(A), this.alphabet);
            c = c.add(y);
            c = i % 2 == 0 ? c.mod(modU) : c.mod(modV);
            logger.trace("\tm: {} A: {} c: {} y: {}", (Object)m, (Object)A, (Object)c, (Object)y);
            String C = FF3Cipher.encode_int_r(c, this.alphabet, m);
            A = B;
            B = C;
            logger.trace("A: {} B: {}", (Object)A, (Object)B);
        }
        return A + B;
    }

    public String decrypt(String ciphertext, String tweak) throws BadPaddingException, IllegalBlockSizeException {
        this.tweakBytes = FF3Cipher.hexStringToByteArray(tweak);
        return this.decrypt(ciphertext);
    }

    public String decrypt(String ciphertext) throws BadPaddingException, IllegalBlockSizeException {
        int n = ciphertext.length();
        if (n < this.minLen || n > this.maxLen) {
            throw new IllegalArgumentException(String.format("message length %d is not within min %d and max %d bounds", n, this.minLen, this.maxLen));
        }
        int u = (int)Math.ceil((double)n / 2.0);
        int v = n - u;
        String A = ciphertext.substring(0, u);
        String B = ciphertext.substring(u);
        if (this.tweakBytes.length != 8 && this.tweakBytes.length != 7) {
            throw new IllegalArgumentException(String.format("tweak length %d is invalid: tweak must be 56 or 64 bits", this.tweakBytes.length));
        }
        logger.trace("tweak: {}", (Object)FF3Cipher.byteArrayToHexString(this.tweakBytes));
        byte[] tweak64 = this.tweakBytes.length == 7 ? FF3Cipher.calculateTweak64_FF3_1(this.tweakBytes) : this.tweakBytes;
        byte[] Tl = Arrays.copyOf(tweak64, 4);
        byte[] Tr = Arrays.copyOfRange(tweak64, 4, 8);
        BigInteger modU = BigInteger.valueOf(this.radix).pow(u);
        BigInteger modV = BigInteger.valueOf(this.radix).pow(v);
        logger.trace("modU: {} modV: {}", (Object)modU, (Object)modV);
        logger.trace("tL: {} tR: {}", (Object)FF3Cipher.byteArrayToHexString(Tl), (Object)FF3Cipher.byteArrayToHexString(Tr));
        for (int i = 7; i >= 0; i = (int)((byte)(i - 1))) {
            byte[] W;
            int m;
            if (i % 2 == 0) {
                m = u;
                W = Tr;
            } else {
                m = v;
                W = Tl;
            }
            byte[] P = FF3Cipher.calculateP(i, this.alphabet, W, A);
            this.reverseBytes(P);
            byte[] S = this.aesCipher.doFinal(P);
            this.reverseBytes(S);
            logger.trace("\tS: {}", (Object)FF3Cipher.byteArrayToHexString(S));
            BigInteger y = new BigInteger(FF3Cipher.byteArrayToHexString(S), 16);
            BigInteger c = FF3Cipher.decode_int(FF3Cipher.reverseString(B), this.alphabet);
            c = c.subtract(y);
            c = i % 2 == 0 ? c.mod(modU) : c.mod(modV);
            logger.trace("\tm: {} B: {} c: {} y: {}", (Object)m, (Object)B, (Object)c, (Object)y);
            String C = FF3Cipher.encode_int_r(c, this.alphabet, m);
            B = A;
            A = C;
            logger.trace("A: {} B: {}", (Object)A, (Object)B);
        }
        return A + B;
    }

    protected static byte[] calculateTweak64_FF3_1(byte[] tweak56) {
        byte[] tweak64 = new byte[]{tweak56[0], tweak56[1], tweak56[2], (byte)(tweak56[3] & 0xF0), tweak56[4], tweak56[5], tweak56[6], (byte)((tweak56[3] & 0xF) << 4)};
        return tweak64;
    }

    protected static byte[] calculateP(int i, String alphabet, byte[] W, String B) {
        byte[] P = new byte[16];
        P[0] = W[0];
        P[1] = W[1];
        P[2] = W[2];
        P[3] = (byte)(W[3] ^ i);
        B = FF3Cipher.reverseString(B);
        byte[] bBytes = FF3Cipher.decode_int(B, alphabet).toByteArray();
        System.arraycopy(bBytes, 0, P, 16 - bBytes.length, bBytes.length);
        logger.trace("round: {} W: {} P: {}", (Object)i, (Object)FF3Cipher.byteArrayToHexString(W), (Object)FF3Cipher.byteArrayToIntString(P));
        return P;
    }

    protected static String reverseString(String s) {
        return new StringBuilder(s).reverse().toString();
    }

    protected void reverseBytes(byte[] b) {
        for (int i = 0; i < b.length / 2; ++i) {
            byte temp = b[i];
            b[i] = b[b.length - i - 1];
            b[b.length - i - 1] = temp;
        }
    }

    protected static byte[] hexStringToByteArray(String s) {
        byte[] data = new byte[s.length() / 2];
        for (int i = 0; i < s.length(); i += 2) {
            data[i / 2] = Integer.decode("0x" + s.charAt(i) + s.charAt(i + 1)).byteValue();
        }
        return data;
    }

    protected static String byteArrayToHexString(byte[] byteArray) {
        StringBuilder sb = new StringBuilder();
        for (byte b : byteArray) {
            String aByte = String.format("%02X", b);
            sb.append(aByte);
        }
        return sb.toString();
    }

    protected static String byteArrayToIntString(byte[] byteArray) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (byte b : byteArray) {
            String aByte = String.format("%d ", b & 0xFF);
            sb.append(aByte);
        }
        sb.append(']');
        return sb.toString();
    }

    protected static String encode_int_r(BigInteger n, String alphabet, int length) {
        char[] x = new char[length];
        int i = 0;
        BigInteger bbase = BigInteger.valueOf(alphabet.length());
        while (n.compareTo(bbase) >= 0) {
            BigInteger b = n.mod(bbase);
            n = n.divide(bbase);
            x[i++] = alphabet.charAt(b.intValue());
        }
        x[i++] = alphabet.charAt(n.intValue());
        while (i < length) {
            x[i++] = alphabet.charAt(0);
        }
        return new String(x);
    }

    protected static BigInteger decode_int(String str, String alphabet) {
        int strlen = str.length();
        BigInteger base = BigInteger.valueOf(alphabet.length());
        BigInteger num = BigInteger.ZERO;
        int idx = 0;
        for (char each : str.toCharArray()) {
            int exponent = strlen - (idx + 1);
            num = num.add(base.pow(exponent).multiply(BigInteger.valueOf(alphabet.indexOf(each))));
            ++idx;
        }
        return num;
    }

    protected static String alphabetForBase(int base) {
        switch (base) {
            case 10: {
                return DIGITS;
            }
            case 26: {
                return "0123456789abcdefghijklmnop";
            }
            case 36: {
                return "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            }
            case 64: {
                return "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
            }
        }
        throw new RuntimeException("Unsupported radix");
    }
}

