/*
 * Decompiled with CFR 0.152.
 */
package io.github.mweirauch.micrometer.jvm.extras;

import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsStatus;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Locale;
import java.util.Objects;

public class ProcessMemoryMetrics
implements MeterBinder {
    private final ProcfsStatus status;

    public ProcessMemoryMetrics() {
        this(ProcfsStatus.getInstance());
    }

    ProcessMemoryMetrics(ProcfsStatus status) {
        this.status = Objects.requireNonNull(status);
    }

    public void bindTo(MeterRegistry registry) {
        ProcfsStatus.KEY[] keys;
        for (ProcfsStatus.KEY key : keys = new ProcfsStatus.KEY[]{ProcfsStatus.KEY.VSS, ProcfsStatus.KEY.RSS, ProcfsStatus.KEY.SWAP}) {
            String name = "process.memory." + key.name().toLowerCase(Locale.ENGLISH);
            Gauge.builder((String)name, (Object)this.status, statusRef -> this.value(key)).baseUnit("bytes").register(registry);
        }
    }

    private Double value(ProcfsStatus.KEY key) {
        return this.status.get(key);
    }
}

