/*
 * Decompiled with CFR 0.152.
 */
package io.github.mweirauch.micrometer.jvm.extras.procfs;

import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsEntry;
import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsReader;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcfsSmaps
extends ProcfsEntry {
    private static final Pattern LINE_PATTERN = Pattern.compile("^\\w+:\\s+(\\d+)\\skB$");
    private static final int KILOBYTE = 1024;

    public ProcfsSmaps() {
        super(ProcfsReader.getInstance("smaps"));
    }

    ProcfsSmaps(ProcfsReader reader) {
        super(reader);
    }

    @Override
    protected void handle(Map<ProcfsEntry.ValueKey, Double> values, String line) {
        Objects.requireNonNull(values);
        Objects.requireNonNull(line);
        KEY valueKey = null;
        if (line.startsWith("Size:")) {
            valueKey = KEY.VSS;
        } else if (line.startsWith("Rss:")) {
            valueKey = KEY.RSS;
        } else if (line.startsWith("Pss:")) {
            valueKey = KEY.PSS;
        } else if (line.startsWith("Swap:")) {
            valueKey = KEY.SWAP;
        } else if (line.startsWith("SwapPss:")) {
            valueKey = KEY.SWAPPSS;
        }
        if (valueKey != null) {
            Double kiloBytes = ProcfsSmaps.parseKiloBytes(line) * 1024.0;
            values.compute(valueKey, (key, value) -> value == null ? kiloBytes : value + kiloBytes);
        }
    }

    private static Double parseKiloBytes(String line) {
        Objects.requireNonNull(line);
        Matcher matcher = LINE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return Double.NaN;
        }
        return Double.parseDouble(matcher.group(1));
    }

    public static enum KEY implements ProcfsEntry.ValueKey
    {
        VSS,
        RSS,
        PSS,
        SWAP,
        SWAPPSS;

    }
}

