/*
 * Decompiled with CFR 0.152.
 */
package io.github.mweirauch.micrometer.jvm.extras.procfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProcfsReader {
    private static final Logger log = LoggerFactory.getLogger(ProcfsReader.class);
    private static final Map<String, ProcfsReader> instances = new HashMap<String, ProcfsReader>();
    private static final Object instancesLock = new Object();
    private static final Path BASE = Paths.get("/proc", "self");
    private final Path entryPath;
    private final boolean osSupport;

    private ProcfsReader(String entry) {
        this(BASE, entry, false);
    }

    ProcfsReader(Path base, String entry) {
        this(base, entry, true);
    }

    ProcfsReader(Path base, String entry, boolean forceOSSupport) {
        Objects.requireNonNull(base);
        Objects.requireNonNull(entry);
        this.entryPath = base.resolve(entry);
        this.osSupport = forceOSSupport || System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("linux");
    }

    Path getEntryPath() {
        return this.entryPath;
    }

    void read(Consumer<String> consumer) throws IOException {
        this.readPath(this.entryPath, consumer);
    }

    private void readPath(Path path, Consumer<String> consumer) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(consumer);
        if (!this.osSupport) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Reading '" + path + "'");
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line;
            while ((line = reader.readLine()) != null) {
                consumer.accept(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ProcfsReader getInstance(String entry) {
        Objects.requireNonNull(entry);
        Object object = instancesLock;
        synchronized (object) {
            ProcfsReader reader = instances.get(entry);
            if (reader == null) {
                reader = new ProcfsReader(entry);
                instances.put(entry, reader);
            }
            return instances.get(entry);
        }
    }
}

