/*
 * Decompiled with CFR 0.152.
 */
package io.github.mweirauch.micrometer.jvm.extras;

import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsStatus;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Collections;
import java.util.Objects;

public class ProcessThreadMetrics
implements MeterBinder {
    private final ProcfsStatus status;

    public ProcessThreadMetrics() {
        this.status = new ProcfsStatus();
    }

    ProcessThreadMetrics(ProcfsStatus status) {
        this.status = Objects.requireNonNull(status);
    }

    public void bindTo(MeterRegistry registry) {
        Meter.Id meterId = registry.createId("process.threads", Collections.emptyList(), "The number of process threads");
        registry.gauge(meterId, (Object)this.status, statusRef -> this.value(ProcfsStatus.KEY.THREADS));
    }

    private Double value(ProcfsStatus.KEY key) {
        return this.status.get(key);
    }
}

