/*
 * Decompiled with CFR 0.152.
 */
package open.HL7PET.tools;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.NoSuchElementException;
import open.HL7PET.tools.ERROR$;
import open.HL7PET.tools.ErrorEntry;
import open.HL7PET.tools.HL7ParseError;
import open.HL7PET.tools.HL7ParseError$;
import open.HL7PET.tools.HL7ParseUtils;
import open.HL7PET.tools.ValidationErrors;
import open.HL7PET.tools.model.HL7SegmentField;
import open.HL7PET.tools.model.Profile;
import open.HL7PET.tools.model.SegmentConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001\u0002\u0011\"\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tw\u0001\u0011\t\u0019!C\u0001y!A1\t\u0001BA\u0002\u0013\u0005A\t\u0003\u0005K\u0001\t\u0005\t\u0015)\u0003>\u0011!Y\u0005A!a\u0001\n\u0003a\u0004\u0002\u0003'\u0001\u0005\u0003\u0007I\u0011A'\t\u0011=\u0003!\u0011!Q!\nuBQ\u0001\u0015\u0001\u0005\u0002ECqa\u0016\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004b\u0001\u0001\u0006I!\u0017\u0005\bE\u0002\u0011\r\u0011\"\u0001Y\u0011\u0019\u0019\u0007\u0001)A\u00053\"9A\r\u0001b\u0001\n\u0003)\u0007B\u0002:\u0001A\u0003%a\rC\u0004t\u0001\t\u0007I\u0011\u0001;\t\ra\u0004\u0001\u0015!\u0003v\u0011\u001dI\bA1A\u0005\niDq!!\u0006\u0001A\u0003%1\u0010C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA\"\u0001\u0011%\u0011Q\t\u0005\b\u0003\u0013\u0002A\u0011BA&\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Bq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBAX\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0003\u001b\u0004A\u0011BAh\u0011\u001d\ti\u000e\u0001C\u0005\u0003?\u0014!c\u0015;sk\u000e$XO]3WC2LG-\u0019;pe*\u0011!eI\u0001\u0006i>|Gn\u001d\u0006\u0003I\u0015\na\u0001\u0013'8!\u0016#&\"\u0001\u0014\u0002\t=\u0004XM\\\u0002\u0001'\t\u0001\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VMZ\u0001\b[\u0016\u001c8/Y4f!\t\t\u0004H\u0004\u00023mA\u00111gK\u0007\u0002i)\u0011QgJ\u0001\u0007yI|w\u000e\u001e \n\u0005]Z\u0013A\u0002)sK\u0012,g-\u0003\u0002:u\t11\u000b\u001e:j]\u001eT!aN\u0016\u0002\u000fA\u0014xNZ5mKV\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002AC\u0005)Qn\u001c3fY&\u0011!i\u0010\u0002\b!J|g-\u001b7f\u0003-\u0001(o\u001c4jY\u0016|F%Z9\u0015\u0005\u0015C\u0005C\u0001\u0016G\u0013\t95F\u0001\u0003V]&$\bbB%\u0004\u0003\u0003\u0005\r!P\u0001\u0004q\u0012\n\u0014\u0001\u00039s_\u001aLG.\u001a\u0011\u0002!\u0019LW\r\u001c3EK\u001aLg.\u001b;j_:\u001c\u0018\u0001\u00064jK2$G)\u001a4j]&$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002F\u001d\"9\u0011JBA\u0001\u0002\u0004i\u0014!\u00054jK2$G)\u001a4j]&$\u0018n\u001c8tA\u00051A(\u001b8jiz\"BA\u0015+V-B\u00111\u000bA\u0007\u0002C!)q\u0006\u0003a\u0001a!)1\b\u0003a\u0001{!)1\n\u0003a\u0001{\u0005\t2)\u0011*E\u0013:\u000bE*\u0013+Z?J+u)\u0012-\u0016\u0003e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\u00115\fGo\u00195j]\u001eT!AX\u0016\u0002\tU$\u0018\u000e\\\u0005\u0003An\u0013QAU3hKb\f!cQ!S\t&s\u0015\tT%U3~\u0013ViR#YA\u0005y\u0001KU#E\u0013\u000e\u000bE+R0S\u000b\u001e+\u0005,\u0001\tQ%\u0016#\u0015jQ!U\u000b~\u0013ViR#YA\u00051Q.\u00199qKJ,\u0012A\u001a\t\u0003OBl\u0011\u0001\u001b\u0006\u0003S*\f\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003W2\fqA[1dWN|gN\u0003\u0002n]\u0006Ia-Y:uKJDX\u000e\u001c\u0006\u0002_\u0006\u00191m\\7\n\u0005ED'\u0001D(cU\u0016\u001cG/T1qa\u0016\u0014\u0018aB7baB,'\u000fI\u0001\u0007a\u0006\u00148/\u001a:\u0016\u0003U\u0004\"a\u0015<\n\u0005]\f#!\u0004%MoA\u000b'o]3Vi&d7/A\u0004qCJ\u001cXM\u001d\u0011\u0002\u001d\t\u000bEk\u0011%`'\u0016;U*\u0012(U'V\t1\u0010E\u0003}\u0003\u0007\t9!D\u0001~\u0015\tqx0A\u0005j[6,H/\u00192mK*\u0019\u0011\u0011A\u0016\u0002\u0015\r|G\u000e\\3di&|g.C\u0002\u0002\u0006u\u0014A\u0001T5tiB!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011\u0001\u00027b]\u001eT!!!\u0005\u0002\t)\fg/Y\u0005\u0004s\u0005-\u0011a\u0004\"B)\u000eCulU#H\u001b\u0016sEk\u0015\u0011\u0002\u001fY\fG.\u001b3bi\u0016lUm]:bO\u0016$\"!a\u0007\u0011\u0007M\u000bi\"C\u0002\u0002 \u0005\u0012\u0001CV1mS\u0012\fG/[8o\u000bJ\u0014xN]:\u0002/\rDWmY6TK\u001elWM\u001c;DCJ$\u0017N\\1mSRLH#B#\u0002&\u0005U\u0002bBA\u0014)\u0001\u0007\u0011\u0011F\u0001\u000eg\u0016<W.\u001a8u\u0007>tg-[4\u0011\r)\nY\u0003MA\u0018\u0013\r\tic\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007y\n\t$C\u0002\u00024}\u0012QbU3h[\u0016tGoQ8oM&<\u0007bBA\u001c)\u0001\u0007\u00111D\u0001\u0007KJ\u0014xN]:\u00021I,7-\u001e:tSZ,')\u0019;dQZ\u000bG.\u001b3bi&|g\u000eF\u0003F\u0003{\t\t\u0005C\u0004\u0002@U\u0001\r!!\u000b\u0002\u0007M,w\rC\u0004\u00028U\u0001\r!a\u0007\u0002+Y\fG.\u001b3bi\u0016\u0014\u0015\r^2i'\u0016<W.\u001a8ugR\u0019Q)a\u0012\t\u000f\u0005]b\u00031\u0001\u0002\u001c\u0005\u0019\"/Z2veNLg/\u001a,bY&$\u0017\r^5p]R)Q)!\u0014\u0002P!9\u0011qH\fA\u0002\u0005%\u0002bBA\u001c/\u0001\u0007\u00111D\u0001\rm\u0006d\u0017\u000eZ1uK\u001aKG.\u001a\u000b\u0004\u000b\u0006U\u0003bBA\u001c1\u0001\u0007\u00111D\u0001\u0011O\u0016$h)[3mI2{7-\u0019;j_:$\u0002\"a\u0017\u0002d\u00055\u0014\u0011\u000f\t\bU\u0005-\u0012QLA/!\rQ\u0013qL\u0005\u0004\u0003CZ#aA%oi\"9\u0011QM\rA\u0002\u0005\u001d\u0014\u0001\u00027j]\u0016\u0004BAKA5a%\u0019\u00111N\u0016\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005=\u0014\u00041\u0001\u0002^\u0005Ya-[3mI:+XNY3s\u0011\u001d\t\u0019(\u0007a\u0001\u0003;\nQbY8mk6t7OQ3g_J,\u0017a\u0004<bY&$\u0017\r^3TK\u001elWM\u001c;\u0015\u001b\u0015\u000bI(! \u0002\n\u0006-\u0015qRAI\u0011\u0019\tYH\u0007a\u0001a\u000591/Z4nK:$\bbBA@5\u0001\u0007\u0011\u0011Q\u0001\u0007M&,G\u000eZ:\u0011\u000b)\nI'a!\u0011\u0007y\n))C\u0002\u0002\b~\u0012q\u0002\u0013'8'\u0016<W.\u001a8u\r&,G\u000e\u001a\u0005\b\u0003KR\u0002\u0019AA4\u0011\u001d\tiI\u0007a\u0001\u0003;\n!\u0002\\5oK:+XNY3s\u0011\u001d\t\u0019H\u0007a\u0001\u0003;Bq!a\u000e\u001b\u0001\u0004\tY\"A\u0007hKR4\u0015.\u001a7e-\u0006dW/\u001a\u000b\ba\u0005]\u0015\u0011TAN\u0011\u0019\tYh\u0007a\u0001a!9\u0011qN\u000eA\u0002\u0005u\u0003bBA37\u0001\u0007\u0011qM\u0001\u0010m\u0006d\u0017\u000eZ1uK\u0012+g-Y;miR1\u0011\u0011UAT\u0003W\u00032AKAR\u0013\r\t)k\u000b\u0002\b\u0005>|G.Z1o\u0011\u0019\tI\u000b\ba\u0001a\u0005Qa-[3mIZ\u000bG.^3\t\r\u00055F\u00041\u00011\u00031!WMZ1vYR4\u0016\r\\;f\u0003M1\u0018\r\\5eCR,7)\u0019:eS:\fG.\u001b;z)!\t\u0019,!.\u00028\u0006m\u0006C\u0002\u0016\u0002,\u0005\u0005\u0006\u0007\u0003\u0004\u0002*v\u0001\r\u0001\r\u0005\b\u0003sk\u0002\u0019AAB\u0003\u00151\u0017.\u001a7e\u0011\u0019\tY(\ba\u0001a!*Q$a0\u0002LB)!&!1\u0002F&\u0019\u00111Y\u0016\u0003\rQD'o\\<t!\r\u0019\u0016qY\u0005\u0004\u0003\u0013\f#!\u0004%MoA\u000b'o]3FeJ|'o\t\u0002\u0002F\u0006ia/\u00197jI\u0006$X-V:bO\u0016$\"\"!)\u0002R\u0006M\u0017q[Am\u0011\u0019\tIK\ba\u0001a!1\u0011Q\u001b\u0010A\u0002A\nQ!^:bO\u0016Da!a\u001f\u001f\u0001\u0004\u0001\u0004bBA3=\u0001\u0007\u0011q\r\u0015\u0006=\u0005}\u00161Z\u0001\u0012m\u0006d\u0017\u000eZ1uK\u001aKW\r\u001c3UsB,G\u0003EAZ\u0003C\f\u0019/!:\u0002h\u0006-\u0018Q^Ax\u0011\u0019\tIk\ba\u0001a!9\u0011\u0011X\u0010A\u0002\u0005\r\u0005BBA>?\u0001\u0007\u0001\u0007C\u0004\u0002j~\u0001\r!!\u0018\u0002\u0017\u0005t7o^3s\u0013:$W\r\u001f\u0005\b\u0003\u001b{\u0002\u0019AA/\u0011\u001d\t\u0019h\ba\u0001\u0003;Bq!a\u000e \u0001\u0004\tY\u0002")
public class StructureValidator {
    private final String message;
    private Profile profile;
    private Profile fieldDefinitions;
    private final Regex CARDINALITY_REGEX;
    private final Regex PREDICATE_REGEX;
    private final ObjectMapper mapper;
    private final HL7ParseUtils parser;
    private final List<String> BATCH_SEGMENTS;

    public Profile profile() {
        return this.profile;
    }

    public void profile_$eq(Profile x$1) {
        this.profile = x$1;
    }

    public Profile fieldDefinitions() {
        return this.fieldDefinitions;
    }

    public void fieldDefinitions_$eq(Profile x$1) {
        this.fieldDefinitions = x$1;
    }

    public Regex CARDINALITY_REGEX() {
        return this.CARDINALITY_REGEX;
    }

    public Regex PREDICATE_REGEX() {
        return this.PREDICATE_REGEX;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public HL7ParseUtils parser() {
        return this.parser;
    }

    private List<String> BATCH_SEGMENTS() {
        return this.BATCH_SEGMENTS;
    }

    /*
     * WARNING - void declaration
     */
    public ValidationErrors validateMessage() {
        void var1_1;
        ValidationErrors errors = new ValidationErrors();
        Map segmentIndex = ((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).withDefaultValue((Object)BoxesRunTime.boxToInteger((int)0));
        if (this.BATCH_SEGMENTS().contains((Object)this.message.substring(0, 3))) {
            this.validateBatchSegments(errors);
        } else {
            this.validateFile(errors);
        }
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])this.message.split(this.parser().NEW_LINE_FEED())))), (Function1 & Serializable)x0$1 -> {
            StructureValidator.$anonfun$validateMessage$1(this, segmentIndex, errors, x0$1);
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    public void checkSegmentCardinality(Tuple2<String, SegmentConfig> segmentConfig, ValidationErrors errors) {
        Option option;
        SortedMap<Object, String[]> segments = this.parser().retrieveMultipleSegments((String)segmentConfig._1());
        String string = ((SegmentConfig)segmentConfig._2()).cardinality();
        if ("[0..1]".equals(string)) {
            BoxedUnit boxedUnit;
            if (!segments.isEmpty() && segments.keySet().size() > 1) {
                ErrorEntry error = new ErrorEntry(BoxesRunTime.unboxToInt((Object)segments.keySet().last()), 1, 3, (String)segmentConfig._1(), ERROR$.MODULE$, "INVALID_MESSAGE");
                error.description_$eq(new StringBuilder(62).append("Multiple segments for ").append(segmentConfig._1()).append(" found. Only 0 or 1 segments is allowed.").toString());
                errors.addEntry(error);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if ("[1..1]".equals(string)) {
            BoxedUnit boxedUnit;
            if (segments.isEmpty()) {
                ErrorEntry error = new ErrorEntry(0, 1, 0, (String)segmentConfig._1(), ERROR$.MODULE$, "INVALID_MESSAGE");
                error.description_$eq(new StringBuilder(26).append("Required segment ").append(segmentConfig._1()).append(" missing.").toString());
                errors.addEntry(error);
                boxedUnit = BoxedUnit.UNIT;
            } else if (segments.keySet().size() > 1) {
                ErrorEntry error = new ErrorEntry(BoxesRunTime.unboxToInt((Object)segments.keySet().last()), 1, 3, (String)segmentConfig._1(), ERROR$.MODULE$, "INVALID_MESSAGE");
                error.description_$eq(new StringBuilder(57).append("Multiple segments for ").append(segmentConfig._1()).append(" found. Only  1 segment is allowed.").toString());
                errors.addEntry(error);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if ("[1..*]".equals(string)) {
            BoxedUnit boxedUnit;
            if (segments.isEmpty()) {
                ErrorEntry error = new ErrorEntry(0, 1, 0, (String)segmentConfig._1(), ERROR$.MODULE$, "INVALID_MESSAGE");
                error.description_$eq(new StringBuilder(26).append("Required segment ").append(segmentConfig._1()).append(" missing.").toString());
                errors.addEntry(error);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (string != null && !(option = this.CARDINALITY_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            BoxedUnit boxedUnit;
            String min = (String)((LinearSeqOps)option.get()).apply(0);
            String max = (String)((LinearSeqOps)option.get()).apply(1);
            if (segments.keySet().size() < StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(min)) || segments.keySet().size() > StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(max))) {
                ErrorEntry error = new ErrorEntry(1, 1, 2, (String)segmentConfig._1(), ERROR$.MODULE$, "INVALID_MESSAGE");
                error.description_$eq(new StringBuilder(62).append("Multiple segments for ").append(segmentConfig._1()).append(" found. Only  ").append(min).append(" to ").append(max).append(" segments are allowed.").toString());
                errors.addEntry(error);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else if ("[0..*]".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new HL7ParseError(new StringBuilder(43).append("Invalid Cardinality ").append(((SegmentConfig)segmentConfig._2()).cardinality()).append(" on Profile Definition!").toString(), (String)segmentConfig._1(), HL7ParseError$.MODULE$.apply$default$3());
        }
    }

    private void recursiveBatchValidation(Tuple2<String, SegmentConfig> seg, ValidationErrors errors) {
        this.checkSegmentCardinality(seg, errors);
        ((IterableOnceOps)((SegmentConfig)seg._2()).children().filter((Function1 & Serializable)it -> BoxesRunTime.boxToBoolean((boolean)StructureValidator.$anonfun$recursiveBatchValidation$1(this, it)))).foreach((Function1 & Serializable)it -> {
            this.recursiveBatchValidation((Tuple2<String, SegmentConfig>)it, errors);
            return BoxedUnit.UNIT;
        });
    }

    private void validateBatchSegments(ValidationErrors errors) {
        ((IterableOnceOps)this.profile().segmentDefinition().filter((Function1 & Serializable)it -> BoxesRunTime.boxToBoolean((boolean)StructureValidator.$anonfun$validateBatchSegments$1(this, it)))).foreach((Function1 & Serializable)it -> {
            this.recursiveBatchValidation((Tuple2<String, SegmentConfig>)it, errors);
            return BoxedUnit.UNIT;
        });
    }

    private void recursiveValidation(Tuple2<String, SegmentConfig> seg, ValidationErrors errors) {
        this.checkSegmentCardinality(seg, errors);
        ((SegmentConfig)seg._2()).children().foreach((Function1 & Serializable)it -> {
            this.recursiveValidation((Tuple2<String, SegmentConfig>)it, errors);
            return BoxedUnit.UNIT;
        });
    }

    private void validateFile(ValidationErrors errors) {
        this.profile().segmentDefinition().foreach((Function1 & Serializable)it -> {
            this.recursiveValidation((Tuple2<String, SegmentConfig>)it, errors);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<Object, Object> getFieldLocation(String[] line, int fieldNumber, int columnsBefore) {
        IntRef beginCol = IntRef.create((int)columnsBefore);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), fieldNumber).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            block0: {
                if (idx >= line.length) break block0;
                beginCol$1.elem = beginCol$1.elem + line[idx].length() + 1;
            }
        });
        return fieldNumber < line.length ? new Tuple2.mcII.sp(beginCol.elem, beginCol.elem + line[fieldNumber].length() + 1) : new Tuple2.mcII.sp(beginCol.elem, beginCol.elem + 1);
    }

    public void validateSegment(String segment, HL7SegmentField[] fields, String[] line, int lineNumber, int columnsBefore, ValidationErrors errors) {
        block1: {
            ObjectRef pathSeparator = ObjectRef.create((Object)"-");
            if (segment.contains("-")) {
                pathSeparator.elem = ".";
            }
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> {
                StructureValidator.$anonfun$validateSegment$1(this, segment, line, pathSeparator, columnsBefore, lineNumber, errors, field);
                return BoxedUnit.UNIT;
            });
            if (fields.length >= line.length) break block1;
            Tuple2<Object, Object> loc = this.getFieldLocation(line, fields.length, columnsBefore);
            ErrorEntry entry = new ErrorEntry(lineNumber, loc._1$mcI$sp(), loc._2$mcI$sp(), String.valueOf(segment), ERROR$.MODULE$, "INVALID_SEGMENT");
            entry.description_$eq(new StringBuilder(38).append("Too many fields provided for segment ").append(segment).append(".").toString());
            errors.addEntry(entry);
        }
    }

    private String getFieldValue(String segment, int fieldNumber, String[] line) {
        String headerSeg = "^(MSH|[BF]HS)\\[[0-9]+\\]$";
        String subFields = "^([A-Z]{3})\\[[0-9]+\\]\\-.*";
        if (segment.matches(subFields)) {
            int n = fieldNumber;
            switch (n) {
                default: 
            }
            if (n > line.length) {
                return "";
            }
            return line[fieldNumber - 1];
        }
        if (segment.matches(headerSeg)) {
            int n = fieldNumber;
            if (n > line.length) {
                return "";
            }
            if (1 == n) {
                return "|";
            }
            return line[fieldNumber - 1];
        }
        int n = fieldNumber;
        switch (n) {
            default: 
        }
        if (n >= line.length) {
            return "";
        }
        return line[fieldNumber];
    }

    private boolean validateDefault(String fieldValue, String defaultValue) {
        return ((String)Option$.MODULE$.apply((Object)defaultValue).getOrElse((Function0 & Serializable)() -> "")).isEmpty() || defaultValue.equals(fieldValue);
    }

    private Tuple2<Object, String> validateCardinality(String fieldValue, HL7SegmentField field, String segment) throws HL7ParseError {
        String string = field.cardinality();
        if ("[0..1]".equals(string)) {
            String string2 = fieldValue;
            String string3 = "^~\\&";
            if ((string2 == null ? string3 != null : !string2.equals(string3)) && fieldValue.contains("~")) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(61).append("Multiple values for ").append(segment).append("-").append(field.fieldNumber()).append(" (").append(field.name()).append(") found. Only 0 or 1 value is allowed.").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("[1..1]".equals(string)) {
            if (((String)Option$.MODULE$.apply((Object)fieldValue).getOrElse((Function0 & Serializable)() -> "")).isEmpty()) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(33).append("Required field ").append(segment).append("-[").append(field.fieldNumber()).append("] (").append(field.name()).append(") is missing.").toString());
            }
            String string4 = fieldValue;
            String string5 = "^~\\&";
            if ((string4 == null ? string5 != null : !string4.equals(string5)) && fieldValue.contains("~")) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(56).append("Multiple values for ").append(segment).append("-").append(field.fieldNumber()).append(" (").append(field.name()).append(") found. Only 1 value is allowed.").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("[1..*]".equals(string)) {
            if (((String)Option$.MODULE$.apply((Object)fieldValue).getOrElse((Function0 & Serializable)() -> "")).isEmpty()) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(33).append("Required field ").append(segment).append("-[").append(field.fieldNumber()).append("] (").append(field.name()).append(") is missing.").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Option option;
            if ("[0..*]".equals(string)) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"all good");
            }
            if (string != null && !(option = this.CARDINALITY_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
                String min = (String)((LinearSeqOps)option.get()).apply(0);
                String max = (String)((LinearSeqOps)option.get()).apply(1);
                Predef$.MODULE$.println((Object)new StringBuilder(23).append("validating card... ").append(min).append(" to ").append(max).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new HL7ParseError(new StringBuilder(43).append("Invalid Cardinality ").append(field.cardinality()).append(" on Profile Definition!").toString(), segment, HL7ParseError$.MODULE$.apply$default$3());
            }
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"all good");
    }

    private boolean validateUsage(String fieldValue, String usage, String segment, String[] line) throws HL7ParseError {
        boolean bl;
        block4: {
            while (true) {
                boolean checkFirstCond;
                Option option;
                String string;
                if ("R".equals(string = usage)) {
                    bl = !((String)Option$.MODULE$.apply((Object)fieldValue).getOrElse((Function0 & Serializable)() -> "")).isEmpty();
                    break block4;
                }
                boolean bl2 = "RE".equals(string) ? true : ("O".equals(string) ? true : "X".equals(string));
                if (bl2) {
                    bl = true;
                    break block4;
                }
                if (string == null || (option = this.PREDICATE_REGEX().unapplySeq((CharSequence)string)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(4) != 0) break;
                String iftrue = (String)((LinearSeqOps)option.get()).apply(0);
                String iffalse = (String)((LinearSeqOps)option.get()).apply(1);
                String absent = (String)((LinearSeqOps)option.get()).apply(2);
                String field = (String)((LinearSeqOps)option.get()).apply(3);
                String relatedField = this.getFieldValue(segment, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(field)), line);
                boolean bl3 = checkFirstCond = absent == null && relatedField != null && relatedField.trim().length() > 0 || "!".equals(absent) && (relatedField == null || relatedField.trim().length() == 0);
                if (checkFirstCond) {
                    usage = iftrue;
                    continue;
                }
                usage = iffalse;
            }
            throw new HL7ParseError(new StringBuilder(37).append("Invalid Usage ").append(usage).append(" on Profile Definition!").toString(), segment, HL7ParseError$.MODULE$.apply$default$3());
        }
        return bl;
    }

    private Tuple2<Object, String> validateFieldType(String fieldValue, HL7SegmentField field, String segment, int answerIndex, int lineNumber, int columnsBefore, ValidationErrors errors) {
        Tuple2 tuple2;
        String string = field.dataType();
        boolean bl = "ST".equals(string) ? true : ("IS".equals(string) ? true : ("ID".equals(string) ? true : ("TX".equals(string) ? true : "FT".equals(string))));
        if (bl) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"All good!");
        }
        if ("NM".equals(string)) {
            try {
                StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(fieldValue));
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"All good!");
            }
            catch (NumberFormatException e) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(67).append("Invalid value for numeric field ").append(segment).append("-").append(field.fieldNumber()).append("[").append(answerIndex).append("] (").append(field.name()).append("). Number expected, received: ").append(fieldValue).toString());
            }
        } else {
            boolean bl2 = "TS".equals(string) ? true : "DT".equals(string);
            if (bl2) {
                Tuple2 tuple22;
                try {
                    SimpleDateFormat format = new SimpleDateFormat(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(fieldValue)) == 8 ? "yyyyMMdd" : "yyyyMMddHHmmss");
                    if (format.parse(fieldValue) == null) {
                        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(85).append("Invalid value for date field ").append(segment).append("-").append(field.fieldNumber()).append("[").append(answerIndex).append("] (").append(field.name()).append("). Date expected as 'yyyyMMddHHmmss', received: '").append(fieldValue).append("'.").toString());
                    }
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"all good");
                }
                catch (ParseException e) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(85).append("Invalid value for date field ").append(segment).append("-").append(field.fieldNumber()).append("[").append(answerIndex).append("] (").append(field.name()).append("). Date expected as 'yyyyMMddHHmmss', received: '").append(fieldValue).append("'.").toString());
                }
                tuple2 = tuple22;
            } else {
                Tuple2 tuple23;
                try {
                    String newseg = segment.indexOf(45) < 0 ? new StringBuilder(3).append(segment).append("-").append(field.fieldNumber()).append("[").append(answerIndex).append("]").toString() : new StringBuilder(1).append(segment).append(".").append(field.fieldNumber()).toString();
                    String[] split = newseg.indexOf("].") > 0 ? fieldValue.split(this.parser().HL7_SUBCOMPONENT_SEPARATOR()) : fieldValue.split(this.parser().HL7_COMPONENT_SEPARATOR());
                    this.validateSegment(newseg, this.fieldDefinitions().getSegmentField(string), split, lineNumber, columnsBefore, errors);
                    tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"all good");
                }
                catch (NoSuchElementException e) {
                    tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(31).append("Field type '").append(string).append("' is not supported.").toString());
                }
                tuple2 = tuple23;
            }
        }
        return tuple2;
    }

    public static final /* synthetic */ void $anonfun$validateMessage$1(StructureValidator $this, Map segmentIndex$1, ValidationErrors errors$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String line = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String[] segmentLine = line.split($this.parser().HL7_FIELD_SEPARATOR());
            try {
                String string = segmentLine[0];
                segmentIndex$1.update((Object)string, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)segmentIndex$1.apply((Object)string)) + 1)));
                $this.validateSegment(new StringBuilder(2).append(segmentLine[0]).append("[").append(segmentIndex$1.apply((Object)segmentLine[0])).append("]").toString(), $this.profile().getSegmentField(segmentLine[0]), segmentLine, index + 1, 1, errors$1);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NoSuchElementException e) {
                ErrorEntry entry = new ErrorEntry(index + 1, 1, segmentLine[0].length(), segmentLine[0], ERROR$.MODULE$, "INVALID_MESSAGE");
                entry.description_$eq(new StringBuilder(22).append("Segment ").append(segmentLine[0]).append(" not supported").toString());
                errors$1.addEntry(entry);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$recursiveBatchValidation$1(StructureValidator $this, Tuple2 it) {
        return $this.BATCH_SEGMENTS().contains(it._1());
    }

    public static final /* synthetic */ boolean $anonfun$validateBatchSegments$1(StructureValidator $this, Tuple2 it) {
        return $this.BATCH_SEGMENTS().contains(it._1());
    }

    public static final /* synthetic */ void $anonfun$validateSegment$3(StructureValidator $this, String segment$1, ObjectRef pathSeparator$1, HL7SegmentField field$1, IntRef answerIndex$1, String[] line$2, int columnsBefore$1, int lineNumber$1, ValidationErrors errors$6, String aField) {
        Tuple2<Object, Object> loc;
        Tuple2<Object, String> resultsDataType;
        String innerpath = new StringBuilder(0).append(segment$1).append((String)pathSeparator$1.elem).append(field$1.fieldNumber()).toString();
        if (((String)pathSeparator$1.elem).equals("-")) {
            innerpath = new StringBuilder(0).append(innerpath).append(new StringBuilder(2).append("[").append(answerIndex$1.elem).append("]").toString()).toString();
        }
        if (!(resultsDataType = $this.validateFieldType(aField, field$1, segment$1, answerIndex$1.elem, lineNumber$1, (loc = segment$1.startsWith("MSH") ? $this.getFieldLocation(line$2, field$1.fieldNumber() - 1, columnsBefore$1) : $this.getFieldLocation(line$2, field$1.fieldNumber(), columnsBefore$1))._1$mcI$sp(), errors$6))._1$mcZ$sp()) {
            Tuple2<Object, Object> loc2 = $this.getFieldLocation(line$2, field$1.fieldNumber(), columnsBefore$1);
            ErrorEntry entry = new ErrorEntry(lineNumber$1, loc2._1$mcI$sp(), loc2._2$mcI$sp(), innerpath, ERROR$.MODULE$, "INVALID_FIELD_TYPE");
            entry.description_$eq((String)resultsDataType._2());
            errors$6.addEntry(entry);
        }
        if (aField.length() > field$1.maxLength()) {
            Tuple2<Object, Object> loc3 = $this.getFieldLocation(line$2, field$1.fieldNumber(), columnsBefore$1);
            ErrorEntry entry = new ErrorEntry(lineNumber$1, loc3._1$mcI$sp(), loc3._2$mcI$sp(), innerpath, ERROR$.MODULE$, "INVALID_FIELD_LENGTH");
            entry.description_$eq(new StringBuilder(54).append("Field value too big for ").append(innerpath).append(" (").append(field$1.name()).append("). Maximum value allowed is ").append(field$1.maxLength()).toString());
            errors$6.addEntry(entry);
        }
        if (!$this.validateDefault(aField, field$1.default())) {
            String defaultVal = field$1.default();
            Tuple2<Object, Object> loc4 = $this.getFieldLocation(line$2, field$1.fieldNumber(), columnsBefore$1);
            ErrorEntry entry = new ErrorEntry(lineNumber$1, loc4._1$mcI$sp(), loc4._2$mcI$sp(), innerpath, ERROR$.MODULE$, "INVALID_DEFAULT_VALUE");
            entry.description_$eq(new StringBuilder(28).append("Value for field ").append(innerpath).append(" (").append(field$1.name()).append(") must be ").append(defaultVal).toString());
            errors$6.addEntry(entry);
        }
        ++answerIndex$1.elem;
    }

    public static final /* synthetic */ void $anonfun$validateSegment$1(StructureValidator $this, String segment$1, String[] line$2, ObjectRef pathSeparator$1, int columnsBefore$1, int lineNumber$1, ValidationErrors errors$6, HL7SegmentField field) {
        block6: {
            String fieldValue = $this.getFieldValue(segment$1, field.fieldNumber(), line$2);
            String path = new StringBuilder(0).append(segment$1).append((String)pathSeparator$1.elem).append(field.fieldNumber()).toString();
            if (((String)pathSeparator$1.elem).equals("-")) {
                path = new StringBuilder(3).append(path).append("[1]").toString();
            }
            try {
                if (!$this.validateUsage(fieldValue, field.usage(), segment$1, line$2)) {
                    Tuple2<Object, Object> loc = $this.getFieldLocation(line$2, field.fieldNumber(), columnsBefore$1);
                    ErrorEntry entry = new ErrorEntry(lineNumber$1, loc._1$mcI$sp(), loc._2$mcI$sp(), path, ERROR$.MODULE$, "INVALID_USAGE");
                    entry.description_$eq(new StringBuilder(30).append("Required field ").append(path).append(" (").append(field.name()).append(") is missing.").toString());
                    errors$6.addEntry(entry);
                }
            }
            catch (HL7ParseError e) {
                Tuple2<Object, Object> loc = $this.getFieldLocation(line$2, field.fieldNumber(), columnsBefore$1);
                ErrorEntry entry = new ErrorEntry(lineNumber$1, loc._1$mcI$sp(), loc._2$mcI$sp(), path, ERROR$.MODULE$, "INVALID_SEGMENT");
                entry.description_$eq(e.getMessage());
                errors$6.addEntry(entry);
            }
            if (((String)Option$.MODULE$.apply((Object)fieldValue).getOrElse((Function0 & Serializable)() -> "")).isEmpty()) break block6;
            Tuple2<Object, String> resultsCardinality = $this.validateCardinality(fieldValue, field, segment$1);
            if (!resultsCardinality._1$mcZ$sp()) {
                int fieldError = 1;
                if (((String)resultsCardinality._2()).contains("Multiple")) {
                    fieldError = 2;
                }
                Tuple2<Object, Object> loc = $this.getFieldLocation(line$2, field.fieldNumber(), columnsBefore$1);
                ErrorEntry entry = new ErrorEntry(lineNumber$1, loc._1$mcI$sp(), loc._2$mcI$sp(), new StringBuilder(2).append(segment$1).append((String)pathSeparator$1.elem).append(field.fieldNumber()).append("[").append(fieldError).append("]").toString(), ERROR$.MODULE$, "INVALID_CARDINALITY");
                entry.description_$eq((String)resultsCardinality._2());
                errors$6.addEntry(entry);
            }
            String[] repeats = field.fieldNumber() == 2 ? (String[])((Object[])new String[]{fieldValue}) : fieldValue.split($this.parser().HL7_FIELD_REPETITION());
            IntRef answerIndex = IntRef.create((int)1);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])repeats), (Function1 & Serializable)aField -> {
                StructureValidator.$anonfun$validateSegment$3($this, segment$1, pathSeparator$1, field, answerIndex, line$2, columnsBefore$1, lineNumber$1, errors$6, aField);
                return BoxedUnit.UNIT;
            });
        }
    }

    public StructureValidator(String message, Profile profile, Profile fieldDefinitions) {
        this.message = message;
        this.profile = profile;
        this.fieldDefinitions = fieldDefinitions;
        this.CARDINALITY_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\[([0-9]+)\\.\\.([0-9]+)\\]"));
        this.PREDICATE_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("C\\((RE?|O|X)\\/(RE?|O|X)\\)->(!)?([0-9]+)"));
        this.mapper = new ObjectMapper();
        this.mapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        if (this.profile() == null) {
            Predef$.MODULE$.println((Object)"Using Default profile");
            String content = Source$.MODULE$.fromResource("PhinGuideProfile.json", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n");
            this.profile_$eq((Profile)this.mapper().readValue(content, Profile.class));
        }
        if (this.fieldDefinitions() == null) {
            String fieldDefContent = Source$.MODULE$.fromResource("DefaultFieldsProfile.json", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n");
            this.fieldDefinitions_$eq((Profile)this.mapper().readValue(fieldDefContent, Profile.class));
        }
        this.parser = new HL7ParseUtils(message, this.profile(), false);
        this.BATCH_SEGMENTS = (List)new .colon.colon((Object)"FHS", (List)new .colon.colon((Object)"BHS", (List)new .colon.colon((Object)"BTS", (List)new .colon.colon((Object)"FTS", (List)Nil$.MODULE$))));
    }
}

