/*
 * Decompiled with CFR 0.152.
 */
package open.HL7PET.tools;

import java.io.Serializable;
import open.HL7PET.tools.ERROR$;
import open.HL7PET.tools.ErrorEntry;
import open.HL7PET.tools.HL7ParseError;
import open.HL7PET.tools.HL7ParseUtils;
import open.HL7PET.tools.StructureValidator;
import open.HL7PET.tools.ValidationErrors;
import open.HL7PET.tools.model.HL7SegmentField;
import open.HL7PET.tools.model.Profile;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001%\u0011aBQ1uG\"4\u0016\r\\5eCR|'O\u0003\u0002\u0004\t\u0005)Ao\\8mg*\u0011QAB\u0001\u0007\u00112;\u0004+\u0012+\u000b\u0003\u001d\tAa\u001c9f]\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\"A\u0011\u0003\u0001B\u0001B\u0003%!#A\u0004nKN\u001c\u0018mZ3\u0011\u0005MQbB\u0001\u000b\u0019!\t)B\"D\u0001\u0017\u0015\t9\u0002\"\u0001\u0004=e>|GOP\u0005\u000331\ta\u0001\u0015:fI\u00164\u0017BA\u000e\u001d\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0004\u0004\u0005\t=\u0001\u0011\t\u0019!C\u0001?\u00059\u0001O]8gS2,W#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\u0012\u0011!B7pI\u0016d\u0017BA\u0013#\u0005\u001d\u0001&o\u001c4jY\u0016D\u0001b\n\u0001\u0003\u0002\u0004%\t\u0001K\u0001\faJ|g-\u001b7f?\u0012*\u0017\u000f\u0006\u0002*YA\u00111BK\u0005\u0003W1\u0011A!\u00168ji\"9QFJA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!Aq\u0006\u0001B\u0001B\u0003&\u0001%\u0001\u0005qe>4\u0017\u000e\\3!\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0019a\u0014N\\5u}Q\u00191'\u000e\u001c\u0011\u0005Q\u0002Q\"\u0001\u0002\t\u000bE\u0001\u0004\u0019\u0001\n\t\u000by\u0001\u0004\u0019\u0001\u0011\t\u000fa\u0002!\u0019!C\u0001s\u0005\u0019b)\u0013'F?\"+\u0015\tR#S?N+u)T#O)V\t!\b\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005!A.\u00198h\u0015\u0005y\u0014\u0001\u00026bm\u0006L!a\u0007\u001f\t\r\t\u0003\u0001\u0015!\u0003;\u0003Q1\u0015\nT#`\u0011\u0016\u000bE)\u0012*`'\u0016;U*\u0012(UA!9A\t\u0001b\u0001\n\u0003I\u0014\u0001\u0006$J\u0019\u0016{FKU!J\u0019\u0016\u0013vlU#H\u001b\u0016sE\u000b\u0003\u0004G\u0001\u0001\u0006IAO\u0001\u0016\r&cUi\u0018+S\u0003&cUIU0T\u000b\u001ekUI\u0014+!\u0011\u001dA\u0005A1A\u0005\u0002e\nACQ!U\u0007\"{\u0006*R!E\u000bJ{6+R$N\u000b:#\u0006B\u0002&\u0001A\u0003%!(A\u000bC\u0003R\u001b\u0005j\u0018%F\u0003\u0012+%kX*F\u000f6+e\n\u0016\u0011\t\u000f1\u0003!\u0019!C\u0001s\u0005)\")\u0011+D\u0011~#&+Q%M\u000bJ{6+R$N\u000b:#\u0006B\u0002(\u0001A\u0003%!(\u0001\fC\u0003R\u001b\u0005j\u0018+S\u0003&cUIU0T\u000b\u001ekUI\u0014+!\u0011\u001d\u0001\u0006A1A\u0005\u0002E\u000ba\u0001]1sg\u0016\u0014X#\u0001*\u0011\u0005Q\u001a\u0016B\u0001+\u0003\u00055AEj\u000e)beN,W\u000b^5mg\"1a\u000b\u0001Q\u0001\nI\u000bq\u0001]1sg\u0016\u0014\b\u0005C\u0004Y\u0001\t\u0007I\u0011A-\u0002%M$(/^2ukJ,g+\u00197jI\u0006$xN]\u000b\u00025B\u0011AgW\u0005\u00039\n\u0011!c\u0015;sk\u000e$XO]3WC2LG-\u0019;pe\"1a\f\u0001Q\u0001\ni\u000b1c\u001d;sk\u000e$XO]3WC2LG-\u0019;pe\u0002Bq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011-\u0001\u0004nCB\u0004XM]\u000b\u0002EB\u00111\r\\\u0007\u0002I*\u0011QMZ\u0001\u0004[\u0006\u0004(BA4i\u0003\u001dQ\u0017mY6t_:T!!\u001b6\u0002\u0011\r|G-\u001a5bkNT\u0011a[\u0001\u0004_J<\u0017BA7e\u00051y%M[3di6\u000b\u0007\u000f]3s\u0011\u0019y\u0007\u0001)A\u0005E\u00069Q.\u00199qKJ\u0004\u0003bB9\u0001\u0005\u0004%\tA]\u0001\u0010M&,G\u000e\u001a#fM\u000e{g\u000e^3oiV\t!\u0003\u0003\u0004u\u0001\u0001\u0006IAE\u0001\u0011M&,G\u000e\u001a#fM\u000e{g\u000e^3oi\u0002BqA\u001e\u0001C\u0002\u0013\u0005q$\u0001\tgS\u0016dG\rR3gS:LG/[8og\"1\u0001\u0010\u0001Q\u0001\n\u0001\n\u0011CZ5fY\u0012$UMZ5oSRLwN\\:!\u0011\u0015Q\b\u0001\"\u0001|\u0003Q1\u0018\r\\5eCR,')\u0019;dQ&tw-\u00138g_R\tA\u0010\u0005\u00025{&\u0011aP\u0001\u0002\u0011-\u0006d\u0017\u000eZ1uS>tWI\u001d:peNDS!_A\u0001\u0003\u001b\u0001RaCA\u0002\u0003\u000fI1!!\u0002\r\u0005\u0019!\bN]8xgB\u0019A'!\u0003\n\u0007\u0005-!AA\u0007I\u0019^\u0002\u0016M]:f\u000bJ\u0014xN]\u0012\u0003\u0003\u000fAq!!\u0005\u0001\t\u0013\t\u0019\"A\fq_B,H.\u0019;f\tV\u0004H.[2bi\u0016,%O]8sgR)\u0011&!\u0006\u0002\u001a!9\u0011qCA\b\u0001\u0004a\u0018AB3se>\u00148\u000fC\u0004\u0002\u001c\u0005=\u0001\u0019\u0001\n\u0002\u000fM,w-\\3oi\"9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0012a\u0003<bY&$\u0017\r^3G\u0011N#2!KA\u0012\u0011\u001d\t9\"!\bA\u0002qDq!a\n\u0001\t\u0013\tI#A\u0006wC2LG-\u0019;f\rR\u001bFcB\u0015\u0002,\u00055\u0012q\u0007\u0005\b\u0003/\t)\u00031\u0001}\u0011!\ty#!\nA\u0002\u0005E\u0012A\u00025bg\u001a#6\u000bE\u0002\f\u0003gI1!!\u000e\r\u0005\rIe\u000e\u001e\u0005\t\u0003s\t)\u00031\u0001\u00022\u0005QaN\u0019:PM2Kg.Z:\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@\u0005Ya/\u00197jI\u0006$XM\u0011%T)\rI\u0013\u0011\t\u0005\b\u0003/\tY\u00041\u0001}\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000f\n1B^1mS\u0012\fG/\u001a\"U'R9\u0011&!\u0013\u0002L\u00055\u0003bBA\f\u0003\u0007\u0002\r\u0001 \u0005\t\u0003s\t\u0019\u00051\u0001\u00022!A\u0011qJA\"\u0001\u0004\t\t$A\u0007oEJ|e-T3tg\u0006<Wm\u001d\u0005\b\u0003'\u0002A\u0011AA+\u0003=!WMY1uG\"lUm]:bO\u0016\u001cHCAA,!\u0015\tI&a\u0019\u0013\u001d\u0011\tY&a\u0018\u000f\u0007U\ti&C\u0001\u000e\u0013\r\t\t\u0007D\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)'a\u001a\u0003\t1K7\u000f\u001e\u0006\u0004\u0003Cb\u0001")
public class BatchValidator {
    private final String message;
    private Profile profile;
    private final String FILE_HEADER_SEGMENT;
    private final String FILE_TRAILER_SEGMENT;
    private final String BATCH_HEADER_SEGMENT;
    private final String BATCH_TRAILER_SEGMENT;
    private final HL7ParseUtils parser;
    private final StructureValidator structureValidator;
    private final ObjectMapper mapper;
    private final String fieldDefContent;
    private final Profile fieldDefinitions;

    public Profile profile() {
        return this.profile;
    }

    public void profile_$eq(Profile x$1) {
        this.profile = x$1;
    }

    public String FILE_HEADER_SEGMENT() {
        return this.FILE_HEADER_SEGMENT;
    }

    public String FILE_TRAILER_SEGMENT() {
        return this.FILE_TRAILER_SEGMENT;
    }

    public String BATCH_HEADER_SEGMENT() {
        return this.BATCH_HEADER_SEGMENT;
    }

    public String BATCH_TRAILER_SEGMENT() {
        return this.BATCH_TRAILER_SEGMENT;
    }

    public HL7ParseUtils parser() {
        return this.parser;
    }

    public StructureValidator structureValidator() {
        return this.structureValidator;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public String fieldDefContent() {
        return this.fieldDefContent;
    }

    public Profile fieldDefinitions() {
        return this.fieldDefinitions;
    }

    public ValidationErrors validateBatchingInfo() throws HL7ParseError {
        ObjectRef errors;
        block11: {
            errors = ObjectRef.create((Object)new ValidationErrors());
            Map hasBatchSegments = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            hasBatchSegments.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FILE_HEADER_SEGMENT()), (Object)BoxesRunTime.boxToInteger((int)this.parser().peek(this.FILE_HEADER_SEGMENT()))));
            hasBatchSegments.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FILE_TRAILER_SEGMENT()), (Object)BoxesRunTime.boxToInteger((int)this.parser().peek(this.FILE_TRAILER_SEGMENT()))));
            hasBatchSegments.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.BATCH_HEADER_SEGMENT()), (Object)BoxesRunTime.boxToInteger((int)this.parser().peek(this.BATCH_HEADER_SEGMENT()))));
            hasBatchSegments.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.BATCH_TRAILER_SEGMENT()), (Object)BoxesRunTime.boxToInteger((int)this.parser().peek(this.BATCH_TRAILER_SEGMENT()))));
            int nbrOfMessages = this.parser().peek(this.parser().MSH_SEGMENT());
            int nbrOfLines = this.message.split("\n").length;
            if (BoxesRunTime.unboxToInt((Object)hasBatchSegments.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToInteger((int)BatchValidator.$anonfun$validateBatchingInfo$1(BoxesRunTime.unboxToInt((Object)x$1), x$2)))) > 0) {
                hasBatchSegments.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BatchValidator.$anonfun$validateBatchingInfo$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    BatchValidator.$anonfun$validateBatchingInfo$3(errors, x$3);
                    return BoxedUnit.UNIT;
                });
            }
            int n = BoxesRunTime.unboxToInt((Object)hasBatchSegments.apply((Object)this.FILE_HEADER_SEGMENT()));
            switch (n) {
                case 0: {
                    if (BoxesRunTime.unboxToInt((Object)hasBatchSegments.apply((Object)this.FILE_TRAILER_SEGMENT())) <= 0) break;
                    Tuple2<Object, String[]> tuple2 = this.parser().retrieveFirstSegmentOf(this.FILE_TRAILER_SEGMENT());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int line = tuple2._1$mcI$sp();
                    String[] seg = (String[])tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)line), (Object)seg);
                    Tuple2 tuple23 = tuple22;
                    int line2 = tuple23._1$mcI$sp();
                    String[] seg2 = (String[])tuple23._2();
                    Tuple2<Object, Object> loc = this.structureValidator().getFieldLocation(seg2, seg2.length, 1);
                    ErrorEntry entry = new ErrorEntry(line2, 1, loc._2$mcI$sp(), this.FILE_TRAILER_SEGMENT() + "[1]", ERROR$.MODULE$, "INVALID_BATCH_SEGMENTS");
                    entry.description_$eq("FTS segment present without a pairing FHS segment.");
                    break;
                }
                case 1: {
                    this.validateFHS((ValidationErrors)errors.elem);
                    this.validateFTS((ValidationErrors)errors.elem, BoxesRunTime.unboxToInt((Object)hasBatchSegments.apply((Object)this.FILE_TRAILER_SEGMENT())), nbrOfLines);
                    break;
                }
                default: {
                    this.populateDuplicateErrors((ValidationErrors)errors.elem, this.FILE_HEADER_SEGMENT());
                    this.validateFTS((ValidationErrors)errors.elem, BoxesRunTime.unboxToInt((Object)hasBatchSegments.apply((Object)this.FILE_TRAILER_SEGMENT())), nbrOfLines);
                    break;
                }
            }
            int n2 = BoxesRunTime.unboxToInt((Object)hasBatchSegments.apply((Object)this.BATCH_HEADER_SEGMENT()));
            switch (n2) {
                case 0: {
                    if (BoxesRunTime.unboxToInt((Object)hasBatchSegments.apply((Object)this.BATCH_TRAILER_SEGMENT())) <= 0) break;
                    Tuple2<Object, String[]> tuple2 = this.parser().retrieveFirstSegmentOf(this.BATCH_TRAILER_SEGMENT());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int line = tuple2._1$mcI$sp();
                    String[] seg = (String[])tuple2._2();
                    Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)line), (Object)seg);
                    Tuple2 tuple25 = tuple24;
                    int line3 = tuple25._1$mcI$sp();
                    String[] seg3 = (String[])tuple25._2();
                    Tuple2<Object, Object> loc = this.structureValidator().getFieldLocation(seg3, seg3.length, 1);
                    ErrorEntry entry = new ErrorEntry(line3, 1, loc._2$mcI$sp(), this.BATCH_TRAILER_SEGMENT() + "[1]", ERROR$.MODULE$, "INVALID_BATCH_SEGMENTS");
                    entry.description_$eq("BTS segment present without a pairing BHS segment.");
                    break;
                }
                case 1: {
                    this.validateBHS((ValidationErrors)errors.elem);
                    this.validateBTS((ValidationErrors)errors.elem, nbrOfLines, nbrOfMessages);
                    break;
                }
                default: {
                    this.populateDuplicateErrors((ValidationErrors)errors.elem, this.BATCH_HEADER_SEGMENT());
                    this.validateBTS((ValidationErrors)errors.elem, nbrOfLines, nbrOfMessages);
                    break;
                }
            }
            if (nbrOfMessages != 0) break block11;
            ErrorEntry entry = new ErrorEntry(1, 1, 1, "MSH[1]", ERROR$.MODULE$, "INVALID_MESSAGE");
            entry.description_$eq("At least one Message is required to be present on the payload.");
            ((ValidationErrors)errors.elem).addEntry(entry);
        }
        return (ValidationErrors)errors.elem;
    }

    private void populateDuplicateErrors(ValidationErrors errors, String segment) {
        SortedMap<Object, String[]> ftsSegs = this.parser().retrieveMultipleSegments(segment);
        IntRef index = IntRef.create((int)1);
        ftsSegs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)BatchValidator.$anonfun$populateDuplicateErrors$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            BatchValidator.$anonfun$populateDuplicateErrors$2(errors, segment, index, x$6);
            return BoxedUnit.UNIT;
        });
    }

    private void validateFHS(ValidationErrors errors) {
        Tuple2<Object, String[]> tuple2 = this.parser().retrieveSegment(this.FILE_HEADER_SEGMENT());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int line = tuple2._1$mcI$sp();
        String[] fhsFields = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)line), (Object)fhsFields);
        Tuple2 tuple23 = tuple22;
        int line2 = tuple23._1$mcI$sp();
        String[] fhsFields2 = (String[])tuple23._2();
        if (line2 != 1) {
            Tuple2<Object, Object> loc = this.structureValidator().getFieldLocation(fhsFields2, fhsFields2.length, 1);
            ErrorEntry entry = new ErrorEntry(line2, 1, loc._2$mcI$sp(), this.FILE_HEADER_SEGMENT() + "[1]", ERROR$.MODULE$, "INVALID_FILE_HEADER_SEGMENT");
            entry.description_$eq("FHS must be the first line of the message.");
            errors.addEntry(entry);
        }
        this.structureValidator().validateSegment("FHS[1]", (HL7SegmentField[])this.profile().segments().apply((Object)"FHS"), fhsFields2, 1, 1, errors);
    }

    private void validateFTS(ValidationErrors errors, int hasFTS, int nbrOfLines) {
        int n = hasFTS;
        switch (n) {
            case 0: {
                ErrorEntry entry = new ErrorEntry(1, 1, 1, this.FILE_TRAILER_SEGMENT() + "[1]", ERROR$.MODULE$, "INVALID_BATCH_SEGMENT");
                entry.description_$eq("Missing File Trailer Segment (FTS), when FHS is present.");
                errors.addEntry(entry);
                break;
            }
            case 1: {
                Tuple2<Object, String[]> tuple2 = this.parser().retrieveSegment(this.FILE_TRAILER_SEGMENT());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int line = tuple2._1$mcI$sp();
                String[] fields = (String[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)line), (Object)fields);
                Tuple2 tuple23 = tuple22;
                int line2 = tuple23._1$mcI$sp();
                String[] fields2 = (String[])tuple23._2();
                if (line2 != nbrOfLines) {
                    Tuple2<Object, Object> loc = this.structureValidator().getFieldLocation(fields2, fields2.length, 1);
                    ErrorEntry entry = new ErrorEntry(line2, 1, loc._2$mcI$sp(), this.FILE_TRAILER_SEGMENT() + "[1]", ERROR$.MODULE$, "INVALID_BATCH_SEGMENT");
                    entry.description_$eq("FTS must be the last entry on the message");
                    errors.addEntry(entry);
                }
                this.structureValidator().validateSegment("FTS[1]", (HL7SegmentField[])this.profile().segments().apply((Object)"FTS"), fields2, line2, 1, errors);
                break;
            }
            default: {
                this.populateDuplicateErrors(errors, this.FILE_TRAILER_SEGMENT());
                break;
            }
        }
    }

    private void validateBHS(ValidationErrors errors) {
        Tuple2<Object, String[]> tuple2 = this.parser().retrieveSegment(this.BATCH_HEADER_SEGMENT());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int line = tuple2._1$mcI$sp();
        String[] bhsFields = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)line), (Object)bhsFields);
        Tuple2 tuple23 = tuple22;
        int line2 = tuple23._1$mcI$sp();
        String[] bhsFields2 = (String[])tuple23._2();
        int hasFHS = this.parser().peek(this.FILE_HEADER_SEGMENT());
        if (hasFHS > 0 && line2 != 2 || hasFHS == 0 && line2 != 1) {
            Tuple2<Object, Object> loc = this.structureValidator().getFieldLocation(bhsFields2, bhsFields2.length, 1);
            ErrorEntry entry = new ErrorEntry(line2, 1, loc._2$mcI$sp(), this.BATCH_HEADER_SEGMENT() + "[1]", ERROR$.MODULE$, "INVALID_BATCH_SEGMENT");
            entry.description_$eq("BHS must be defined before messages");
            errors.addEntry(entry);
        }
        this.structureValidator().validateSegment("BHS[1]", (HL7SegmentField[])this.profile().segments().apply((Object)"BHS"), bhsFields2, line2, 1, errors);
    }

    private void validateBTS(ValidationErrors errors, int nbrOfLines, int nbrOfMessages) {
        int hasBTS;
        int n = hasBTS = this.parser().peek(this.BATCH_TRAILER_SEGMENT());
        switch (n) {
            case 0: {
                ErrorEntry entry = new ErrorEntry(nbrOfLines, 1, 1, this.BATCH_TRAILER_SEGMENT() + "[1]", ERROR$.MODULE$, "INVALID_BATCH_SEGMENT");
                entry.description_$eq("Missing Batch Trailer Segment");
                errors.addEntry(entry);
                break;
            }
            case 1: {
                Tuple2<Object, String[]> tuple2 = this.parser().retrieveSegment(this.BATCH_TRAILER_SEGMENT());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int line = tuple2._1$mcI$sp();
                String[] btsFields = (String[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)line), (Object)btsFields);
                Tuple2 tuple23 = tuple22;
                int line2 = tuple23._1$mcI$sp();
                String[] btsFields2 = (String[])tuple23._2();
                int hasFTS = this.parser().peek(this.FILE_TRAILER_SEGMENT());
                if (hasFTS > 0 && line2 != nbrOfLines - hasFTS || hasFTS == 0 && line2 != nbrOfLines) {
                    Tuple2<Object, Object> loc = this.structureValidator().getFieldLocation(btsFields2, btsFields2.length, 1);
                    ErrorEntry entry = new ErrorEntry(line2, 1, loc._2$mcI$sp(), this.BATCH_TRAILER_SEGMENT() + "[1]", ERROR$.MODULE$, "INVALID_BATCH_SEGMENT");
                    entry.description_$eq("BTS must be the last entry on the message or right before FTS if present");
                    errors.addEntry(entry);
                }
                this.structureValidator().validateSegment("BTS[1]", (HL7SegmentField[])this.profile().segments().apply((Object)"BTS"), btsFields2, line2, 1, errors);
                boolean isNumber = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(btsFields2[1])).toInt()).isSuccess();
                if (!isNumber || new StringOps(Predef$.MODULE$.augmentString(btsFields2[1])).toInt() == nbrOfMessages) break;
                Tuple2<Object, Object> loc = this.structureValidator().getFieldLocation(btsFields2, btsFields2.length, 1);
                ErrorEntry entry = new ErrorEntry(line2, loc._1$mcI$sp(), loc._2$mcI$sp(), this.BATCH_TRAILER_SEGMENT() + "[1]-1[1]", ERROR$.MODULE$, "INVALID_BATCH_SEGMENT");
                entry.description_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch Count does not match number of messages (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nbrOfMessages)})));
                errors.addEntry(entry);
                break;
            }
            default: {
                this.populateDuplicateErrors(errors, this.BATCH_TRAILER_SEGMENT());
                break;
            }
        }
    }

    public List<String> debatchMessages() {
        ListBuffer result;
        block0: {
            result = new ListBuffer();
            ObjectRef newMessage = ObjectRef.create((Object)"");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.message.split(this.parser().NEW_LINE_FEED()))).foreach((Function1 & Serializable & scala.Serializable)line -> {
                BatchValidator.$anonfun$debatchMessages$1(this, result, newMessage, line);
                return BoxedUnit.UNIT;
            });
            if ("".equals((String)newMessage.elem)) break block0;
            result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)newMessage.elem}));
        }
        return result.toList();
    }

    public static final /* synthetic */ int $anonfun$validateBatchingInfo$1(int x$1, Tuple2 x$2) {
        return x$1 + x$2._2$mcI$sp();
    }

    public static final /* synthetic */ boolean $anonfun$validateBatchingInfo$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$validateBatchingInfo$3(ObjectRef errors$1, Tuple2 x$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            String seg = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            if (count == 0) {
                ErrorEntry entry = new ErrorEntry(1, 1, 1, seg + "[1]", ERROR$.MODULE$, "INVALID_BATCH_SEGMENTS");
                entry.description_$eq("If sending batched messages, all 4 segments - FHS, BHS, BTS and FTS - must be included.");
                ((ValidationErrors)errors$1.elem).addEntry(entry);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$populateDuplicateErrors$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$populateDuplicateErrors$2(ValidationErrors errors$2, String segment$1, IntRef index$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 != null) {
            int line = tuple2._1$mcI$sp();
            ErrorEntry entry = new ErrorEntry(line, 1, segment$1.length(), segment$1 + "[" + index$1.elem + "]", ERROR$.MODULE$, "DUPLICATE_SEGMENT");
            entry.description_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate ", " found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{segment$1})));
            errors$2.addEntry(entry);
            ++index$1.elem;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$debatchMessages$1(BatchValidator $this, ListBuffer result$1, ObjectRef newMessage$1, String line) {
        boolean bl;
        String string = line.substring(0, 3).toUpperCase();
        String string2 = $this.FILE_HEADER_SEGMENT();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl = true;
        } else {
            String string4 = $this.BATCH_HEADER_SEGMENT();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                bl = true;
            } else {
                String string6 = $this.BATCH_TRAILER_SEGMENT();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    bl = true;
                } else {
                    String string8 = $this.FILE_TRAILER_SEGMENT();
                    String string9 = string;
                    bl = !(string8 != null ? !string8.equals(string9) : string9 != null);
                }
            }
        }
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string10 = $this.parser().MSH_SEGMENT();
            String string11 = string;
            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                if (!((String)newMessage$1.elem).isEmpty()) {
                    result$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)newMessage$1.elem}));
                }
                newMessage$1.elem = line + "\n";
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                newMessage$1.elem = (String)newMessage$1.elem + (line + "\n");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public BatchValidator(String message, Profile profile) {
        this.message = message;
        this.profile = profile;
        this.FILE_HEADER_SEGMENT = "FHS";
        this.FILE_TRAILER_SEGMENT = "FTS";
        this.BATCH_HEADER_SEGMENT = "BHS";
        this.BATCH_TRAILER_SEGMENT = "BTS";
        this.parser = new HL7ParseUtils(message);
        this.structureValidator = new StructureValidator(message, this.profile(), null);
        this.mapper = new ObjectMapper();
        this.mapper().configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (this.profile() == null) {
            Predef$.MODULE$.println((Object)"Using Default profile");
            String content = Source$.MODULE$.fromResource("DefaultBatchingProfile.json", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n");
            this.profile_$eq((Profile)this.mapper().readValue(content, Profile.class));
        }
        this.fieldDefContent = Source$.MODULE$.fromResource("DefaultFieldsProfile.json", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n");
        this.fieldDefinitions = (Profile)this.mapper().readValue(this.fieldDefContent(), Profile.class);
    }
}

