/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrherintsoahasina.flextools;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import androidx.annotation.IdRes;
import com.google.android.flexbox.FlexboxLayout;
import io.github.mrherintsoahasina.flextools.R;

public class FlexRadioGroup
extends FlexboxLayout {
    private int mCheckedId = -1;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private boolean mProtectFromCheckedChange = false;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private PassThroughHierarchyChangeListener mPassThroughListener;

    public FlexRadioGroup(Context context) {
        super(context);
        this.init();
    }

    public FlexRadioGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.FlexRadioGroup);
        int value = attributes.getResourceId(R.styleable.FlexRadioGroup_flexCheckedButton, -1);
        if (value != -1) {
            this.mCheckedId = value;
        }
        attributes.recycle();
        this.init();
    }

    private void init() {
        this.mChildOnCheckedChangeListener = new CheckedStateTracker();
        this.mPassThroughListener = new PassThroughHierarchyChangeListener();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.mPassThroughListener);
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.mPassThroughListener.mOnHierarchyChangeListener = listener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mCheckedId != -1) {
            this.mProtectFromCheckedChange = true;
            this.setCheckedStateForView(this.mCheckedId, true);
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(this.mCheckedId);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        RadioButton button;
        if (child instanceof RadioButton && (button = (RadioButton)child).isChecked()) {
            this.mProtectFromCheckedChange = true;
            if (this.mCheckedId != -1) {
                this.setCheckedStateForView(this.mCheckedId, false);
            }
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(button.getId());
        }
        super.addView(child, index, params);
    }

    public void check(@IdRes int id) {
        if (id != -1 && id == this.mCheckedId) {
            return;
        }
        if (this.mCheckedId != -1) {
            this.setCheckedStateForView(this.mCheckedId, false);
        }
        if (id != -1) {
            this.setCheckedStateForView(id, true);
        }
        this.setCheckedId(id);
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView instanceof RadioButton) {
            ((RadioButton)checkedView).setChecked(checked);
        }
    }

    private void setCheckedId(@IdRes int id) {
        this.mCheckedId = id;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mCheckedId);
        }
    }

    @IdRes
    public int getCheckedRadioButtonId() {
        return this.mCheckedId;
    }

    public void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (FlexRadioGroup.this.mProtectFromCheckedChange) {
                return;
            }
            FlexRadioGroup.this.mProtectFromCheckedChange = true;
            if (FlexRadioGroup.this.mCheckedId != -1) {
                FlexRadioGroup.this.setCheckedStateForView(FlexRadioGroup.this.mCheckedId, false);
            }
            FlexRadioGroup.this.mProtectFromCheckedChange = false;
            int id = buttonView.getId();
            FlexRadioGroup.this.setCheckedId(id);
        }
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            if (parent == FlexRadioGroup.this && child instanceof RadioButton) {
                int id = child.getId();
                if (id == -1) {
                    id = View.generateViewId();
                    child.setId(id);
                }
                ((RadioButton)child).setOnCheckedChangeListener(FlexRadioGroup.this.mChildOnCheckedChangeListener);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (parent == FlexRadioGroup.this && child instanceof RadioButton) {
                ((RadioButton)child).setOnCheckedChangeListener(null);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(FlexRadioGroup var1, @IdRes int var2);
    }
}

