/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer.utilities;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import sec.web.renderer.SinglePointServer;

public class SinglePointServerTester
implements Runnable {
    private int _port = 0;
    private Boolean _isRunning = false;
    private SinglePointServer _sps = null;

    public SinglePointServerTester(SinglePointServer sps) {
        this._sps = sps;
        this._port = this._sps.getPortNumber();
    }

    public SinglePointServerTester(int portNumber) {
        this._port = portNumber;
    }

    public Boolean isRunning() {
        return this._isRunning;
    }

    @Override
    public void run() {
        String host = "http://127.0.0.1:";
        String strUrl = host + String.valueOf(this._port) + "/SFGP-----------";
        int timeoutInSeconds = 4;
        int port = 0;
        int seconds = 0;
        int response = 0;
        try {
            System.out.println("testing connection...");
            Boolean running = false;
            int timeoutInMiliseconds = timeoutInSeconds * 1000;
            while (!running.booleanValue() && seconds < 30) {
                try {
                    port = this._sps != null ? this._sps.getPortNumber() : this._port;
                    strUrl = host + String.valueOf(port) + "/SFGP-----------";
                    URL url = new URL(strUrl);
                    HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                    urlConn.setRequestMethod("GET");
                    urlConn.setConnectTimeout(timeoutInMiliseconds);
                    urlConn.setReadTimeout(timeoutInMiliseconds);
                    urlConn.connect();
                    response = urlConn.getResponseCode();
                    if (response == 200) {
                        this._isRunning = true;
                        running = true;
                    }
                }
                catch (SocketTimeoutException url) {
                }
                catch (IOException url) {
                }
                catch (Exception url) {
                }
                catch (Throwable url) {
                    // empty catch block
                }
                if (running.booleanValue()) continue;
                Thread.sleep(1000L);
                seconds = seconds + timeoutInSeconds + 1;
            }
            if (this._isRunning.booleanValue()) {
                Date date = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("MMM dd - HH:mm:ss:SSS");
                System.out.println("Single point server is ready as of " + sdf.format(date));
            } else {
                System.out.println("Single point server has not started for 30 seconds");
            }
            this._sps = null;
        }
        catch (InterruptedException iex) {
            System.out.println("SPS connection test thread interupted");
        }
    }
}

