/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer.utilities;

import ArmyC2.C2SD.Rendering.JavaRenderer;
import ArmyC2.C2SD.Rendering.TacticalGraphicIconRenderer;
import ArmyC2.C2SD.Utilities.MilStdSymbol;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.SymbolDef;
import ArmyC2.C2SD.Utilities.SymbolDefTable;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import sec.web.json.utilities.JSONArray;
import sec.web.json.utilities.JSONException;
import sec.web.json.utilities.JSONObject;

public class JavaRendererUtilities {
    public static String HOSTILE_FILL_COLOR = "FFFF8080";
    public static String FRIENDLY_FILL_COLOR = "FF80E0FF";
    public static String NEUTRAL_FILL_COLOR = "FFAAFFAA";
    public static String UNKNOWN_FILL_COLOR = "FFFFFF80";

    public static String ARGBtoABGR(String rgbString) {
        if (rgbString.length() == 6) {
            String s = "FF";
            rgbString = s.concat(rgbString);
        }
        char[] c = rgbString.toCharArray();
        char temp1 = c[2];
        char temp2 = c[3];
        c[2] = c[6];
        c[3] = c[7];
        c[6] = temp1;
        c[7] = temp2;
        String bgrString = new String(c);
        return bgrString;
    }

    public static String normalizeSymbolCode(String symbolCode) {
        String newSymbolCode = symbolCode;
        if (symbolCode.startsWith("G") || symbolCode.startsWith("S")) {
            newSymbolCode = newSymbolCode.substring(0, 1) + '*' + newSymbolCode.substring(2);
            newSymbolCode = newSymbolCode.substring(0, 3) + '*' + newSymbolCode.substring(4);
            newSymbolCode = newSymbolCode.substring(0, 10) + "****" + newSymbolCode.substring(14);
        }
        if (symbolCode.startsWith("S")) {
            newSymbolCode = newSymbolCode.substring(0, 14) + '*';
        }
        return newSymbolCode;
    }

    public static Map<String, String> createParameterMapFromURL(String SymbolInfo2) {
        HashMap<String, String> modifiers = new HashMap<String, String>();
        String symbolID = null;
        String parameters = null;
        String key = null;
        String value = null;
        String[] arrParameters = null;
        String[] arrKeyValue = null;
        String temp = null;
        int questionIndex = SymbolInfo2.lastIndexOf(63);
        try {
            symbolID = questionIndex == -1 ? URLDecoder.decode(SymbolInfo2, "UTF-8") : URLDecoder.decode(SymbolInfo2.substring(0, questionIndex), "UTF-8");
        }
        catch (Exception exc) {
            System.err.println("Error parsing SymbolID");
            System.err.println(exc.getMessage());
        }
        try {
            if (questionIndex > 0 && questionIndex + 1 < SymbolInfo2.length()) {
                parameters = SymbolInfo2.substring(questionIndex + 1, SymbolInfo2.length());
                arrParameters = parameters.split("&");
                for (int i = 0; i < arrParameters.length; ++i) {
                    arrKeyValue = arrParameters[i].split("=");
                    if (arrKeyValue.length != 2 || arrKeyValue[1] == null || arrKeyValue[1].equals("")) continue;
                    key = arrKeyValue[0];
                    value = arrKeyValue[1];
                    temp = URLDecoder.decode(value, "UTF-8");
                    modifiers.put(key.toUpperCase(), temp);
                }
            }
        }
        catch (Exception exc) {
            System.err.println("Error parsing \"" + key.toUpperCase() + "\" parameter from URL");
            System.err.println(exc.getMessage());
        }
        return modifiers;
    }

    public static MilStdSymbol createMilstdSymbol(String SymbolInfo2) {
        String symbolID = null;
        String parameters = null;
        String key = null;
        String value = null;
        String[] arrParameters = null;
        String[] arrKeyValue = null;
        String temp = null;
        HashMap<String, String> modifiers = new HashMap<String, String>();
        int questionIndex = SymbolInfo2.lastIndexOf(63);
        try {
            symbolID = questionIndex == -1 ? URLDecoder.decode(SymbolInfo2, "UTF-8") : URLDecoder.decode(SymbolInfo2.substring(0, questionIndex), "UTF-8");
            if (symbolID.length() < 15) {
                while (symbolID.length() < 15) {
                    symbolID = symbolID + "-";
                }
            }
        }
        catch (Exception exc) {
            System.err.println("Error parsing SymbolID");
            System.err.println(exc.getMessage());
        }
        try {
            if (questionIndex > 0 && questionIndex + 1 < SymbolInfo2.length()) {
                parameters = SymbolInfo2.substring(questionIndex + 1, SymbolInfo2.length());
                arrParameters = parameters.split("&");
                for (int i = 0; i < arrParameters.length; ++i) {
                    arrKeyValue = arrParameters[i].split("=");
                    if (arrKeyValue.length != 2 || arrKeyValue[1] == null || arrKeyValue[1].equals("")) continue;
                    key = arrKeyValue[0];
                    value = arrKeyValue[1];
                    temp = URLDecoder.decode(value, "UTF-8");
                    modifiers.put(key, temp);
                }
            }
        }
        catch (Exception exc) {
            System.err.println("Error parsing \"" + key + "\" parameter from URL");
            System.err.println(exc.getMessage());
        }
        return JavaRendererUtilities.createMilstdSymbol(symbolID, modifiers);
    }

    public static MilStdSymbol createMilstdSymbol(String symbolID, Map<String, String> params) {
        MilStdSymbol symbol = null;
        String key = null;
        String value = null;
        String iconColor = null;
        String lineColor = null;
        String fillColor = null;
        String textColor = null;
        String textBackgroundColor = null;
        String size = null;
        String scale = null;
        String keepUnitRatio = null;
        String alpha = null;
        String symbolOutlineWidth = null;
        String symbolOutlineColor = null;
        String symbologyStandard = null;
        Object temp = null;
        HashMap<String, String> modifiers = new HashMap<String, String>();
        try {
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (key.equalsIgnoreCase("LINECOLOR")) {
                        lineColor = value;
                    } else if (key.equalsIgnoreCase("FILLCOLOR")) {
                        fillColor = value;
                    } else if (key.equalsIgnoreCase("ICONCOLOR")) {
                        iconColor = value;
                    } else if (key.equalsIgnoreCase("TEXTCOLOR")) {
                        textColor = value;
                    } else if (key.equalsIgnoreCase("TEXTBACKGROUNDCOLOR")) {
                        textBackgroundColor = value;
                    } else if (key.equalsIgnoreCase("SIZE")) {
                        size = value;
                    } else if (key.equalsIgnoreCase("SCALE")) {
                        if (SymbolUtilities.isNumber((String)value)) {
                            scale = value;
                        }
                    } else if (key.equalsIgnoreCase("KEEPUNITRATIO")) {
                        keepUnitRatio = value;
                    } else if (key.equalsIgnoreCase("ALPHA")) {
                        if (SymbolUtilities.isNumber((String)value)) {
                            alpha = value;
                        }
                    } else if (key.equalsIgnoreCase("OUTLINESYMBOL")) {
                        symbolOutlineWidth = value;
                    } else if (key.equalsIgnoreCase("OUTLINECOLOR")) {
                        symbolOutlineColor = value;
                    } else if (key.equalsIgnoreCase("SYMSTD")) {
                        symbologyStandard = value;
                    }
                    modifiers.put(key, value);
                }
            }
        }
        catch (Exception exc) {
            System.err.println("Error parsing \"" + key + "\" parameter from URL");
            System.err.println(exc.getMessage());
        }
        try {
            ArrayList<Point2D.Double> coordinates = new ArrayList<Point2D.Double>();
            coordinates.add(new Point2D.Double(0.0, 0.0));
            symbol = new MilStdSymbol(symbolID, null, coordinates, modifiers);
            if (symbologyStandard != null) {
                if (symbologyStandard.equalsIgnoreCase("2525B")) {
                    symbol.setSymbologyStandard(0);
                } else {
                    symbol.setSymbologyStandard(1);
                }
            }
            SymbolDef sd = null;
            Boolean isMultiPoint = false;
            if (SymbolUtilities.isTacticalGraphic((String)symbolID) && (sd = SymbolDefTable.getInstance().getSymbolDef(SymbolUtilities.getBasicSymbolID((String)symbolID), symbol.getSymbologyStandard())) != null && sd.getDrawCategory() != 8) {
                if (TacticalGraphicIconRenderer.getInstance().CanRender(symbolID)) {
                    // empty if block
                }
                isMultiPoint = true;
            }
            if (!isMultiPoint.booleanValue() && !JavaRenderer.getInstance().CanRender(symbolID, null, symbol.getSymbologyStandard()).booleanValue()) {
                symbolID = SymbolUtilities.reconcileSymbolID((String)symbolID, (boolean)isMultiPoint);
                symbol.setSymbolID(symbolID);
                symbol.setLineColor(SymbolUtilities.getLineColorOfAffiliation((String)symbolID));
                symbol.setFillColor(SymbolUtilities.getFillColorOfAffiliation((String)symbolID));
            }
            if (size != null && SymbolUtilities.isNumber(size)) {
                int unitSize = Integer.valueOf(size);
                symbol.setUnitSize(unitSize);
            } else if (!SymbolUtilities.isTacticalGraphic((String)symbolID) && !SymbolUtilities.isWeather((String)symbolID)) {
                int unitSize = 35;
                symbol.setUnitSize(unitSize);
            }
            if (scale != null && SymbolUtilities.isNumber(scale)) {
                symbol.setScale(Double.parseDouble(scale));
            }
            if (keepUnitRatio != null) {
                symbol.setKeepUnitRatio(Boolean.valueOf(Boolean.parseBoolean(keepUnitRatio)));
            } else {
                symbol.setKeepUnitRatio(Boolean.TRUE);
            }
            if (lineColor != null) {
                try {
                    Color lc = SymbolUtilities.getColorFromHexString((String)lineColor);
                    symbol.setLineColor(lc);
                }
                catch (Exception nfe1) {
                    System.err.println("Error parsing lineColor: " + lineColor);
                    System.err.println(nfe1.getMessage());
                }
            }
            if (fillColor != null) {
                try {
                    Color fc = SymbolUtilities.getColorFromHexString((String)fillColor);
                    symbol.setFillColor(fc);
                }
                catch (Exception nfe2) {
                    System.err.println("Error parsing fillColor: " + fillColor);
                    System.err.println(nfe2.getMessage());
                }
            }
            if (textColor != null) {
                try {
                    Color tc = SymbolUtilities.getColorFromHexString((String)textColor);
                    symbol.setTextColor(tc);
                }
                catch (Exception nfe3) {
                    System.err.println("Error parsing textColor: " + textColor);
                    System.err.println(nfe3.getMessage());
                }
            }
            if (iconColor != null) {
                try {
                    Color ic = SymbolUtilities.getColorFromHexString((String)iconColor);
                    symbol.setIconColor(ic);
                }
                catch (Exception nfe4) {
                    System.err.println("Error parsing iconColor: " + iconColor);
                    System.err.println(nfe4.getMessage());
                }
            }
            if (textBackgroundColor != null) {
                try {
                    Color tbc = SymbolUtilities.getColorFromHexString((String)textBackgroundColor);
                    symbol.setTextBackgroundColor(tbc);
                }
                catch (Exception nfe4) {
                    System.err.println("Error parsing textBackgroundColor: " + textColor);
                    System.err.println(nfe4.getMessage());
                }
            }
            if (alpha != null) {
                Color temp1 = symbol.getLineColor();
                Color temp2 = symbol.getFillColor();
                if (SymbolUtilities.isNumber((String)alpha)) {
                    int A = Integer.parseInt(alpha);
                    if (A < 0 || A > 255) {
                        A = 255;
                    }
                    symbol.setLineColor(new Color(temp1.getRed(), temp1.getGreen(), temp1.getBlue(), A));
                    symbol.setFillColor(new Color(temp2.getRed(), temp2.getGreen(), temp2.getBlue(), A));
                }
            }
            if (symbolOutlineWidth != null) {
                int width = 0;
                try {
                    width = Integer.parseInt(symbolOutlineWidth);
                    if (width > 0) {
                        symbol.setOutlineEnabled(true, width);
                    } else {
                        symbol.setOutlineEnabled(false, 0);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (symbol.getOutlineEnabled()) {
                // empty if block
            }
            if (symbolOutlineColor != null) {
                symbol.setOutlineColor(SymbolUtilities.getColorFromHexString((String)symbolOutlineColor));
            }
        }
        catch (Exception exc) {
            System.err.println("Error building MilStdSymbol");
            System.err.println(exc.getMessage());
        }
        return symbol;
    }

    public static String ReconcileSymbolID(String symbolID) {
        StringBuilder sb = new StringBuilder("");
        char codingScheme = symbolID.charAt(0);
        if (symbolID.length() < 15) {
            while (symbolID.length() < 15) {
                symbolID = symbolID + "-";
            }
        }
        if (symbolID.length() > 15) {
            symbolID = symbolID.substring(0, 14);
        }
        if (symbolID != null && symbolID.length() == 15) {
            if (codingScheme == 'S' || codingScheme == 'I' || codingScheme == 'O' || codingScheme == 'E') {
                sb.append(codingScheme);
                if (!SymbolUtilities.hasValidAffiliation((String)symbolID).booleanValue()) {
                    sb.append('U');
                } else {
                    sb.append(symbolID.charAt(1));
                }
                if (!SymbolUtilities.hasValidBattleDimension((String)symbolID).booleanValue()) {
                    sb.append('Z');
                    sb.replace(0, 1, "S");
                } else {
                    sb.append(symbolID.charAt(2));
                }
                if (!SymbolUtilities.hasValidStatus((String)symbolID).booleanValue()) {
                    sb.append('P');
                } else {
                    sb.append(symbolID.charAt(3));
                }
                sb.append("------");
                sb.append(symbolID.substring(10, 15));
            } else if (codingScheme == 'G') {
                sb.append(codingScheme);
                if (!SymbolUtilities.hasValidAffiliation((String)symbolID).booleanValue()) {
                    sb.append('U');
                } else {
                    sb.append(symbolID.charAt(1));
                }
                sb.append('G');
                if (!SymbolUtilities.hasValidStatus((String)symbolID).booleanValue()) {
                    sb.append('P');
                } else {
                    sb.append(symbolID.charAt(3));
                }
                sb.append("GPP---");
                sb.append(symbolID.substring(10, 15));
            } else {
                if (codingScheme == 'W') {
                    return "SUZP-----------";
                }
                sb.append('S');
                if (!SymbolUtilities.hasValidAffiliation((String)symbolID).booleanValue()) {
                    sb.append('U');
                } else {
                    sb.append(symbolID.charAt(1));
                }
                if (!SymbolUtilities.hasValidBattleDimension((String)symbolID).booleanValue()) {
                    sb.append('Z');
                } else {
                    sb.append(symbolID.charAt(2));
                }
                if (!SymbolUtilities.hasValidStatus((String)symbolID).booleanValue()) {
                    sb.append('P');
                } else {
                    sb.append(symbolID.charAt(3));
                }
                sb.append("------");
                sb.append(symbolID.substring(10, 15));
            }
        } else {
            return "SUZP-----------";
        }
        return sb.toString();
    }

    public static boolean is3dSymbol(String symbolCode, String modifiers) {
        boolean returnValue;
        block12: {
            returnValue = false;
            try {
                String symbolId = symbolCode.substring(4, 10);
                if (!symbolId.equals("ACAI--") && !symbolId.equals("ACAR--") && !symbolId.equals("ACAC--") && !symbolId.equals("AKPC--") && !symbolId.equals("AKPR--") && !symbolId.equals("AKPI--") && !symbolId.equals("ALC---") && !symbolId.equals("ALM---") && !symbolId.equals("ALS---") && !symbolId.equals("ALU---") && !symbolId.equals("ALL---") && !symbolId.equals("AAR---") && !symbolId.equals("AAF---") && !symbolId.equals("AAH---") && !symbolId.equals("AAM---") && !symbolId.equals("AAML--") && !symbolId.equals("AAMH--")) break block12;
                try {
                    JSONObject jsonModifiersString = null;
                    JSONObject jsonModifiersArray = null;
                    if (modifiers != null && !modifiers.equals("")) {
                        jsonModifiersString = new JSONObject(modifiers);
                        jsonModifiersArray = jsonModifiersString.has("modifiers") ? jsonModifiersString.getJSONObject("modifiers") : jsonModifiersString;
                    }
                    if (jsonModifiersArray != null) {
                        JSONArray jsonAltitudeArray = null;
                        if (jsonModifiersArray.has("altitudeDepth") && !jsonModifiersArray.isNull("altitudeDepth")) {
                            jsonAltitudeArray = jsonModifiersArray.getJSONArray("altitudeDepth");
                        } else if (jsonModifiersArray.has("X") && !jsonModifiersArray.isNull("X")) {
                            jsonAltitudeArray = jsonModifiersArray.getJSONArray("X");
                        }
                        if (jsonAltitudeArray != null) {
                            returnValue = jsonAltitudeArray.length() < 2 ? jsonAltitudeArray.length() == 1 && (symbolId.equals("AKPC--") || symbolId.equals("AKPR--") || symbolId.equals("AKPI--")) : true;
                        } else if (jsonModifiersArray.has("additionalInfo1") && !jsonModifiersArray.isNull("additionalInfo1") && (symbolId.equals("AKPC--") || symbolId.equals("AKPR--") || symbolId.equals("AKPI--"))) {
                            returnValue = true;
                        }
                    }
                }
                catch (JSONException je) {
                    System.err.println(je.getMessage());
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        return returnValue;
    }

    public static boolean isNumber(String text) {
        return text != null && text.matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+");
    }

    public static String getStackTrace(Throwable thrown) {
        try {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            thrown.printStackTrace(printWriter);
            return ((Object)writer).toString();
        }
        catch (Exception exc) {
            return "";
        }
    }

    public static Point2D getEndPointWithAngle(Point2D ptStart, double angle, double distance) {
        double newX = 0.0;
        double newY = 0.0;
        Point2D.Double pt = new Point2D.Double();
        try {
            double psi = 0.0;
            double alpha1 = Math.PI * angle / 180.0;
            double theta = psi + alpha1;
            double dx = distance * Math.cos(theta);
            double dy = distance * Math.sin(theta);
            newX = ptStart.getX() + dx;
            newY = ptStart.getY() + dy;
            ((Point2D)pt).setLocation(newX, newY);
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        return pt;
    }

    public static double measureDistance(double latitude1, double longitude1, double latitude2, double longitude2, String unitOfMeasure) {
        double rad;
        double distance = -1.0;
        String uom = unitOfMeasure.toLowerCase();
        if (uom.equals("meters")) {
            rad = 6378137.0;
        } else if (uom.equals("kilometers")) {
            rad = 6378.137;
        } else if (uom.equals("miles")) {
            rad = 3963.1;
        } else if (uom.equals("feet")) {
            rad = 2.09255249E7;
        } else if (uom.equals("yards")) {
            rad = 6975174.98;
        } else if (uom.equals("nautical")) {
            rad = 3443.9;
        } else if (uom.equals("nautical miles")) {
            rad = 3443.9;
        } else {
            return -1.0;
        }
        distance = Math.acos(Math.cos(latitude1 *= Math.PI / 180) * Math.cos(longitude1 *= Math.PI / 180) * Math.cos(latitude2 *= Math.PI / 180) * Math.cos(longitude2 *= Math.PI / 180) + Math.cos(latitude1) * Math.sin(longitude1) * Math.cos(latitude2) * Math.sin(longitude2) + Math.sin(latitude1) * Math.sin(latitude2)) * rad;
        return distance;
    }

    public static String generateLookAtTag(ArrayList<Point2D.Double> geoCoords, ArrayList<Double> modsAM) {
        Boolean doLookAt = true;
        RectangularShape controlPointBounds = null;
        Point2D tempPt = null;
        StringBuilder LookAtTag = new StringBuilder("<LookAt>");
        if (doLookAt.booleanValue()) {
            for (int j = 0; j < geoCoords.size(); ++j) {
                tempPt = geoCoords.get(j);
                if (controlPointBounds != null) {
                    Rectangle2D.union((Rectangle2D)controlPointBounds, new Rectangle2D.Double(tempPt.getX(), tempPt.getY(), 1.0E-14, 1.0E-14), (Rectangle2D)controlPointBounds);
                    continue;
                }
                controlPointBounds = new Rectangle2D.Double(tempPt.getX(), tempPt.getY(), 1.0E-14, 1.0E-14);
            }
            double distance = 0.0;
            distance = geoCoords.size() == 1 && modsAM != null && modsAM.size() > 0 ? modsAM.get(modsAM.size() - 1) * 2.0 : JavaRendererUtilities.measureDistance(controlPointBounds.getMinY(), controlPointBounds.getMinX(), controlPointBounds.getMaxY(), controlPointBounds.getMaxX(), "meters");
            distance *= 1.1;
            double lon = controlPointBounds.getCenterX();
            double lat = controlPointBounds.getCenterY();
            LookAtTag.append("<longitude>" + lon + "</longitude>");
            LookAtTag.append("<latitude>" + lat + "</latitude>");
            LookAtTag.append("<heading>0</heading>");
            LookAtTag.append("<tilt>0</tilt>");
            LookAtTag.append("<range>" + distance + "</range>");
            LookAtTag.append("<altitudeMode>absolute</altitudeMode>");
            LookAtTag.append("</LookAt>");
        }
        return LookAtTag.toString();
    }

    public static String sanitizeSymbolID(String symbolID) {
        String code = symbolID;
        char affiliation = symbolID.charAt(1);
        if (!SymbolUtilities.isWeather((String)symbolID)) {
            if (affiliation != 'F' && affiliation != 'H' && affiliation != 'U' && affiliation != 'N') {
                code = affiliation == 'S' ? code.charAt(0) + "H" + code.substring(2, 15) : (affiliation == 'L' ? code.charAt(0) + "N" + code.substring(2, 15) : (affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'K' || affiliation == 'J' ? code.charAt(0) + "F" + code.substring(2, 15) : (affiliation == 'P' || affiliation == 'G' || affiliation == 'O' || affiliation == 'W' ? code.charAt(0) + "U" + code.substring(2, 15) : code.charAt(0) + "U" + code.substring(2, 15))));
            }
            code = code.substring(0, 10) + "-----";
        }
        return code;
    }

    public static String addAltModeToModifiersString(String modifiers, String altMode) {
        String alt = "";
        StringBuilder altsb = new StringBuilder();
        if (altMode != null) {
            alt = "";
            if (altMode.equals("relativeToGround")) {
                alt = "AGL";
            } else if (altMode.equals("absolute")) {
                alt = "MSL";
            }
            if (modifiers == null || modifiers.isEmpty()) {
                altsb.append("{\"");
                altsb.append("ALTMODE");
                altsb.append("\":\"");
                altsb.append(alt);
                altsb.append("\"}");
            } else if (modifiers.endsWith("}}")) {
                altsb.append(modifiers);
                altsb.delete(modifiers.length() - 2, modifiers.length());
                altsb.append(",\"");
                altsb.append("ALTMODE");
                altsb.append("\":\"");
                altsb.append(alt);
                altsb.append("\"}}");
            } else if (modifiers.endsWith("}")) {
                altsb.append(modifiers);
                altsb.delete(modifiers.length() - 1, modifiers.length());
                altsb.append(",\"");
                altsb.append("ALTMODE");
                altsb.append("\":\"");
                altsb.append(alt);
                altsb.append("\"}");
            }
        }
        return altsb.toString();
    }

    public static Map<String, String> parseIconParameters(String symbolId, Map<String, String> params) {
        Color fillColor;
        HashMap<String, String> iconInfo = new HashMap<String, String>();
        iconInfo.put("KEEPUNITRATIO", "false");
        if (SymbolUtilities.isWarfighting((String)symbolId)) {
            fillColor = SymbolUtilities.getFillColorOfAffiliation((String)symbolId);
            iconInfo.put("FILLCOLOR", SymbolUtilities.colorToHexString((Color)fillColor, (Boolean)Boolean.TRUE));
        }
        if (params.containsKey("FILLCOLOR")) {
            iconInfo.put("FILLCOLOR", params.get("FILLCOLOR"));
        }
        if (symbolId.substring(0, 1).equals("G")) {
            fillColor = SymbolUtilities.getLineColorOfAffiliation((String)symbolId);
            iconInfo.put("LINECOLOR", SymbolUtilities.colorToHexString((Color)fillColor, (Boolean)Boolean.TRUE));
        }
        if (params.containsKey("LINECOLOR")) {
            iconInfo.put("LINECOLOR", params.get("LINECOLOR"));
        }
        if (params.containsKey("SYMSTD")) {
            String symStd = params.get("SYMSTD");
            if (symStd.length() != 1) {
                if (symStd.startsWith("2525") && symStd.length() == 5) {
                    char version = symStd.charAt(4);
                    switch (version) {
                        case 'B': 
                        case 'b': {
                            symStd = "0";
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            symStd = "1";
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            symStd = "2";
                            break;
                        }
                        default: {
                            symStd = String.valueOf(RendererSettings.getInstance().getSymbologyStandard());
                            break;
                        }
                    }
                } else {
                    symStd = String.valueOf(RendererSettings.getInstance().getSymbologyStandard());
                }
            } else {
                char version = symStd.charAt(0);
                switch (version) {
                    case '0': 
                    case '1': 
                    case '2': {
                        break;
                    }
                    default: {
                        symStd = String.valueOf(RendererSettings.getInstance().getSymbologyStandard());
                    }
                }
            }
            iconInfo.put("SYMSTD", symStd);
        }
        if (params.containsKey("KEEPUNITRATIO")) {
            iconInfo.put("KEEPUNITRATIO", params.get("KEEPUNITRATIO"));
        }
        if (params.containsKey("ALPHA")) {
            iconInfo.put("ALPHA", params.get("ALPHA"));
        }
        if (params.containsKey("RENDERER")) {
            iconInfo.put("RENDERER", params.get("RENDERER"));
        }
        if (params.containsKey("SIZE")) {
            iconInfo.put("SIZE", params.get("SIZE"));
        }
        if (params.containsKey("OUTLINECOLOR")) {
            iconInfo.put("OUTLINECOLOR", params.get("OUTLINECOLOR"));
        }
        iconInfo.put("OUTLINESYMBOL", "0");
        iconInfo.put("ICON", "true");
        return iconInfo;
    }
}

