/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;

public class UrlTester
implements Runnable {
    private int _port = 0;
    private Boolean _isRunning = false;
    private Boolean _isAvailable = false;
    private Boolean _verbose = false;
    private String _strUrl = null;
    private String _name = null;
    private URL _url = null;
    private int _timeoutSeconds = 4;
    private int _timeoutDuration = 30;
    private int _retries = 3;

    public UrlTester(String url, String name, int timeout, int retries) {
        this._strUrl = url.toString();
        this._name = name;
        this._timeoutSeconds = timeout;
        this._retries = retries;
    }

    public void setTimeoutInSeconds(int timeout) {
        this._timeoutSeconds = timeout;
    }

    public void setRetryDurationInSeconds(int duration) {
        this._timeoutDuration = duration;
    }

    public void setRetyCount(int retries) {
        this._retries = retries;
    }

    public Boolean isAvailable() {
        return this._isRunning;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    @Override
    public void run() {
        int seconds = 0;
        int response = 0;
        try {
            if (this._verbose.booleanValue()) {
                if (this._name != null) {
                    System.out.println("testing connection to: " + this._name);
                } else {
                    System.out.println("testing connection to: " + this._strUrl);
                }
            }
            Boolean running = false;
            int timeoutInMiliseconds = this._timeoutSeconds * 1000;
            for (int attemptCount = 1; !running.booleanValue() && attemptCount <= this._retries; ++attemptCount) {
                block28: {
                    if (this._verbose.booleanValue()) {
                        System.out.println("Attempt: #" + String.valueOf(attemptCount));
                    }
                    try {
                        URL url = new URL(this._strUrl);
                        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                        urlConn.setRequestMethod("GET");
                        urlConn.setConnectTimeout(timeoutInMiliseconds);
                        urlConn.setReadTimeout(timeoutInMiliseconds);
                        urlConn.connect();
                        response = urlConn.getResponseCode();
                        if (response == 200) {
                            this._isRunning = true;
                            running = true;
                        } else if (this._verbose.booleanValue()) {
                            System.out.println("Response code: " + response);
                        }
                    }
                    catch (SocketTimeoutException stexc) {
                        if (this._verbose.booleanValue()) {
                            System.out.println("SocketTimeoutException: " + stexc.getMessage());
                        }
                    }
                    catch (IOException ioexc) {
                        if (this._verbose.booleanValue()) {
                            System.out.println("IOException: " + ioexc.getMessage());
                        }
                    }
                    catch (Exception exc) {
                        if (this._verbose.booleanValue()) {
                            System.out.println("Exception: " + exc.getMessage());
                        }
                    }
                    catch (Throwable t) {
                        if (!this._verbose.booleanValue()) break block28;
                        System.out.println("Throwable: " + t.getMessage());
                    }
                }
                if (running.booleanValue()) continue;
                Thread.sleep(1000L);
                seconds = seconds + this._timeoutSeconds + 1;
            }
            if (this._isRunning.booleanValue()) {
                if (this._name != null) {
                    if (this._verbose.booleanValue()) {
                        System.out.println(this._name + " is available.");
                    }
                } else if (this._verbose.booleanValue()) {
                    System.out.println("URL available: " + this._strUrl);
                }
            } else if (this._name != null) {
                if (this._verbose.booleanValue()) {
                    System.out.println(this._name + " is not available.");
                }
            } else if (this._verbose.booleanValue()) {
                System.out.println("URL not available: " + this._strUrl);
            }
        }
        catch (InterruptedException iex) {
            System.out.println("URL test thread interupted");
        }
    }
}

