/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer;

import ArmyC2.C2SD.RendererPluginInterface.ISinglePointInfo;
import ArmyC2.C2SD.RendererPluginInterface.ISinglePointRenderer;
import ArmyC2.C2SD.RendererPluginInterface.SinglePointInfo;
import ArmyC2.C2SD.Rendering.IJavaRenderer;
import ArmyC2.C2SD.Rendering.JavaRenderer;
import ArmyC2.C2SD.Rendering.TacticalGraphicIconRenderer;
import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.IPointConversion;
import ArmyC2.C2SD.Utilities.ImageInfo;
import ArmyC2.C2SD.Utilities.MilStdSymbol;
import ArmyC2.C2SD.Utilities.PointConversionDummy;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.SymbolDef;
import ArmyC2.C2SD.Utilities.SymbolDefTable;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.logging.Level;
import sec.web.renderer.utilities.JavaRendererUtilities;

public class SinglePoint2525Renderer
implements ISinglePointRenderer {
    private static IJavaRenderer jr = null;
    private static TacticalGraphicIconRenderer tgir = null;
    public static final String RENDERER_ID = "2525";

    public SinglePoint2525Renderer() {
        jr = JavaRenderer.getInstance();
        tgir = TacticalGraphicIconRenderer.getInstance();
    }

    public String getRendererID() {
        return RENDERER_ID;
    }

    public Boolean canRender(String symbolID, Map<String, String> params) {
        MilStdSymbol ms = JavaRendererUtilities.createMilstdSymbol(symbolID, params);
        return jr.CanRender(ms);
    }

    public ISinglePointInfo render(String symbolID, Map<String, String> params) {
        PointConversionDummy pConverter = new PointConversionDummy();
        ImageInfo ii = null;
        SymbolDef sd = null;
        SinglePointInfo spi = null;
        MilStdSymbol ms = null;
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        if (params.containsKey("SYMSTD")) {
            char version;
            String ss = params.get("SYMSTD");
            if (ss.length() != 1) {
                if (ss.startsWith(RENDERER_ID) && ss.length() == 5) {
                    version = ss.charAt(4);
                    switch (version) {
                        case 'B': 
                        case 'b': {
                            symStd = 0;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            symStd = 1;
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            symStd = 2;
                            break;
                        }
                        default: {
                            symStd = RendererSettings.getInstance().getSymbologyStandard();
                            break;
                        }
                    }
                } else {
                    symStd = RendererSettings.getInstance().getSymbologyStandard();
                }
            } else {
                version = ss.charAt(0);
                switch (version) {
                    case '0': 
                    case '1': 
                    case '2': {
                        break;
                    }
                    default: {
                        symStd = RendererSettings.getInstance().getSymbologyStandard();
                    }
                }
            }
        }
        try {
            if (SymbolUtilities.isTacticalGraphic((String)symbolID)) {
                sd = SymbolDefTable.getInstance().getSymbolDef(SymbolUtilities.getBasicSymbolID((String)symbolID), symStd);
            }
            if (sd != null && sd.getDrawCategory() != 8) {
                int size = 35;
                Color lineColor = SymbolUtilities.getLineColorOfAffiliation((String)symbolID);
                if (params.containsKey("SIZE")) {
                    size = Integer.parseInt(params.get("SIZE"));
                }
                if (params.containsKey("LINECOLOR")) {
                    lineColor = SymbolUtilities.getColorFromHexString((String)params.get("LINECOLOR"));
                }
                ii = tgir.getIcon(symbolID, size, lineColor, symStd);
            } else {
                ms = JavaRendererUtilities.createMilstdSymbol(symbolID, params);
                jr.Render(ms, (IPointConversion)pConverter, null);
                ii = ms.toImageInfo();
            }
            if (ii == null) {
                if (ms == null) {
                    ms = JavaRendererUtilities.createMilstdSymbol(symbolID, params);
                }
                String tempID = "S" + symbolID.charAt(1) + "Z" + symbolID.charAt(3) + symbolID.substring(4);
                tempID = SymbolUtilities.reconcileSymbolID((String)tempID, (boolean)false);
                ms.setSymbolID(tempID);
                ms.setLineColor(SymbolUtilities.getLineColorOfAffiliation((String)tempID));
                ms.setFillColor(SymbolUtilities.getFillColorOfAffiliation((String)tempID));
                ms.setOutlineEnabled(false);
                if (params.containsKey("FILLCOLOR")) {
                    ms.setFillColor(SymbolUtilities.getColorFromHexString((String)params.get("FILLCOLOR")));
                }
                if (params.containsKey("LINECOLOR")) {
                    ms.setLineColor(SymbolUtilities.getColorFromHexString((String)params.get("LINECOLOR")));
                }
                jr.Render(ms, (IPointConversion)pConverter, null);
                ii = ms.toImageInfo();
            }
            spi = new SinglePointInfo(ii.getImage(), (Point2D)ii.getSymbolCenterPoint(), ii.getSymbolBounds());
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"SinglePoint2525Renderer", (String)"render", (Exception)exc, (Level)Level.WARNING, (Boolean)Boolean.FALSE);
        }
        return spi;
    }
}

