/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import sec.web.renderer.SECRenderer;

public class MultiPointServer {
    private HttpServer httpServer;
    private int portNumber = 6790;
    private int _backLog = 0;

    public MultiPointServer(int port) {
        this.portNumber = port;
        this.createHttpServer();
    }

    public MultiPointServer(int port, int backlog) {
        this.portNumber = port;
        this.createHttpServer();
    }

    private void createHttpServer() {
        try {
            int backlog = this._backLog;
            this.httpServer = HttpServer.create(new InetSocketAddress("127.0.0.1", this.portNumber), backlog);
            HttpContext c3d = this.httpServer.createContext("/mil-sym-service/renderer/mp3d/", new MultiPointHandler(false));
            HttpContext c2d = this.httpServer.createContext("/mil-sym-service/renderer/mp2d/", new MultiPointHandler(true));
            c3d.getFilters().add(new ParameterFilter());
            c2d.getFilters().add(new ParameterFilter());
            this.httpServer.setExecutor(Executors.newCachedThreadPool());
        }
        catch (BindException bexc) {
            String strTypicalPortInUseMessage = "Address already in use: bind";
            if (bexc.getMessage().startsWith(strTypicalPortInUseMessage)) {
                System.out.println("Port " + String.valueOf(this.portNumber) + " already in use. Incrementing...");
            } else {
                System.err.println(bexc.getMessage());
                bexc.printStackTrace();
            }
            ++this.portNumber;
            this.createHttpServer();
        }
        catch (IOException exc) {
            System.err.println(exc.getMessage());
            System.err.println(ErrorLogger.getStackTrace((Throwable)exc));
        }
        catch (Exception exc2) {
            System.err.println(exc2.getMessage());
            System.err.println(ErrorLogger.getStackTrace((Throwable)exc2));
        }
    }

    public void start() {
        try {
            this.httpServer.start();
            System.out.println("Multi point server started on port #" + String.valueOf(this.portNumber));
        }
        catch (Exception e) {
            ++this.portNumber;
            this.createHttpServer();
        }
    }

    public void stop() {
        if (this.httpServer != null) {
            try {
                this.httpServer.stop(0);
            }
            catch (Exception e) {
                this.httpServer = null;
            }
        }
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public class ParameterFilter
    extends Filter {
        @Override
        public String description() {
            return "Parses the requested URI for parameters";
        }

        @Override
        public void doFilter(HttpExchange exchange, Filter.Chain chain) throws IOException {
            this.parseGetParameters(exchange);
            this.parsePostParameters(exchange);
            chain.doFilter(exchange);
        }

        private void parseGetParameters(HttpExchange exchange) throws UnsupportedEncodingException {
            HashMap<String, String> parameters = new HashMap<String, String>();
            URI requestedUri = exchange.getRequestURI();
            String query = requestedUri.getRawQuery();
            this.parseQuery(query, parameters);
            exchange.setAttribute("parameters", parameters);
        }

        private void parsePostParameters(HttpExchange exchange) throws IOException {
            if ("post".equalsIgnoreCase(exchange.getRequestMethod())) {
                Map parameters = (Map)exchange.getAttribute("parameters");
                InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), "utf-8");
                BufferedReader br = new BufferedReader(isr);
                String query = br.readLine();
                this.parseQuery(query, parameters);
            }
        }

        private void parseQuery(String query, Map<String, String> parameters) throws UnsupportedEncodingException {
            if (query != null) {
                String[] pairs;
                for (String pair : pairs = query.split("[&]")) {
                    String[] param = pair.split("[=]");
                    String key = null;
                    String value = null;
                    if (param.length > 0) {
                        key = URLDecoder.decode(param[0], System.getProperty("file.encoding")).toUpperCase();
                    }
                    if (param.length > 1) {
                        value = URLDecoder.decode(param[1], System.getProperty("file.encoding"));
                    }
                    parameters.put(key, value);
                }
            }
        }
    }

    class MultiPointHandler
    implements HttpHandler {
        private SECRenderer sr = SECRenderer.getInstance();
        private Boolean is2D = false;

        public MultiPointHandler(Boolean for2D) {
            this.is2D = for2D;
        }

        private Map<String, String> copyParams(Map<String, String> params) {
            HashMap<String, String> copy = new HashMap<String, String>();
            String tempVal = null;
            copy.putAll(params);
            Iterator it = copy.entrySet().iterator();
            boolean retry = false;
            while (it.hasNext()) {
                String test;
                Map.Entry entry = it.next();
                tempVal = (String)entry.getValue();
                if (tempVal == null || !(test = tempVal.toLowerCase()).contains("script>")) continue;
                entry.setValue("");
            }
            return copy;
        }

        private byte[] getMultiPointKML(HttpExchange he, String symbolCode) {
            byte[] byteArray = null;
            String kml = null;
            int origCount = 0;
            boolean origCount2 = false;
            boolean newCount = false;
            int attempts = 0;
            int limit = 4;
            try {
                Map<String, String> params = (Map<String, String>)he.getAttribute("parameters");
                origCount = params.size();
                while (origCount < 11) {
                    try {
                        Thread.sleep(10L);
                        origCount = params.size();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    if (++attempts < limit) continue;
                }
                params = this.copyParams(params);
                String symbolID = null;
                int questionIndex = symbolCode.lastIndexOf(63);
                symbolID = questionIndex == -1 ? URLDecoder.decode(symbolCode, "UTF-8") : URLDecoder.decode(symbolCode.substring(0, questionIndex), "UTF-8");
                String id = "";
                String name = "";
                String description = "";
                String controlPoints = "";
                String altitudeMode = "";
                double scale = 0.0;
                String bbox = "";
                String modifiers = "";
                int format = 0;
                int symStd = 0;
                int pWidth = 0;
                int pHeight = 0;
                String temp = "";
                try {
                    id = params.get("ID");
                    name = params.get("NAME");
                    description = params.get("DESCRIPTION");
                    controlPoints = params.get("CONTROLPOINTS");
                    if (params.containsKey("ALTITUDEMODE")) {
                        altitudeMode = params.get("ALTITUDEMODE");
                    }
                    if (params.containsKey("SCALE")) {
                        temp = params.get("SCALE");
                        scale = Double.valueOf(temp);
                    }
                    bbox = params.get("BBOX");
                    modifiers = params.get("MODIFIERS");
                    temp = params.get("FORMAT");
                    format = Integer.parseInt(temp);
                    temp = params.get("SYMSTD");
                    symStd = Integer.parseInt(temp);
                    if (params.containsKey("PIXELWIDTH")) {
                        temp = params.get("PIXELWIDTH");
                        pWidth = Integer.parseInt(temp);
                    }
                    if (params.containsKey("PIXELHEIGHT")) {
                        temp = params.get("PIXELHEIGHT");
                        pHeight = Integer.parseInt(params.get("PIXELHEIGHT"));
                    }
                }
                catch (Exception exc1) {
                    ErrorLogger.LogException((String)"SinglePointServer", (String)"getMultiPointKML", (Exception)exc1, (Level)Level.WARNING);
                }
                try {
                    kml = !this.is2D.booleanValue() ? SECRenderer.getInstance().RenderMultiPointSymbol(id, name, description, symbolID, controlPoints, altitudeMode, scale, bbox, modifiers, format, symStd) : SECRenderer.getInstance().RenderMultiPointSymbol2D(id, name, description, symbolID, controlPoints, pWidth, pHeight, bbox, modifiers, format, symStd);
                }
                catch (Exception foo) {
                    ErrorLogger.LogException((String)"SinglePointServer", (String)"getMultiPointKML", (Exception)foo, (Level)Level.WARNING);
                    Object[] parameters = null;
                    parameters = this.is2D == false ? new String[]{id, name, description, symbolID, controlPoints, altitudeMode, String.valueOf(scale), bbox, modifiers, String.valueOf(format), String.valueOf(symStd)} : new String[]{id, name, description, symbolID, controlPoints, String.valueOf(pWidth), String.valueOf(pHeight), bbox, modifiers, String.valueOf(format), String.valueOf(symStd)};
                    ErrorLogger.LogMessage((String)"SinglePointServer", (String)"getMultiPointKML", (String)"parameters: ", (Level)Level.WARNING, (Object[])parameters, (Boolean)false);
                }
                if (kml != null && !kml.equals("")) {
                    byteArray = kml.getBytes("UTF-8");
                }
            }
            catch (UnsupportedEncodingException uee) {
                ErrorLogger.LogException((String)"SinglePointServer", (String)"getMultiPointKML", (Exception)uee, (Level)Level.WARNING);
            }
            catch (NumberFormatException nfe) {
                ErrorLogger.LogException((String)"SinglePointServer", (String)"getMultiPointKML", (Exception)nfe, (Level)Level.WARNING);
            }
            catch (ConcurrentModificationException cme) {
                ErrorLogger.LogException((String)"SinglePointServer", (String)"getMultiPointKML", (Exception)cme, (Level)Level.WARNING);
            }
            catch (Exception exc) {
                ErrorLogger.LogException((String)"SinglePointServer", (String)"getMultiPointKML", (Exception)exc, (Level)Level.WARNING);
            }
            return byteArray;
        }

        @Override
        public void handle(HttpExchange exchange) {
            if (exchange.getRequestMethod().equalsIgnoreCase("POST")) {
                Headers headers;
                int format = -1;
                String contentType = "text/plain;charset=UTF-8";
                Map params = (Map)exchange.getAttribute("parameters");
                if (params != null && params.containsKey("FORMAT")) {
                    format = Integer.parseInt((String)params.get("FORMAT"));
                    if (format == 0) {
                        contentType = "text/xml;charset=UTF-8";
                    } else if (format == 1 || format == 2) {
                        contentType = "application/json;charset=UTF-8";
                    }
                }
                String url = null;
                String allowOrigin = exchange.getRemoteAddress().toString();
                byte[] kmlResponse = null;
                try {
                    url = exchange.getRequestURI().toString();
                    String symbolID = url.substring(url.lastIndexOf("/") + 1);
                    kmlResponse = this.getMultiPointKML(exchange, symbolID);
                }
                catch (Exception exc) {
                    ErrorLogger.LogException((String)"MultiPointServer", (String)"handle", (Exception)exc, (Level)Level.WARNING);
                    try {
                        headers = exchange.getResponseHeaders();
                        headers.set("Content-Type", "text/plain;charset=UTF-8");
                        if (allowOrigin.contains("127.0.0.1")) {
                            headers.set("Access-Control-Allow-Origin", "*");
                        }
                        exchange.sendResponseHeaders(503, 0L);
                        exchange.getResponseBody().close();
                    }
                    catch (IOException ex) {
                        ErrorLogger.LogException((String)"MultiPointServer", (String)"handle", (Exception)ex, (Level)Level.WARNING);
                    }
                    catch (Exception exc2) {
                        ErrorLogger.LogException((String)"MultiPointServer", (String)"handle", (Exception)exc2, (Level)Level.WARNING);
                    }
                }
                if (kmlResponse != null) {
                    OutputStream responseBody = null;
                    try {
                        headers = exchange.getResponseHeaders();
                        headers.set("Content-Type", contentType);
                        if (allowOrigin.contains("127.0.0.1")) {
                            headers.set("Access-Control-Allow-Origin", "*");
                        }
                        exchange.sendResponseHeaders(200, 0L);
                        responseBody = exchange.getResponseBody();
                        responseBody.write(kmlResponse);
                        responseBody.close();
                    }
                    catch (IOException exc) {
                        Date date = new Date();
                        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss:SSS");
                        System.err.println("MultiPointServer.handle() tried sending response");
                        System.err.println(sdf.format(date));
                        System.err.println(exchange.getRequestURI().toString());
                        System.err.println(exc.getMessage());
                    }
                    catch (Exception exc3) {
                        ErrorLogger.LogException((String)"MultiPointServer", (String)"handle", (Exception)exc3, (Level)Level.WARNING);
                    }
                }
            }
        }
    }
}

