/*
 * Decompiled with CFR 0.152.
 */
package sec.web.renderer;

import ArmyC2.C2SD.RendererPluginInterface.ISinglePointInfo;
import ArmyC2.C2SD.Rendering.MultiPointRenderer;
import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.IPointConversion;
import ArmyC2.C2SD.Utilities.MilStdSymbol;
import ArmyC2.C2SD.Utilities.PointConversion;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.ShapeInfo;
import ArmyC2.C2SD.Utilities.SymbolDef;
import ArmyC2.C2SD.Utilities.SymbolDefTable;
import ArmyC2.C2SD.Utilities.SymbolDraw;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import JavaLineArray.CELineArray;
import JavaLineArray.POINT2;
import JavaTacticalRenderer.TGLight;
import JavaTacticalRenderer.mdlGeodesic;
import RenderMultipoints.clsClipPolygon2;
import RenderMultipoints.clsRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import sec.geo.GeoPoint;
import sec.geo.kml.KmlOptions;
import sec.geo.kml.XsltCoordinateWrapper;
import sec.web.json.utilities.JSONArray;
import sec.web.json.utilities.JSONException;
import sec.web.json.utilities.JSONObject;
import sec.web.renderer.PointConverter;
import sec.web.renderer.SECWebRenderer;
import sec.web.renderer.SinglePointRendererService;
import sec.web.renderer.utilities.JavaRendererUtilities;
import sec.web.renderer.utilities.LineInfo;
import sec.web.renderer.utilities.PNGInfo;
import sec.web.renderer.utilities.SymbolInfo;
import sec.web.renderer.utilities.TextInfo;

public class MultiPointHandler {
    private static final String MODIFIER_HEADER = "modifiers";
    private static final String QUANTITY = "quantity";
    private static final String REINFORCE_OR_REDUCED = "reinforcedOrReduced";
    private static final String STAFF_COMMENTS = "staffComments";
    private static final String ADDITIONAL_INFO_1 = "additionalInfo1";
    private static final String ADDITIONAL_INFO_2 = "additionalInfo2";
    private static final String ADDITIONAL_INFO_3 = "additionalInfo3";
    private static final String EVALUATION_RATION = "evaluationRating";
    private static final String COMBAT_EFFECTIVENESS = "combatEffectiveness";
    private static final String SIGNATURE_EQUIPMENT = "signatureEquipment";
    private static final String HIGHER_FORMATION = "higherFormation";
    private static final String HOSTILE = "hostile";
    private static final String IFFSIFF = "iffSif";
    private static final String DIRECTION_OF_MOVEMENT = "directionOfMovement";
    private static final String UNIQUE_DESIGNATION_1 = "uniqueDesignation1";
    private static final String UNIQUE_DESIGNATION_2 = "uniqueDesignation2";
    private static final String EQUIPMENT_TYPE = "equipmentType";
    private static final String DATE_TIME_GROUP_1 = "dateTimeGroup1";
    private static final String DATE_TIME_GROUP_2 = "dateTimeGroup2";
    private static final String DATE_TIME_GROUP_3 = "dateTimeGroup3";
    private static final String ALTITUDE_DEPTH = "altitudeDepth";
    private static final String LOCATION = "location";
    private static final String SPEED = "speed";
    private static final String SPECIAL_C2_HQ = "specialC2Headquarters";
    private static final String DISTANCE = "distance";
    private static final String AZIMUTH = "azimuth";
    private static final String FILL_COLOR = "fillColor";
    private static final String LINE_COLOR = "lineColor";
    private static final String LINE_THICKNESS = "lineThickness";
    private static final String TEXT_COLOR = "textColor";
    private static final String TEXT_BACKGROUND_COLOR = "textBackgroundColor";
    private static final String USE_DASH_ARRAY = "useDashArray";
    private static final String USE_PATTERN_FILL = "usePatternFill";
    private static final String PATTERN_FILL_TYPE = "patternFillType";
    private static final String SYMBOL_FILL_ICON_SIZE = "symbolFillIconSize";
    private static final String SYMBOL_FILL_IDS = "symbolFillIds";
    private static final String SYMBOL_LINE_IDS = "symbolLineIds";
    public static final int Symbology_2525Bch2_USAS_13_14 = 0;
    public static final int Symbology_2525C = 1;
    private static final int _maxPixelWidth = 1000;
    private static final int _minPixelWidth = 100;

    public static void NormalizeGECoordsToGEExtents(double leftLongitude, double rightLongitude, ArrayList<Point2D.Double> pts2d) {
        try {
            int j = 0;
            double x = 0.0;
            double y = 0.0;
            Point2D.Double pt2d = null;
            for (j = 0; j < pts2d.size(); ++j) {
                pt2d = pts2d.get(j);
                y = pt2d.getY();
                for (x = pt2d.getX(); x < leftLongitude; x += 360.0) {
                }
                while (x > rightLongitude) {
                    x -= 360.0;
                }
                pt2d = new Point2D.Double(x, y);
                pts2d.set(j, pt2d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Point2D NormalizeCoordToGECoord(Point2D pt2d) {
        Point2D.Double ptGeo = null;
        try {
            double x;
            double y = pt2d.getY();
            for (x = pt2d.getX(); x < -180.0; x += 360.0) {
            }
            while (x > 180.0) {
                x -= 360.0;
            }
            ptGeo = new Point2D.Double(x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ptGeo;
    }

    private static String getBoundingRectangle(String controlPoints, String bbox) {
        String bbox2 = "";
        try {
            Double left = 0.0;
            Double right = 0.0;
            Double top = 0.0;
            Double bottom = 0.0;
            String[] coordinates = controlPoints.split(" ");
            int len = coordinates.length;
            int i = 0;
            left = Double.MAX_VALUE;
            right = -1.7976931348623157E308;
            top = -1.7976931348623157E308;
            bottom = Double.MAX_VALUE;
            for (i = 0; i < len; ++i) {
                String[] coordPair = coordinates[i].split(",");
                Double latitude = (double)Double.valueOf(coordPair[1].trim());
                Double longitude = (double)Double.valueOf(coordPair[0].trim());
                if (longitude < left) {
                    left = longitude;
                }
                if (longitude > right) {
                    right = longitude;
                }
                if (latitude > top) {
                    top = latitude;
                }
                if (!(latitude < bottom)) continue;
                bottom = latitude;
            }
            bbox2 = left.toString() + "," + bottom.toString() + "," + right.toString() + "," + top.toString();
        }
        catch (Exception ex) {
            System.out.println("Failed to create bounding rectangle in MultiPointHandler.getBoundingRect");
        }
        return bbox2;
    }

    private static Rectangle2D.Double getControlPoint(String controlPoints, String bbox) {
        Rectangle2D.Double rect = null;
        try {
            String bbox2 = MultiPointHandler.getBoundingRectangle(controlPoints, bbox);
            String[] bounds2 = bbox2.split(",");
            double left = Double.valueOf(bounds2[0]);
            double right = Double.valueOf(bounds2[2]);
            double top = Double.valueOf(bounds2[3]);
            double bottom = Double.valueOf(bounds2[1]);
            double width = Math.abs(right - left);
            double height = Math.abs(top - bottom);
            rect = new Rectangle2D.Double(left, top, width, height);
        }
        catch (Exception ex) {
            System.out.println("Failed to create control point in MultiPointHandler.getControlPoint");
        }
        return rect;
    }

    private static Point2D getControlPoint(ArrayList<Point2D.Double> geoCoords) {
        Point2D.Double pt2d = null;
        try {
            double left = Double.MAX_VALUE;
            double right = -1.7976931348623157E308;
            double top = -1.7976931348623157E308;
            double bottom = Double.MAX_VALUE;
            Point2D ptTemp = null;
            for (int j = 0; j < geoCoords.size(); ++j) {
                ptTemp = geoCoords.get(j);
                if (ptTemp.getX() < left) {
                    left = ptTemp.getX();
                }
                if (ptTemp.getX() > right) {
                    right = ptTemp.getX();
                }
                if (ptTemp.getY() > top) {
                    top = ptTemp.getY();
                }
                if (!(ptTemp.getY() < bottom)) continue;
                bottom = ptTemp.getY();
            }
            pt2d = new Point2D.Double(left, top);
        }
        catch (Exception ex) {
            System.out.println("Failed to create control point in MultiPointHandler.getControlPoint");
        }
        return pt2d;
    }

    private static Point2D getGeoUL(ArrayList<Point2D.Double> geoCoords) {
        Point2D.Double ptGeo = null;
        try {
            int j = 0;
            Point2D pt = null;
            double left = geoCoords.get((int)0).x;
            double top = geoCoords.get((int)0).y;
            double right = geoCoords.get((int)0).x;
            double bottom = geoCoords.get((int)0).y;
            for (j = 1; j < geoCoords.size(); ++j) {
                pt = geoCoords.get(j);
                if (pt.getX() < left) {
                    left = pt.getX();
                }
                if (pt.getX() > right) {
                    right = pt.getX();
                }
                if (pt.getY() > top) {
                    top = pt.getY();
                }
                if (!(pt.getY() < bottom)) continue;
                bottom = pt.getY();
            }
            if (right - left > 180.0) {
                left = 180.0;
                for (j = 0; j < geoCoords.size(); ++j) {
                    pt = geoCoords.get(j);
                    if (!(pt.getX() > 0.0) || !(pt.getX() < left)) continue;
                    left = pt.getX();
                }
            }
            ptGeo = new Point2D.Double(left, top);
        }
        catch (Exception ex) {
            System.out.println("Failed to create control point in MultiPointHandler.getControlPoint");
        }
        return ptGeo;
    }

    private static String getBboxFromCoords(ArrayList<Point2D.Double> geoCoords) {
        String bbox = null;
        try {
            int j = 0;
            Point2D pt = null;
            double left = geoCoords.get((int)0).x;
            double top = geoCoords.get((int)0).y;
            double right = geoCoords.get((int)0).x;
            double bottom = geoCoords.get((int)0).y;
            for (j = 1; j < geoCoords.size(); ++j) {
                pt = geoCoords.get(j);
                if (pt.getX() < left) {
                    left = pt.getX();
                }
                if (pt.getX() > right) {
                    right = pt.getX();
                }
                if (pt.getY() > top) {
                    top = pt.getY();
                }
                if (!(pt.getY() < bottom)) continue;
                bottom = pt.getY();
            }
            if (right - left > 180.0) {
                left = 180.0;
                right = -180.0;
                for (j = 0; j < geoCoords.size(); ++j) {
                    pt = geoCoords.get(j);
                    if (pt.getX() > 0.0 && pt.getX() < left) {
                        left = pt.getX();
                    }
                    if (!(pt.getX() < 0.0) || !(pt.getX() > right)) continue;
                    right = pt.getX();
                }
            }
            bbox = Double.toString(left) + "," + Double.toString(bottom) + "," + Double.toString(right) + "," + Double.toString(top);
        }
        catch (Exception ex) {
            System.out.println("Failed to create control point in MultiPointHandler.getBboxFromCoords");
        }
        return bbox;
    }

    private static boolean crossesIDL(ArrayList<Point2D.Double> geoCoords) {
        boolean result = false;
        Point2D pt2d = MultiPointHandler.getControlPoint(geoCoords);
        double left = pt2d.getX();
        Point2D ptTemp = null;
        for (int j = 0; j < geoCoords.size(); ++j) {
            ptTemp = geoCoords.get(j);
            if (!(Math.abs(ptTemp.getX() - left) > 180.0)) continue;
            return true;
        }
        return result;
    }

    public static Boolean ShouldClipSymbol(String symbolID) {
        String affiliation = SymbolUtilities.getStatus((String)symbolID);
        if (symbolID.substring(0, 1).equals("G") && affiliation.equals("A")) {
            return true;
        }
        if (SymbolUtilities.isWeather((String)symbolID)) {
            return true;
        }
        String id = SymbolUtilities.getBasicSymbolID((String)symbolID);
        if (id.equals("G*T*F-----****X") || id.equals("G*F*LCC---****X") || id.equals("G*G*GLB---****X") || id.equals("G*G*GLF---****X") || id.equals("G*G*GLC---****X") || id.equals("G*G*GAF---****X") || id.equals("G*G*AAW---****X") || id.equals("G*G*DABP--****X") || id.equals("G*G*OLP---****X") || id.equals("G*G*PY----****X") || id.equals("G*G*PM----****X") || id.equals("G*G*ALL---****X") || id.equals("G*G*ALU---****X") || id.equals("G*G*ALM---****X") || id.equals("G*G*ALC---****X") || id.equals("G*G*ALS---****X") || id.equals("G*G*SLB---****X") || id.equals("G*G*SLH---****X") || id.equals("G*G*GAY---****X") || id.equals("G*M*OFA---****X") || id.equals("G*M*OGB---****X") || id.equals("G*M*OGL---****X") || id.equals("G*M*OGZ---****X") || id.equals("G*M*OGF---****X") || id.equals("G*M*OGR---****X") || id.equals("G*M*OADU--****X") || id.equals("G*M*OADC--****X") || id.equals("G*M*OAR---****X") || id.equals("G*M*OAW---****X") || id.equals("G*M*OEF---****X") || id.equals("G*M*OMC---****X") || id.equals("G*M*OWU---****X") || id.equals("G*M*OWS---****X") || id.equals("G*M*OWD---****X") || id.equals("G*M*OWA---****X") || id.equals("G*M*OWL---****X") || id.equals("G*M*OWH---****X") || id.equals("G*M*OWCS--****X") || id.equals("G*M*OWCD--****X") || id.equals("G*M*OWCT--****X") || id.equals("G*M*OHO---****X") || id.equals("G*M*BDD---****X") || id.equals("G*M*BCD---****X") || id.equals("G*M*BCE---****X") || id.equals("G*M*SL----****X") || id.equals("G*M*SP----****X") || id.equals("G*M*NR----****X") || id.equals("G*M*NB----****X") || id.equals("G*M*NC----****X") || id.equals("G*F*ACNI--****X") || id.equals("G*F*ACNR--****X") || id.equals("G*F*ACNC--****X") || id.equals("G*F*AKBC--****X") || id.equals("G*F*AKBI--****X") || id.equals("G*F*AKBR--****X") || id.equals("G*F*AKPC--****X") || id.equals("G*F*AKPI--****X") || id.equals("G*F*AKPR--****X") || id.equals("G*F*LT----****X") || id.equals("G*F*LTS---****X") || id.equals("G*G*SAE---****X") || id.equals("G*S*LRA---****X") || id.equals("G*S*LRM---****X") || id.equals("G*S*LRO---****X") || id.equals("G*S*LRT---****X") || id.equals("G*S*LRW---****X") || id.equals("G*T*Q-----****X") || id.equals("G*T*E-----****X") || id.equals("G*T*F-----****X") || id.equals("G*T*K-----****X") || id.equals("G*T*KF----****X") || id.equals("G*G*PA----****X") || id.equals("G*M*ORP---****X") || id.equals("G*M*ORS---****X") || id.equals("G*T*A-----****X")) {
            return true;
        }
        return false;
    }

    private static double getReasonableScale(String bbox, double origScale) {
        double scale = origScale;
        try {
            String[] bounds = bbox.split(",");
            double left = Double.valueOf(bounds[0]);
            double right = Double.valueOf(bounds[2]);
            double top = Double.valueOf(bounds[3]);
            double bottom = Double.valueOf(bounds[1]);
            if (left == -180.0 && right == 180.0) {
                return 7.573E7;
            }
            if (left == 180.0 && right == -180.0) {
                return 7.573E7;
            }
            POINT2 ul = new POINT2(left, top);
            POINT2 ur = new POINT2(right, top);
            POINT2 lr = new POINT2(right, bottom);
            double widthInMeters = mdlGeodesic.geodesic_distance((POINT2)ul, (POINT2)lr, null, null);
            double maxWidthInPixels = 1000.0;
            double minScale = maxWidthInPixels / widthInMeters * 0.010416666666666666 * 0.025400050800101603;
            if (origScale < (minScale = 1.0 / minScale)) {
                return minScale;
            }
            double minWidthInPixels = 100.0;
            double maxScale = minWidthInPixels / widthInMeters * 0.010416666666666666 * 0.025400050800101603;
            if (origScale > (maxScale = 1.0 / maxScale)) {
                return maxScale;
            }
        }
        catch (Exception exc) {
            String st = JavaRendererUtilities.getStackTrace(exc);
            ErrorLogger.LogException((String)"MultiPointHandler", (String)"getReasonableScale", (Exception)exc);
        }
        return scale;
    }

    public static String RenderSymbol(String id, String name, String description, String symbolCode, String controlPoints, Double scale, String bbox, String symbolModifiers, int format) {
        return MultiPointHandler.RenderSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, symbolModifiers, format, RendererSettings.getInstance().getSymbologyStandard());
    }

    public static String RenderSymbol(String id, String name, String description, String symbolCode, String controlPoints, Double scale, String bbox, String symbolModifiers, int format, int symStd) {
        boolean debug = false;
        if (debug) {
            System.out.println("MultiPointHander.RenderSymbol()");
            System.out.println("NAME: " + name);
            System.out.println("DESCRIPTION: " + description);
            System.out.println("SYMBOLID: " + symbolCode);
            System.out.println("POINTS: " + controlPoints);
            System.out.println("SCALE: " + String.valueOf(scale));
            System.out.println("BBOX: " + bbox);
            System.out.println("MODIFIERS: " + symbolModifiers);
            System.out.println("FORMAT: " + String.valueOf(format));
            System.out.println("SYMSTD: " + String.valueOf(symStd));
        }
        boolean normalize = true;
        Double controlLat = 0.0;
        Double controlLong = 0.0;
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = null;
        Rectangle rect = null;
        ArrayList tgPoints = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList shapes = new ArrayList();
        ArrayList modifiers = new ArrayList();
        ArrayList<Point2D.Double> geoCoords = new ArrayList<Point2D.Double>();
        int len = coordinates.length;
        Object coordsUL = null;
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            if (coordPair.length < 2) continue;
            Double latitude = Double.valueOf(coordPair[1].trim());
            Double longitude = Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        Point2D ptGeoUL = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        int j = 0;
        ArrayList<Point2D.Double> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            double dist;
            String[] bounds = null;
            if (bbox.contains(" ")) {
                String[] coords;
                bboxCoords = new ArrayList<Point2D.Double>();
                double x = 0.0;
                double y = 0.0;
                for (String coord : coords = bbox.split(" ")) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                String bbox2 = MultiPointHandler.getBboxFromCoords(bboxCoords);
                scale = MultiPointHandler.getReasonableScale(bbox2, scale);
                ipc = new PointConverter(left, top, scale);
                Point2D ptPixels = null;
                Point2D ptGeo = null;
                for (j = 0; j < bboxCoords.size(); ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipc.GeoToPixels(ptGeo);
                    x = ptPixels.getX();
                    y = ptPixels.getY();
                    if (x < 20.0) {
                        x = 20.0;
                    }
                    if (y < 20.0) {
                        y = 20.0;
                    }
                    ptPixels.setLocation(x, y);
                    bboxCoords.set(j, (Point2D.Double)ptPixels);
                }
            } else {
                bounds = bbox.split(",");
                left = (double)Double.valueOf(bounds[0]);
                right = (double)Double.valueOf(bounds[2]);
                top = (double)Double.valueOf(bounds[3]);
                bottom = (double)Double.valueOf(bounds[1]);
                scale = MultiPointHandler.getReasonableScale(bbox, scale);
                ipc = new PointConverter(left, top, scale);
            }
            if (Math.abs(left - right) < 5.562684646268003E-309) {
                dist = 0.26458386250105836 * scale;
                POINT2 ptLeft = new POINT2(left.doubleValue(), top.doubleValue());
                POINT2 ptRight = mdlGeodesic.geodesic_coordinate((POINT2)ptLeft, (double)dist, (double)90.0);
                right = ptRight.x;
                if (right > 180.0) {
                    right = right - 360.0;
                } else if (right < -180.0) {
                    right = right + 360.0;
                }
            }
            if (Math.abs(top - bottom) < 5.562684646268003E-309) {
                dist = 0.26458386250105836 * scale;
                POINT2 ptTop = new POINT2(left.doubleValue(), top.doubleValue());
                POINT2 ptBottom = mdlGeodesic.geodesic_coordinate((POINT2)ptTop, (double)dist, (double)180.0);
                bottom = ptBottom.y;
            }
            Point2D.Double lt = new Point2D.Double(left, top);
            Point2D.Double rb = new Point2D.Double(right, bottom);
            if (bboxCoords == null) {
                temp = ipc.GeoToPixels(lt);
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                temp = ipc.GeoToPixels(rb);
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = width == 0 || height == 0 ? null : new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        ArrayList<Point2D.Double> geoCoords2 = new ArrayList<Point2D.Double>();
        geoCoords2.add(new Point2D.Double(left, top));
        geoCoords2.add(new Point2D.Double(right, bottom));
        if (!MultiPointHandler.ShouldClipSymbol(symbolCode).booleanValue() && !MultiPointHandler.crossesIDL(geoCoords)) {
            rect = null;
            bboxCoords = null;
        }
        tgl.set_SymbolId(symbolCode);
        tgl.set_Pixels(null);
        try {
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            mSymbol.setUseDashArray(false);
            mSymbol.setSymbologyStandard(symStd);
            if (symbolModifiers != null && !symbolModifiers.equals("")) {
                MultiPointHandler.populateModifiers(symbolModifiers, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            String symbolIsValid = MultiPointHandler.canRenderMultiPoint(mSymbol);
            if (!symbolIsValid.equals("true")) {
                String ErrorOutput = "";
                ErrorOutput = ErrorOutput + "{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ";
                ErrorOutput = ErrorOutput + symbolIsValid + " - ";
                ErrorOutput = ErrorOutput + "\"}";
                return ErrorOutput;
            }
            if (mSymbol.getModifierMap().containsKey(SYMBOL_FILL_IDS) || mSymbol.getModifierMap().containsKey(SYMBOL_LINE_IDS)) {
                tgl = clsRenderer.createTGLightFromMilStdSymbol((MilStdSymbol)mSymbol, (IPointConversion)ipc);
                if (rect != null) {
                    Rectangle2D.Double rect2d = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
                    clsClipPolygon2.ClipPolygon((TGLight)tgl, (Rectangle2D)rect2d);
                }
                tgPoints = tgl.get_Pixels();
            }
            MultiPointRenderer mpr = MultiPointRenderer.getInstance();
            boolean isBasicShape = false;
            isBasicShape = bboxCoords == null ? MultiPointHandler.getBasicShapes(mSymbol, rect, ipc, symStd) : MultiPointHandler.getBasicShapes(mSymbol, bboxCoords, ipc, symStd);
            if (!isBasicShape) {
                if (bboxCoords == null) {
                    mpr.renderWithPolylines(mSymbol, (IPointConversion)ipc, rect);
                } else {
                    mpr.renderWithPolylines(mSymbol, (IPointConversion)ipc, bboxCoords);
                }
            }
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            if (format == 1) {
                jsonOutput.append("{\"type\":\"symbol\",");
                jsonContent = MultiPointHandler.JSONize(shapes, modifiers, ipc, normalize);
                jsonOutput.append(jsonContent);
                jsonOutput.append("}");
            } else if (format == 0) {
                String fillKML;
                String hexColor;
                Color textColor = null;
                textColor = mSymbol.getTextColor();
                if (textColor == null) {
                    textColor = mSymbol.getLineColor();
                }
                if ((hexColor = SymbolUtilities.colorToHexString((Color)textColor, (Boolean)true)).equals("#FF000000")) {
                    textColor = Color.white;
                }
                jsonContent = MultiPointHandler.KMLize(id, name, description, symbolCode, shapes, modifiers, ipc, normalize, textColor);
                jsonOutput.append(jsonContent);
                if ((mSymbol.getModifierMap().containsKey(SYMBOL_FILL_IDS) || mSymbol.getModifierMap().containsKey(SYMBOL_LINE_IDS)) && (fillKML = MultiPointHandler.AddImageFillToKML(tgPoints, jsonContent, mSymbol, ipc, normalize)) != null && !fillKML.isEmpty()) {
                    jsonOutput.append(fillKML);
                }
            } else if (format == 2) {
                jsonOutput.append("{\"type\":\"FeatureCollection\",\"features\":");
                jsonContent = MultiPointHandler.GeoJSONize(shapes, modifiers, ipc, normalize, mSymbol.getTextColor(), mSymbol.getTextBackgroundColor());
                jsonOutput.append(jsonContent);
                jsonOutput.append(",\"properties\":{\"id\":\"");
                jsonOutput.append(id);
                jsonOutput.append("\",\"name\":\"");
                jsonOutput.append(name);
                jsonOutput.append("\",\"description\":\"");
                jsonOutput.append(description);
                jsonOutput.append("\",\"symbolID\":\"");
                jsonOutput.append(symbolCode);
                jsonOutput.append("\",\"wasClipped\":\"");
                jsonOutput.append(String.valueOf(mSymbol.get_WasClipped()));
                jsonOutput.append("\"}}");
            }
        }
        catch (Exception exc) {
            String st = JavaRendererUtilities.getStackTrace(exc);
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append(st);
            jsonOutput.append("\"}");
        }
        debug = false;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        return jsonOutput.toString();
    }

    private static String AddImageFillToKML(ArrayList<POINT2> tgPoints, String jsonContent, MilStdSymbol mSymbol, IPointConversion ipc, Boolean normalize) {
        if (tgPoints == null || tgPoints.size() == 0) {
            return null;
        }
        ArrayList<Point2D> pixelPoints = new ArrayList<Point2D>();
        Path2D.Double path = new Path2D.Double();
        int kcount = tgPoints.size();
        POINT2 tpTemp = null;
        for (int k = 0; k < kcount; ++k) {
            tpTemp = tgPoints.get(k);
            pixelPoints.add(new Point2D.Double(tpTemp.x, tpTemp.y));
            if (k > 0) {
                ((Path2D)path).lineTo(tpTemp.x, tpTemp.y);
                continue;
            }
            ((Path2D)path).moveTo(tpTemp.x, tpTemp.y);
        }
        Rectangle rect = path.getBounds();
        String goImageUrl = SECWebRenderer.GenerateSymbolLineFillUrl(mSymbol.getModifierMap(), pixelPoints, rect);
        String goKML = MultiPointHandler.GenerateGroundOverlayKML(goImageUrl, ipc, rect, normalize);
        goKML = goKML + "</Folder>";
        jsonContent = jsonContent.replace("</Folder>", goKML);
        return jsonContent;
    }

    public static PNGInfo GenerateImageFillPNGInfo(ArrayList<POINT2> tgPoints, String jsonContent, MilStdSymbol mSymbol, IPointConversion ipc, Boolean normalize) {
        ArrayList<Point2D> pixelPoints = new ArrayList<Point2D>();
        Path2D.Double path = new Path2D.Double();
        int kcount = tgPoints.size();
        POINT2 tpTemp = null;
        for (int k = 0; k < kcount; ++k) {
            tpTemp = tgPoints.get(k);
            pixelPoints.add(new Point2D.Double(tpTemp.x, tpTemp.y));
            if (k > 0) {
                ((Path2D)path).lineTo(tpTemp.x, tpTemp.y);
                continue;
            }
            ((Path2D)path).moveTo(tpTemp.x, tpTemp.y);
        }
        Rectangle rect = path.getBounds();
        double centerX = rect.getCenterX();
        double centerY = rect.getCenterY();
        String goImageUrl = SECWebRenderer.GenerateSymbolLineFillUrl(mSymbol.getModifierMap(), pixelPoints, rect);
        Map<String, String> params = SinglePointRendererService.getInstance().processParams(goImageUrl);
        ISinglePointInfo spi = SinglePointRendererService.getInstance().render(params.get("RENDERER"), "AREASYMBOLFILL", params);
        PNGInfo pi = new PNGInfo(spi);
        Point2D topLeft = null;
        Point2D bottomRight = null;
        Rectangle2D bounds = path.getBounds2D();
        double imageSize = 0.0;
        imageSize = params.containsKey("SYMBOLFILLICONSIZE") ? Double.valueOf(params.get("SYMBOLFILLICONSIZE")) : 25.0;
        double imageOffset = 0.0;
        if (params.containsKey("SYMBOLLINEIDS")) {
            imageOffset = imageSize / 2.0 + 3.0;
        }
        double height = bounds.getHeight() + imageOffset * 2.0;
        double width = bounds.getWidth() + imageOffset * 2.0;
        double x = bounds.getX() - imageOffset;
        double y = bounds.getY() - imageOffset;
        Point2D.Double coord = new Point2D.Double(x, y);
        topLeft = ipc.PixelsToGeo((Point2D)coord);
        coord = new Point2D.Double(x + width, y + height);
        bottomRight = ipc.PixelsToGeo((Point2D)coord);
        if (normalize.booleanValue()) {
            topLeft = MultiPointHandler.NormalizeCoordToGECoord(topLeft);
            bottomRight = MultiPointHandler.NormalizeCoordToGECoord(bottomRight);
        }
        pi = new PNGInfo(spi.getImage(), topLeft, new Rectangle2D.Double(topLeft.getX(), topLeft.getY(), bottomRight.getX(), bottomRight.getY()));
        return pi;
    }

    private static boolean getBasicShapes(MilStdSymbol milStd, Object clipArea, IPointConversion ipc, int symStd) {
        int linetype = CELineArray.CGetLinetypeFromString((String)milStd.getSymbolID(), (int)symStd);
        ArrayList AM = null;
        ArrayList<Double> AN = null;
        double buffer = 0.0;
        double r = 0.0;
        boolean result = false;
        switch (linetype) {
            case 13000002: {
                AM = milStd.getModifiers_AM_AN_X("AM");
                AN = milStd.getModifiers_AM_AN_X("AN");
                if (AM.size() == 1) {
                    r = (Double)AM.get(0);
                    AM.add(r);
                    buffer = 0.0;
                    AM.add(buffer);
                } else if (AM.size() == 2) {
                    r = (Double)AM.get(0);
                    buffer = (Double)AM.get(1);
                    AM.set(1, r);
                    AM.add(buffer);
                } else if (AM.size() == 3) {
                    r = (Double)AM.get(0);
                    AM.set(1, r);
                }
                result = true;
                break;
            }
            case 13000000: 
            case 13000001: {
                AM = milStd.getModifiers_AM_AN_X("AM");
                AN = milStd.getModifiers_AM_AN_X("AN");
                if (AM.size() == 1) {
                    r = (Double)AM.get(0);
                    AM.add(r);
                    buffer = 0.0;
                    AM.add(buffer);
                }
                if (AM.size() == 2) {
                    AM.add(0.0);
                }
                result = true;
                break;
            }
            default: {
                return false;
            }
        }
        if (AN == null) {
            AN = new ArrayList<Double>();
        }
        if (AN.isEmpty()) {
            AN.add(new Double(0.0));
        }
        ArrayList coords = milStd.getCoordinates();
        double pivotX = ((Point2D.Double)coords.get((int)0)).x;
        double pivotY = ((Point2D.Double)coords.get((int)0)).y;
        double semiMajor = (Double)AM.get(0);
        double semiMinor = (Double)AM.get(1);
        double rotation = (Double)AN.get(0);
        buffer = (Double)AM.get(2);
        String strAltitudeMode = milStd.getAltitudeMode();
        if (strAltitudeMode.isEmpty()) {
            strAltitudeMode = "clampToGround";
        }
        KmlOptions.AltitudeMode altitudeMode = KmlOptions.AltitudeMode.fromString(strAltitudeMode);
        ArrayList<GeoPoint> geoPts = XsltCoordinateWrapper.getEllipsePoints(pivotX, pivotY, altitudeMode, semiMajor + buffer, semiMinor + buffer, 0.0, 0.0, rotation);
        ArrayList<Point2D.Double> coordinates = new ArrayList<Point2D.Double>();
        double x = 0.0;
        double y = 0.0;
        for (int j = 0; j < geoPts.size(); ++j) {
            x = geoPts.get((int)j).x;
            y = geoPts.get((int)j).y;
            coordinates.add(new Point2D.Double(x, y));
        }
        milStd.setCoordinates(coordinates);
        clsRenderer.render_Shape((MilStdSymbol)milStd, (IPointConversion)ipc, (Object)clipArea, (int)ShapeInfo.SHAPE_TYPE_FILL, null, (Color)milStd.getFillColor(), (int)0);
        ArrayList<GeoPoint> geoPts2 = XsltCoordinateWrapper.getEllipsePoints(pivotX, pivotY, altitudeMode, semiMajor, semiMinor, 0.0, 0.0, rotation);
        ArrayList<Point2D.Double> coordinates2 = new ArrayList<Point2D.Double>();
        for (int j = 0; j < geoPts2.size(); ++j) {
            x = geoPts2.get((int)j).x;
            y = geoPts2.get((int)j).y;
            coordinates2.add(new Point2D.Double(x, y));
        }
        milStd.setCoordinates(coordinates2);
        clsRenderer.render_Shape((MilStdSymbol)milStd, (IPointConversion)ipc, (Object)clipArea, (int)ShapeInfo.SHAPE_TYPE_POLYLINE, (Color)milStd.getLineColor(), null, (int)milStd.getPatternFillType());
        milStd.setModifierShapes(new ArrayList());
        return result;
    }

    public static MilStdSymbol RenderSymbolAsMilStdSymbol(String id, String name, String description, String symbolCode, String controlPoints, Double scale, String bbox, String symbolModifiers, int symStd) {
        MilStdSymbol mSymbol = null;
        boolean normalize = true;
        Double controlLat = 0.0;
        Double controlLong = 0.0;
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Rectangle rect = null;
        ArrayList tgPoints = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList shapes = new ArrayList();
        ArrayList modifiers = new ArrayList();
        ArrayList<Point2D.Double> geoCoords = new ArrayList<Point2D.Double>();
        int len = coordinates.length;
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        Point2D ptGeoUL = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        int j = 0;
        ArrayList<Point2D.Double> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            double dist;
            String[] bounds = null;
            if (bbox.contains(" ")) {
                String[] coords;
                bboxCoords = new ArrayList<Point2D.Double>();
                double x = 0.0;
                double y = 0.0;
                for (String coord : coords = bbox.split(" ")) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                ipc = new PointConverter(left, top, scale);
                Iterator ptPixels = null;
                Point2D ptGeo = null;
                for (j = 0; j < bboxCoords.size(); ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipc.GeoToPixels(ptGeo);
                    x = ((Point2D)((Object)ptPixels)).getX();
                    y = ((Point2D)((Object)ptPixels)).getY();
                    if (x < 20.0) {
                        x = 20.0;
                    }
                    if (y < 20.0) {
                        y = 20.0;
                    }
                    ((Point2D)((Object)ptPixels)).setLocation(x, y);
                    bboxCoords.set(j, (Point2D.Double)((Object)ptPixels));
                }
            } else {
                bounds = bbox.split(",");
                left = (double)Double.valueOf(bounds[0]);
                right = (double)Double.valueOf(bounds[2]);
                top = (double)Double.valueOf(bounds[3]);
                bottom = (double)Double.valueOf(bounds[1]);
                scale = MultiPointHandler.getReasonableScale(bbox, scale);
                ipc = new PointConverter(left, top, scale);
            }
            if (Math.abs(left - right) < 5.562684646268003E-309) {
                dist = 0.26458386250105836 * scale;
                POINT2 ptLeft = new POINT2(left.doubleValue(), top.doubleValue());
                POINT2 ptRight = mdlGeodesic.geodesic_coordinate((POINT2)ptLeft, (double)dist, (double)90.0);
                right = ptRight.x;
                if (right > 180.0) {
                    right = right - 360.0;
                } else if (right < -180.0) {
                    right = right + 360.0;
                }
            }
            if (Math.abs(top - bottom) < 5.562684646268003E-309) {
                dist = 0.26458386250105836 * scale;
                POINT2 ptTop = new POINT2(left.doubleValue(), top.doubleValue());
                POINT2 ptBottom = mdlGeodesic.geodesic_coordinate((POINT2)ptTop, (double)dist, (double)180.0);
                bottom = ptBottom.y;
            }
            Point2D.Double lt = new Point2D.Double(left, top);
            Point2D.Double rb = new Point2D.Double(right, bottom);
            if (bboxCoords == null) {
                temp = ipc.GeoToPixels(lt);
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                temp = ipc.GeoToPixels(rb);
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = width == 0 || height == 0 ? null : new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            if (coordPair.length < 2) continue;
            Double latitude = Double.valueOf(coordPair[1].trim());
            Double longitude = Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        ArrayList<Point2D.Double> geoCoords2 = new ArrayList<Point2D.Double>();
        geoCoords2.add(new Point2D.Double(left, top));
        geoCoords2.add(new Point2D.Double(right, bottom));
        if (!MultiPointHandler.ShouldClipSymbol(symbolCode).booleanValue() && !MultiPointHandler.crossesIDL(geoCoords)) {
            rect = null;
            bboxCoords = null;
        }
        tgl.set_SymbolId(symbolCode);
        tgl.set_Pixels(null);
        try {
            String fillColor = null;
            mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            mSymbol.setUseDashArray(true);
            mSymbol.setSymbologyStandard(symStd);
            if (symbolModifiers != null && !symbolModifiers.equals("")) {
                MultiPointHandler.populateModifiers(symbolModifiers, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            if (mSymbol.getFillColor() != null) {
                Color fc = mSymbol.getFillColor();
                fillColor = Integer.toHexString(fc.getRGB());
            }
            if (mSymbol.getModifierMap().containsKey(SYMBOL_FILL_IDS) || mSymbol.getModifierMap().containsKey(SYMBOL_LINE_IDS)) {
                tgl = clsRenderer.createTGLightFromMilStdSymbol((MilStdSymbol)mSymbol, (IPointConversion)ipc);
                if (rect != null) {
                    Rectangle2D.Double rect2d = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
                    clsClipPolygon2.ClipPolygon((TGLight)tgl, (Rectangle2D)rect2d);
                }
                tgPoints = tgl.get_Pixels();
            }
            MultiPointRenderer mpr = MultiPointRenderer.getInstance();
            boolean isBasicShape = false;
            isBasicShape = bboxCoords == null ? MultiPointHandler.getBasicShapes(mSymbol, rect, ipc, symStd) : MultiPointHandler.getBasicShapes(mSymbol, bboxCoords, ipc, symStd);
            if (!isBasicShape) {
                if (bboxCoords == null) {
                    mpr.renderWithPolylines(mSymbol, (IPointConversion)ipc, rect);
                } else {
                    mpr.renderWithPolylines(mSymbol, (IPointConversion)ipc, bboxCoords);
                }
            }
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            ArrayList polylines = null;
            ArrayList<ArrayList<Point2D>> newPolylines = null;
            Object newLine = null;
            for (ShapeInfo shape : shapes) {
                polylines = shape.getPolylines();
                newPolylines = MultiPointHandler.ConvertPolylinePixelsToCoords(polylines, ipc, normalize);
                shape.setPolylines(newPolylines);
            }
            for (ShapeInfo label : modifiers) {
                Point2D pixelCoord = label.getModifierStringPosition();
                if (pixelCoord == null) {
                    pixelCoord = label.getGlyphPosition();
                }
                Point2D geoCoord = ipc.PixelsToGeo(pixelCoord);
                if (normalize) {
                    geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                }
                double latitude = geoCoord.getY();
                double longitude = geoCoord.getX();
                label.setModifierStringPosition((Point2D)new Point2D.Double(longitude, latitude));
            }
            mSymbol.setModifierShapes(modifiers);
            mSymbol.setSymbolShapes(shapes);
            if (mSymbol.getModifierMap().containsKey(SYMBOL_FILL_IDS) || mSymbol.getModifierMap().containsKey(SYMBOL_LINE_IDS)) {
                PNGInfo pi = MultiPointHandler.GenerateImageFillPNGInfo(tgPoints, jsonContent, mSymbol, ipc, normalize);
                Object bounds = null;
                mSymbol.setTag((Object)pi);
            }
        }
        catch (Exception exc) {
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append("\"}");
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        return mSymbol;
    }

    private static ArrayList<ArrayList<Point2D>> ConvertPolylinePixelsToCoords(ArrayList<ArrayList<Point2D>> polylines, IPointConversion ipc, Boolean normalize) {
        ArrayList<ArrayList<Point2D>> newPolylines = new ArrayList<ArrayList<Point2D>>();
        double latitude = 0.0;
        double longitude = 0.0;
        ArrayList<Point2D.Double> newLine = null;
        try {
            for (ArrayList<Point2D> line : polylines) {
                newLine = new ArrayList<Point2D.Double>();
                for (Point2D pt : line) {
                    Point2D geoCoord = ipc.PixelsToGeo(pt);
                    if (normalize.booleanValue()) {
                        geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                    }
                    latitude = geoCoord.getY();
                    longitude = geoCoord.getX();
                    newLine.add(new Point2D.Double(longitude, latitude));
                }
                newPolylines.add(newLine);
            }
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        return newPolylines;
    }

    public static String RenderSymbol2D(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, String symbolModifiers, int format) {
        return MultiPointHandler.RenderSymbol2D(id, name, description, symbolCode, controlPoints, pixelWidth, pixelHeight, bbox, symbolModifiers, format, RendererSettings.getInstance().getSymbologyStandard());
    }

    public static String RenderSymbol2D(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, String symbolModifiers, int format, int symStd) {
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Rectangle rect = null;
        ArrayList tgPoints = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList shapes = new ArrayList();
        ArrayList modifiers = new ArrayList();
        ArrayList<Point2D.Double> geoCoords = new ArrayList<Point2D.Double>();
        PointConversion ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        if (bbox == null || bbox.equals("")) {
            System.out.println("Bad bbox value: " + bbox);
            System.out.println("bbox is viewable area of the map.  Passed in the format of a string \"lowerLeftX,lowerLeftY,upperRightX,upperRightY.\" example: \"-50.4,23.6,-42.2,24.2\"");
            return "ERROR - Bad bbox value: " + bbox;
        }
        String[] bounds = bbox.split(",");
        left = (double)Double.valueOf(bounds[0]);
        right = (double)Double.valueOf(bounds[2]);
        top = (double)Double.valueOf(bounds[3]);
        bottom = (double)Double.valueOf(bounds[1]);
        ipc = new PointConversion(pixelWidth, pixelHeight, top.doubleValue(), left.doubleValue(), bottom.doubleValue(), right.doubleValue());
        int len = coordinates.length;
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            if (coordPair.length < 2) continue;
            Double latitude = Double.valueOf(coordPair[1].trim());
            Double longitude = Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        try {
            String symbolIsValid;
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            mSymbol.setUseDashArray(false);
            mSymbol.setSymbologyStandard(symStd);
            if (symbolModifiers != null && !symbolModifiers.equals("")) {
                MultiPointHandler.populateModifiers(symbolModifiers, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            Point2D temp = null;
            boolean normalize = true;
            if (MultiPointHandler.ShouldClipSymbol(symbolCode).booleanValue() || MultiPointHandler.crossesIDL(geoCoords)) {
                temp = ipc.GeoToPixels((Point2D)new Point2D.Double(left, top));
                int leftX = (int)temp.getX();
                int topY = (int)temp.getY();
                temp = ipc.GeoToPixels((Point2D)new Point2D.Double(right, bottom));
                int bottomY = (int)temp.getY();
                int rightX = (int)temp.getX();
                int width = Math.abs(rightX - leftX);
                int height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            }
            if (!(symbolIsValid = MultiPointHandler.canRenderMultiPoint(mSymbol)).equals("true")) {
                String ErrorOutput = "";
                ErrorOutput = ErrorOutput + "{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ";
                ErrorOutput = ErrorOutput + symbolIsValid + " - ";
                ErrorOutput = ErrorOutput + "\"}";
                return ErrorOutput;
            }
            if (mSymbol.getModifierMap().containsKey(SYMBOL_FILL_IDS) || mSymbol.getModifierMap().containsKey(SYMBOL_LINE_IDS)) {
                tgl = clsRenderer.createTGLightFromMilStdSymbol((MilStdSymbol)mSymbol, (IPointConversion)ipc);
                if (rect != null) {
                    Rectangle2D.Double rect2d = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
                    clsClipPolygon2.ClipPolygon((TGLight)tgl, (Rectangle2D)rect2d);
                }
                tgPoints = tgl.get_Pixels();
            }
            MultiPointRenderer mpr = MultiPointRenderer.getInstance();
            mpr.renderWithPolylines(mSymbol, (IPointConversion)ipc, rect);
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            if (format == 1) {
                jsonOutput.append("{\"type\":\"symbol\",");
                jsonContent = MultiPointHandler.JSONize(shapes, modifiers, (IPointConversion)ipc, normalize);
                jsonOutput.append(jsonContent);
                jsonOutput.append("}");
            } else if (format == 0) {
                String LookAtTag;
                String fillKML;
                String fillColor = null;
                if (mSymbol.getFillColor() != null) {
                    fillColor = Integer.toHexString(mSymbol.getFillColor().getRGB());
                }
                Color textColor = null;
                textColor = mSymbol.getTextColor();
                String hexColor = SymbolUtilities.colorToHexString((Color)textColor, (Boolean)true);
                if (hexColor.equals("#FF000000")) {
                    textColor = Color.white;
                }
                jsonContent = MultiPointHandler.KMLize(id, name, description, symbolCode, shapes, modifiers, (IPointConversion)ipc, normalize, textColor);
                jsonOutput.append(jsonContent);
                if ((mSymbol.getModifierMap().containsKey(SYMBOL_FILL_IDS) || mSymbol.getModifierMap().containsKey(SYMBOL_LINE_IDS)) && (fillKML = MultiPointHandler.AddImageFillToKML(tgPoints, jsonContent, mSymbol, (IPointConversion)ipc, normalize)) != null && !fillKML.isEmpty()) {
                    jsonOutput.append(fillKML);
                }
                if (mSymbol.getModifierMap().containsKey("LOOKAT") && ((String)mSymbol.getModifierMap().get("LOOKAT")).toLowerCase().equals("true") && (LookAtTag = JavaRendererUtilities.generateLookAtTag(geoCoords, mSymbol.getModifiers_AM_AN_X("X"))) != null && LookAtTag.endsWith("</LookAt>")) {
                    int idx = jsonContent.indexOf("<visibility>");
                    jsonContent = jsonContent.substring(0, idx) + LookAtTag + jsonContent.substring(idx);
                }
            } else if (format == 2) {
                jsonOutput.append("{\"type\":\"FeatureCollection\",\"features\":");
                jsonContent = MultiPointHandler.GeoJSONize(shapes, modifiers, (IPointConversion)ipc, normalize, mSymbol.getTextColor(), mSymbol.getTextBackgroundColor());
                jsonOutput.append(jsonContent);
                jsonOutput.append(",\"properties\":{\"id\":\"");
                jsonOutput.append(id);
                jsonOutput.append("\",\"name\":\"");
                jsonOutput.append(name);
                jsonOutput.append("\",\"description\":\"");
                jsonOutput.append(description);
                jsonOutput.append("\",\"symbolID\":\"");
                jsonOutput.append(symbolCode);
                jsonOutput.append("\",\"wasClipped\":\"");
                jsonOutput.append(String.valueOf(mSymbol.get_WasClipped()));
                jsonOutput.append("\"}}");
            }
        }
        catch (Exception exc) {
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append("\"}");
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        return jsonOutput.toString();
    }

    static String canRenderMultiPoint(MilStdSymbol symbol) {
        int symStd = symbol.getSymbologyStandard();
        String symbolID = symbol.getSymbolID();
        String basicID = SymbolUtilities.getBasicSymbolID((String)symbolID);
        SymbolDef sd = null;
        int dc = 99;
        int coordCount = symbol.getCoordinates().size();
        try {
            ArrayList AN;
            String message = "";
            if (SymbolDefTable.getInstance().HasSymbolDef(basicID, symStd).booleanValue()) {
                sd = SymbolDefTable.getInstance().getSymbolDef(basicID, symStd);
            }
            if (sd != null) {
                dc = sd.getDrawCategory();
                if (coordCount < sd.getMinPoints()) {
                    message = "symbolID: \"" + symbolID + "\" requires a minimum of " + String.valueOf(sd.getMinPoints()) + " points. " + String.valueOf(coordCount) + " are present.";
                    return message;
                }
            } else {
                if (symbolID.startsWith("BS_")) {
                    return "true";
                }
                if (symbolID.startsWith("BBS_")) {
                    ArrayList AM = symbol.getModifiers_AM_AN_X("AM");
                    if (AM != null && AM.size() > 0 && (Double)AM.get(0) >= 0.0) {
                        return "true";
                    }
                    return "false, Buffered Basic Shapes require a width (AM).";
                }
                if (symbolID.startsWith("PBS_")) {
                    ArrayList AM = symbol.getModifiers_AM_AN_X("AM");
                    if (symbolID.equals("PBS_CIRCLE-----") || symbolID.equals("PBS_SQUARE-----")) {
                        if (AM != null && AM.size() > 0 && coordCount > 0) {
                            return "true";
                        }
                        return "false: " + symbolID + ", requires a width (AM) and 1 control point";
                    }
                    if (symbolID.equals("PBS_ELLIPSE----") || symbolID.equals("PBS_RECTANGLE--")) {
                        if (AM != null && AM.size() > 1 && coordCount > 0) {
                            return "true";
                        }
                        return "false: " + symbolID + ", requires 2 AM values, length and width (AM) and 1 control point";
                    }
                    return "false: " + symbolID + ", not a recognized code for a parametered basic shape.";
                }
                return "symbolID: \"" + symbolID + "\" not recognized.";
            }
            ArrayList AM = symbol.getModifiers_AM_AN_X("AM");
            String result = MultiPointHandler.hasRequiredModifiers(symbolID, dc, AM, AN = symbol.getModifiers_AM_AN_X("AN"));
            if (!result.equals("true")) {
                return result;
            }
            return "true";
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"MultiPointHandler", (String)"canRenderMultiPoint", (Exception)exc);
            return "true";
        }
    }

    private static String hasRequiredModifiers(String symbolID, int dc, ArrayList<Double> AM, ArrayList<Double> AN) {
        String message = symbolID;
        try {
            if (dc >= 16 && dc <= 20) {
                if (dc == 16) {
                    if (AM != null && AM.size() > 0) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 1 distance/AM value.";
                    return message;
                }
                if (dc == 17) {
                    if (AM != null && AM.size() >= 2 && AN != null && AN.size() >= 1) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 2 distance/AM values and 1 azimuth/AN value.";
                    return message;
                }
                if (dc == 18) {
                    if (AM != null && AM.size() >= 2 && AN != null && AN.size() >= 2) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 2 distance/AM values and 2 azimuth/AN values per sector.  The first sector can have just one AM value although it is recommended to always use 2 values for each sector.";
                    return message;
                }
                if (dc == 19) {
                    if (AM != null && AM.size() > 0) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has at least 1 distance/AM value";
                    return message;
                }
                if (dc == 20) {
                    if (AM != null && AM.size() > 0) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 1 distance/AM value.";
                    return message;
                }
                return "true";
            }
            return "true";
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"MultiPointHandler", (String)"hasRequiredModifiers", (Exception)exc);
            return "true";
        }
    }

    public static String RenderSymbol2DX(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, String symbolModifiers, ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, int format) {
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Rectangle rect = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<Point2D.Double> geoCoords = new ArrayList<Point2D.Double>();
        PointConversion ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        if (bbox == null || bbox.equals("")) {
            System.out.println("Bad bbox value: " + bbox);
            System.out.println("bbox is viewable area of the map.  Passed in the format of a string \"lowerLeftX,lowerLeftY,upperRightX,upperRightY.\" example: \"-50.4,23.6,-42.2,24.2\"");
            return "ERROR - Bad bbox value: " + bbox;
        }
        String[] bounds = bbox.split(",");
        left = (double)Double.valueOf(bounds[0]);
        right = (double)Double.valueOf(bounds[2]);
        top = (double)Double.valueOf(bounds[3]);
        bottom = (double)Double.valueOf(bounds[1]);
        ipc = new PointConversion(pixelWidth, pixelHeight, top.doubleValue(), left.doubleValue(), bottom.doubleValue(), right.doubleValue());
        int len = coordinates.length;
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            if (coordPair.length < 2) continue;
            Double latitude = Double.valueOf(coordPair[1].trim());
            Double longitude = Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        try {
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            if (symbolModifiers != null && !symbolModifiers.equals("")) {
                MultiPointHandler.populateModifiers(symbolModifiers, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            MultiPointRenderer mpr = MultiPointRenderer.getInstance();
            mpr.renderWithPolylines(mSymbol, (IPointConversion)ipc, rect);
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            boolean normalize = false;
            if (format == 1) {
                jsonOutput.append("{\"type\":\"symbol\",");
                jsonContent = MultiPointHandler.JSONize(shapes, modifiers, (IPointConversion)ipc, normalize);
                jsonOutput.append(jsonContent);
                jsonOutput.append("}");
            } else if (format == 0) {
                String fillColor = null;
                if (mSymbol.getFillColor() != null) {
                    fillColor = Integer.toHexString(mSymbol.getFillColor().getRGB());
                }
                jsonContent = MultiPointHandler.KMLize(id, name, description, symbolCode, shapes, modifiers, (IPointConversion)ipc, normalize, mSymbol.getLineColor());
                jsonOutput.append(jsonContent);
            }
        }
        catch (Exception exc) {
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append("\"}");
        }
        boolean debug = true;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        return jsonOutput.toString();
    }

    public static SymbolInfo RenderSymbol3DWW(String symbolID, ArrayList<Point2D.Double> coordinates, Double scale, Point2D.Double bboxTL, Point2D.Double bboxBR, Map<String, String> modifiers, ArrayList<Double> X_Altitude, ArrayList<Double> AM_Distance, ArrayList<Double> AN_Azimuth) {
        try {
            MilStdSymbol symbol = new MilStdSymbol(symbolID, null, coordinates, modifiers);
            if (AM_Distance != null) {
                symbol.setModifiers_AM_AN_X("AM", AM_Distance);
            }
            if (AN_Azimuth != null) {
                symbol.setModifiers_AM_AN_X("AN", AN_Azimuth);
            }
            if (X_Altitude != null) {
                symbol.setModifiers_AM_AN_X("X", X_Altitude);
            }
            symbol = MultiPointHandler.RenderSymbol3DWW(symbol, scale, bboxTL, bboxBR);
            SymbolInfo si = MultiPointHandler.MilStdSymbolToSymbolInfo(symbol);
            return si;
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
            return null;
        }
    }

    public static MilStdSymbol RenderSymbol3DWW(MilStdSymbol symbol, Double scale, Point2D.Double bboxTL, Point2D.Double bboxBR) {
        try {
            boolean normalize = false;
            Double controlLat = 0.0;
            Double controlLong = 0.0;
            Rectangle rect = null;
            TGLight tgl = new TGLight();
            ArrayList shapes = new ArrayList();
            ArrayList modifiers = new ArrayList();
            ArrayList geoCoords = new ArrayList();
            String symbolCode = symbol.getSymbolID();
            PointConverter ipc = null;
            Double left = 0.0;
            Double right = 0.0;
            Double top = 0.0;
            Double bottom = 0.0;
            Point2D temp = null;
            int width = 0;
            int height = 0;
            int leftX = 0;
            int topY = 0;
            int bottomY = 0;
            int rightX = 0;
            if (bboxTL != null && bboxBR != null) {
                left = bboxTL.getX();
                right = bboxBR.getX();
                top = bboxTL.getY();
                bottom = bboxBR.getY();
                controlLong = left;
                controlLat = top;
                ipc = new PointConverter(controlLong, controlLat, scale);
                temp = ipc.GeoToPixels(new Point2D.Double(left, top));
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                temp = ipc.GeoToPixels(new Point2D.Double(right, bottom));
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            } else {
                rect = null;
            }
            geoCoords = symbol.getCoordinates();
            if (Math.abs(right - left) > 180.0) {
                normalize = true;
                ((PointConverter)ipc).set_normalize(true);
            } else {
                normalize = false;
                ((PointConverter)ipc).set_normalize(false);
            }
            if (normalize) {
                MultiPointHandler.NormalizeGECoordsToGEExtents(0.0, 360.0, geoCoords);
            }
            Point2D pt2d = MultiPointHandler.getControlPoint(geoCoords);
            controlLong = pt2d.getX();
            controlLat = pt2d.getY();
            ipc = new PointConverter(controlLong, controlLat, scale);
            ArrayList<Point2D.Double> geoCoords2 = new ArrayList<Point2D.Double>();
            geoCoords2.add(new Point2D.Double(left, top));
            geoCoords2.add(new Point2D.Double(right, bottom));
            if (normalize) {
                MultiPointHandler.NormalizeGECoordsToGEExtents(0.0, 360.0, geoCoords2);
            }
            if (rect != null) {
                left = geoCoords2.get(0).getX();
                top = geoCoords2.get(0).getY();
                right = geoCoords2.get(1).getX();
                bottom = geoCoords2.get(1).getY();
                temp = ipc.GeoToPixels(new Point2D.Double(left, top));
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                temp = ipc.GeoToPixels(new Point2D.Double(right, bottom));
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            }
            if (!MultiPointHandler.ShouldClipSymbol(symbolCode).booleanValue() && !MultiPointHandler.crossesIDL(geoCoords)) {
                rect = null;
            }
            tgl.set_SymbolId(symbolCode);
            tgl.set_Pixels(null);
            try {
                symbol.setCoordinates(geoCoords);
                MultiPointRenderer mpr = MultiPointRenderer.getInstance();
                mpr.renderWithPolylines(symbol, (IPointConversion)ipc, (Object)rect);
                shapes = symbol.getSymbolShapes();
                modifiers = symbol.getModifierShapes();
                MultiPointHandler.MakeWWReady(shapes, modifiers, ipc, normalize);
                symbol.setSymbolShapes(shapes);
                symbol.setModifierShapes(modifiers);
                return symbol;
            }
            catch (Exception exc) {
                System.err.println(exc.getMessage());
                exc.printStackTrace();
                boolean debug = false;
                if (debug) {
                    System.out.println("Symbol Code: " + symbolCode);
                    System.out.println("Scale: " + scale);
                }
            }
        }
        catch (Exception excf) {
            System.err.println(excf.getMessage());
            excf.printStackTrace();
        }
        return null;
    }

    private static SymbolInfo MilStdSymbolToSymbolInfo(MilStdSymbol symbol) {
        SymbolInfo si = null;
        ArrayList<TextInfo> tiList = new ArrayList<TextInfo>();
        ArrayList<LineInfo> liList = new ArrayList<LineInfo>();
        TextInfo tiTemp = null;
        LineInfo liTemp = null;
        ShapeInfo siTemp = null;
        ArrayList lines = symbol.getSymbolShapes();
        ArrayList modifiers = symbol.getModifierShapes();
        int lineCount = lines.size();
        int modifierCount = modifiers.size();
        for (int i = 0; i < lineCount; ++i) {
            siTemp = (ShapeInfo)lines.get(i);
            if (siTemp.getPolylines() == null) continue;
            liTemp = new LineInfo();
            liTemp.setFillColor(siTemp.getFillColor());
            liTemp.setLineColor(siTemp.getLineColor());
            liTemp.setPolylines(siTemp.getPolylines());
            liTemp.setStroke(siTemp.getStroke());
            liList.add(liTemp);
        }
        for (int j = 0; j < modifierCount; ++j) {
            tiTemp = new TextInfo();
            siTemp = (ShapeInfo)modifiers.get(j);
            if (siTemp.getModifierString() == null) continue;
            tiTemp.setModifierString(siTemp.getModifierString());
            tiTemp.setModifierStringPosition(siTemp.getModifierStringPosition());
            tiTemp.setModifierStringAngle(siTemp.getModifierStringAngle());
            tiList.add(tiTemp);
        }
        si = new SymbolInfo(tiList, liList);
        return si;
    }

    private static boolean populateModifiers(String jsonString, MilStdSymbol symbol) {
        HashMap<String, String> modifierMap = new HashMap<String, String>();
        ArrayList<Double> altitudes = null;
        ArrayList<Double> azimuths = null;
        ArrayList<Double> distances = null;
        String fillColor = null;
        String lineColor = null;
        String textColor = null;
        String textBackgroundColor = null;
        int lineWidth = 0;
        boolean useDashArray = symbol.getUseDashArray();
        boolean usePatternFill = symbol.getUsePatternFill();
        int patternFillType = 0;
        String altMode = null;
        boolean hideOptionalLabels = false;
        Object symbolFillIDs = null;
        Object symbolFillIconSize = null;
        try {
            int i;
            double directionOfMovement;
            JSONObject jsonModifiersString = new JSONObject(jsonString);
            JSONObject jsonModifiersArray = null;
            jsonModifiersArray = jsonModifiersString.has(MODIFIER_HEADER) ? jsonModifiersString.getJSONObject(MODIFIER_HEADER) : jsonModifiersString;
            if (jsonModifiersArray.has(QUANTITY) && !jsonModifiersArray.isNull(QUANTITY)) {
                modifierMap.put("C", jsonModifiersArray.getString(QUANTITY));
            } else if (jsonModifiersArray.has("C") && !jsonModifiersArray.isNull("C")) {
                modifierMap.put("C", jsonModifiersArray.getString("C"));
            }
            if (jsonModifiersArray.has(ADDITIONAL_INFO_1) && !jsonModifiersArray.isNull(ADDITIONAL_INFO_1)) {
                modifierMap.put("H", jsonModifiersArray.getString(ADDITIONAL_INFO_1));
            } else if (jsonModifiersArray.has("H") && !jsonModifiersArray.isNull("H")) {
                modifierMap.put("H", jsonModifiersArray.getString("H"));
            }
            if (jsonModifiersArray.has(ADDITIONAL_INFO_2) && !jsonModifiersArray.isNull(ADDITIONAL_INFO_2)) {
                modifierMap.put("H1", jsonModifiersArray.getString(ADDITIONAL_INFO_2));
            } else if (jsonModifiersArray.has("H1") && !jsonModifiersArray.isNull("H1")) {
                modifierMap.put("H1", jsonModifiersArray.getString("H1"));
            }
            if (jsonModifiersArray.has(ADDITIONAL_INFO_3) && !jsonModifiersArray.isNull(ADDITIONAL_INFO_3)) {
                modifierMap.put("H2", jsonModifiersArray.getString(ADDITIONAL_INFO_3));
            } else if (jsonModifiersArray.has("H2") && !jsonModifiersArray.isNull("H2")) {
                modifierMap.put("H2", jsonModifiersArray.getString("H2"));
            }
            if (jsonModifiersArray.has(HOSTILE) && !jsonModifiersArray.isNull(HOSTILE)) {
                modifierMap.put("N", jsonModifiersArray.getString(HOSTILE));
            } else if (jsonModifiersArray.has("N") && !jsonModifiersArray.isNull("N")) {
                modifierMap.put("N", jsonModifiersArray.getString("N"));
            }
            if (jsonModifiersArray.has(DIRECTION_OF_MOVEMENT) && !jsonModifiersArray.isNull(DIRECTION_OF_MOVEMENT)) {
                directionOfMovement = jsonModifiersArray.getDouble(DIRECTION_OF_MOVEMENT);
                modifierMap.put("Q", Double.toString(directionOfMovement));
            } else if (jsonModifiersArray.has("Q") && !jsonModifiersArray.isNull("Q")) {
                directionOfMovement = jsonModifiersArray.getDouble("Q");
                modifierMap.put("Q", Double.toString(directionOfMovement));
            }
            if (jsonModifiersArray.has(UNIQUE_DESIGNATION_1) && !jsonModifiersArray.isNull(UNIQUE_DESIGNATION_1)) {
                modifierMap.put("T", jsonModifiersArray.getString(UNIQUE_DESIGNATION_1));
            } else if (jsonModifiersArray.has("T") && !jsonModifiersArray.isNull("T")) {
                modifierMap.put("T", jsonModifiersArray.getString("T"));
            }
            if (jsonModifiersArray.has(UNIQUE_DESIGNATION_2) && !jsonModifiersArray.isNull(UNIQUE_DESIGNATION_2)) {
                modifierMap.put("T1", jsonModifiersArray.getString(UNIQUE_DESIGNATION_2));
            } else if (jsonModifiersArray.has("T1") && !jsonModifiersArray.isNull("T1")) {
                modifierMap.put("T1", jsonModifiersArray.getString("T1"));
            }
            if (jsonModifiersArray.has(EQUIPMENT_TYPE) && !jsonModifiersArray.isNull(EQUIPMENT_TYPE)) {
                modifierMap.put("V", jsonModifiersArray.getString(EQUIPMENT_TYPE));
            } else if (jsonModifiersArray.has("V") && !jsonModifiersArray.isNull("V")) {
                modifierMap.put("V", jsonModifiersArray.getString("V"));
            }
            if (jsonModifiersArray.has(DATE_TIME_GROUP_1) && !jsonModifiersArray.isNull(DATE_TIME_GROUP_1)) {
                modifierMap.put("W", jsonModifiersArray.getString(DATE_TIME_GROUP_1));
            } else if (jsonModifiersArray.has("W") && !jsonModifiersArray.isNull("W")) {
                modifierMap.put("W", jsonModifiersArray.getString("W"));
            }
            if (jsonModifiersArray.has(DATE_TIME_GROUP_2) && !jsonModifiersArray.isNull(DATE_TIME_GROUP_2)) {
                modifierMap.put("W1", jsonModifiersArray.getString(DATE_TIME_GROUP_2));
            } else if (jsonModifiersArray.has("W1") && !jsonModifiersArray.isNull("W1")) {
                modifierMap.put("W1", jsonModifiersArray.getString("W1"));
            }
            if (jsonModifiersArray.has(ALTITUDE_DEPTH) && !jsonModifiersArray.isNull(ALTITUDE_DEPTH)) {
                JSONArray jsonAltitudeArray = jsonModifiersArray.getJSONArray(ALTITUDE_DEPTH);
                altitudes = new ArrayList<Double>();
                for (i = 0; i < jsonAltitudeArray.length(); ++i) {
                    altitudes.add(jsonAltitudeArray.getDouble(i));
                }
            } else if (jsonModifiersArray.has("X") && !jsonModifiersArray.isNull("X")) {
                JSONArray jsonAltitudeArray = jsonModifiersArray.getJSONArray("X");
                altitudes = new ArrayList();
                for (i = 0; i < jsonAltitudeArray.length(); ++i) {
                    altitudes.add(jsonAltitudeArray.getDouble(i));
                }
            } else if (jsonModifiersArray.has("X") && !jsonModifiersArray.isNull("X")) {
                JSONArray jsonAltitudeArray = jsonModifiersArray.getJSONArray("X");
                altitudes = new ArrayList();
                for (i = 0; i < jsonAltitudeArray.length(); ++i) {
                    altitudes.add(jsonAltitudeArray.getDouble(i));
                }
            }
            if (jsonModifiersArray.has(DISTANCE) && !jsonModifiersArray.isNull(DISTANCE)) {
                JSONArray jsonDistanceArray = jsonModifiersArray.getJSONArray(DISTANCE);
                distances = new ArrayList<Double>();
                for (i = 0; i < jsonDistanceArray.length(); ++i) {
                    distances.add(jsonDistanceArray.getDouble(i));
                }
            } else if (jsonModifiersArray.has("AM") && !jsonModifiersArray.isNull("AM")) {
                JSONArray jsonDistanceArray = jsonModifiersArray.getJSONArray("AM");
                distances = new ArrayList();
                for (i = 0; i < jsonDistanceArray.length(); ++i) {
                    distances.add(jsonDistanceArray.getDouble(i));
                }
            }
            if (jsonModifiersArray.has(AZIMUTH) && !jsonModifiersArray.isNull(AZIMUTH)) {
                JSONArray jsonAzimuthArray = jsonModifiersArray.getJSONArray(AZIMUTH);
                azimuths = new ArrayList<Double>();
                for (i = 0; i < jsonAzimuthArray.length(); ++i) {
                    azimuths.add(jsonAzimuthArray.getDouble(i));
                }
            } else if (jsonModifiersArray.has("AN") && !jsonModifiersArray.isNull("AN")) {
                JSONArray jsonAzimuthArray = jsonModifiersArray.getJSONArray("AN");
                azimuths = new ArrayList();
                for (i = 0; i < jsonAzimuthArray.length(); ++i) {
                    azimuths.add(jsonAzimuthArray.getDouble(i));
                }
            }
            if (jsonModifiersArray.has(FILL_COLOR) && !jsonModifiersArray.isNull(FILL_COLOR)) {
                fillColor = jsonModifiersArray.getString(FILL_COLOR);
            }
            if (jsonModifiersArray.has(LINE_COLOR) && !jsonModifiersArray.isNull(LINE_COLOR)) {
                lineColor = jsonModifiersArray.getString(LINE_COLOR);
            }
            if (jsonModifiersArray.has(TEXT_COLOR) && !jsonModifiersArray.isNull(TEXT_COLOR)) {
                textColor = jsonModifiersArray.getString(TEXT_COLOR);
            }
            if (jsonModifiersArray.has(TEXT_BACKGROUND_COLOR) && !jsonModifiersArray.isNull(TEXT_BACKGROUND_COLOR)) {
                textBackgroundColor = jsonModifiersArray.getString(TEXT_BACKGROUND_COLOR);
            }
            if (jsonModifiersArray.has(LINE_THICKNESS) && !jsonModifiersArray.isNull(LINE_THICKNESS)) {
                lineWidth = jsonModifiersArray.getInt(LINE_THICKNESS);
            }
            if (jsonModifiersArray.has(USE_DASH_ARRAY) && !jsonModifiersArray.isNull(USE_DASH_ARRAY)) {
                useDashArray = jsonModifiersArray.getBoolean(USE_DASH_ARRAY);
            } else if (jsonModifiersArray.has("USEDASHARRAY") && !jsonModifiersArray.isNull("USEDASHARRAY")) {
                useDashArray = jsonModifiersArray.getBoolean("USEDASHARRAY");
            }
            if (jsonModifiersArray.has(USE_PATTERN_FILL) && !jsonModifiersArray.isNull(USE_PATTERN_FILL)) {
                usePatternFill = jsonModifiersArray.getBoolean(USE_PATTERN_FILL);
            } else if (jsonModifiersArray.has("USEPATTERNFILL") && !jsonModifiersArray.isNull("USEPATTERNFILL")) {
                usePatternFill = jsonModifiersArray.getBoolean("USEPATTERNFILL");
            }
            if (jsonModifiersArray.has(PATTERN_FILL_TYPE) && !jsonModifiersArray.isNull(PATTERN_FILL_TYPE)) {
                patternFillType = jsonModifiersArray.getInt(PATTERN_FILL_TYPE);
            } else if (jsonModifiersArray.has("PATTERNFILLTYPE") && !jsonModifiersArray.isNull("PATTERNFILLTYPE")) {
                patternFillType = jsonModifiersArray.getInt("PATTERNFILLTYPE");
            }
            if (jsonModifiersArray.has("ALTMODE")) {
                altMode = jsonModifiersArray.getString("ALTMODE");
            }
            if (jsonModifiersArray.has("HIDEOPTIONALLABELS")) {
                hideOptionalLabels = jsonModifiersArray.getBoolean("HIDEOPTIONALLABELS");
            }
            if (jsonModifiersArray.has(SYMBOL_FILL_IDS) && !jsonModifiersArray.isNull(SYMBOL_FILL_IDS)) {
                modifierMap.put(SYMBOL_FILL_IDS, jsonModifiersArray.getString(SYMBOL_FILL_IDS));
            }
            if (jsonModifiersArray.has(SYMBOL_LINE_IDS) && !jsonModifiersArray.isNull(SYMBOL_LINE_IDS)) {
                modifierMap.put(SYMBOL_LINE_IDS, jsonModifiersArray.getString(SYMBOL_LINE_IDS));
            }
            if (jsonModifiersArray.has(SYMBOL_FILL_ICON_SIZE) && !jsonModifiersArray.isNull(SYMBOL_FILL_ICON_SIZE)) {
                modifierMap.put(SYMBOL_FILL_ICON_SIZE, jsonModifiersArray.getString(SYMBOL_FILL_ICON_SIZE));
            }
        }
        catch (JSONException je) {
            System.out.println("Failed to parse modifier string in MultiPointHandler.RenderSymbol. Continuing processing the drawing of the graphic");
            System.out.println("Json String: " + String.valueOf(jsonString));
            System.out.println(je.getMessage());
            System.out.println(JavaRendererUtilities.getStackTrace(je));
            return false;
        }
        try {
            symbol.setModifierMap(modifierMap);
            if (fillColor != null) {
                symbol.setFillColor(SymbolUtilities.getColorFromHexString((String)fillColor));
            } else {
                symbol.setFillColor(null);
            }
            if (lineColor != null) {
                symbol.setLineColor(SymbolUtilities.getColorFromHexString((String)lineColor));
            }
            if (lineWidth > 0) {
                symbol.setLineWidth(lineWidth);
            }
            if (textColor != null) {
                symbol.setTextColor(SymbolUtilities.getColorFromHexString((String)textColor));
            } else {
                symbol.setTextColor(symbol.getLineColor());
            }
            if (textBackgroundColor != null) {
                symbol.setTextColor(SymbolUtilities.getColorFromHexString((String)textColor));
            } else {
                symbol.setTextBackgroundColor(SymbolDraw.getIdealTextBackgroundColor((Color)symbol.getTextColor()));
            }
            if (altMode != null) {
                symbol.setAltitudeMode(altMode);
            }
            symbol.setHideOptionalLabels(hideOptionalLabels);
            symbol.setUseDashArray(useDashArray);
            symbol.setUsePatternFill(usePatternFill);
            if (SymbolUtilities.isBasicShape((String)symbol.getSymbolID())) {
                symbol.setPatternFillType(patternFillType);
            }
            if (altitudes != null) {
                symbol.setModifiers_AM_AN_X("X", altitudes);
            }
            if (distances != null) {
                symbol.setModifiers_AM_AN_X("AM", distances);
            }
            if (azimuths != null) {
                symbol.setModifiers_AM_AN_X("AN", azimuths);
            }
            if (SymbolUtilities.getBasicSymbolID((String)symbol.getSymbolID()).equals("G*F*AXS---****X") && symbol.getModifiers_AM_AN_X("AN") != null && symbol.getModifiers_AM_AN_X("AM") != null) {
                int anCount = symbol.getModifiers_AM_AN_X("AN").size();
                int amCount = symbol.getModifiers_AM_AN_X("AM").size();
                ArrayList am = null;
                if (amCount < anCount / 2 + 1 && (Double)(am = symbol.getModifiers_AM_AN_X("AM")).get(0) != 0.0) {
                    am.add(0, 0.0);
                }
            }
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        return true;
    }

    public static IPointConversion RenderSymbol2(String symbolCode, String controlPoints, Double scale, String bbox, ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers) {
        boolean normalize = false;
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Rectangle rect = null;
        int j = 0;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<Point2D.Double> geoCoords = new ArrayList<Point2D.Double>();
        int len = coordinates.length;
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        ArrayList<Point2D.Double> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            String[] bounds = null;
            if (bbox.contains(" ")) {
                String[] coords;
                bboxCoords = new ArrayList<Point2D.Double>();
                double x = 0.0;
                double y = 0.0;
                for (String coord : coords = bbox.split(" ")) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                Point2D ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                ipc = new PointConverter(left, top, scale);
                Point2D ptPixels = null;
                ptPixels = new Point2D.Double(20.0, 20.0);
                Point2D ptGeo = ipc.PixelsToGeo(ptPixels);
                PointConverter ipcTemp = new PointConverter(ptGeo.getX(), ptGeo.getY(), scale);
                for (j = 0; j < bboxCoords.size(); ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipcTemp.GeoToPixels(ptGeo);
                    bboxCoords.set(j, (Point2D.Double)ptPixels);
                }
            } else {
                bounds = bbox.split(",");
                left = (double)Double.valueOf(bounds[0]);
                right = (double)Double.valueOf(bounds[2]);
                top = (double)Double.valueOf(bounds[3]);
                bottom = (double)Double.valueOf(bounds[1]);
                ipc = new PointConverter(left, top, scale);
            }
            if (bboxCoords == null) {
                temp = ipc.GeoToPixels(new Point2D.Double(left, top));
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                temp = ipc.GeoToPixels(new Point2D.Double(right, bottom));
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            if (coordPair.length < 2) continue;
            Double latitude = Double.valueOf(coordPair[1].trim());
            Double longitude = Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        if (Math.abs(right - left) > 180.0) {
            normalize = true;
            ipc.set_normalize(true);
        } else {
            normalize = false;
            ipc.set_normalize(false);
        }
        if (normalize) {
            MultiPointHandler.NormalizeGECoordsToGEExtents(0.0, 360.0, geoCoords);
        }
        tgl.set_SymbolId(symbolCode);
        tgl.set_Pixels(null);
        try {
            HashMap modifierMap = new HashMap();
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, modifierMap);
            tgl = clsRenderer.createTGLightFromMilStdSymbol((MilStdSymbol)mSymbol, (IPointConversion)ipc);
            if (bboxCoords == null) {
                clsRenderer.render_GE((TGLight)tgl, shapes, modifiers, (IPointConversion)ipc, rect);
            } else {
                clsRenderer.render_GE((TGLight)tgl, shapes, modifiers, (IPointConversion)ipc, bboxCoords);
            }
            jsonOutput.append("{\"type\":\"symbol\",");
            jsonContent = MultiPointHandler.JSONize(shapes, modifiers, ipc, normalize);
            jsonOutput.append(jsonContent);
            jsonOutput.append("}");
        }
        catch (Exception exc) {
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append("\"}");
        }
        boolean debug = true;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        return ipc;
    }

    private static String KMLize(String id, String name, String description, String symbolCode, ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize, Color textColor) {
        StringBuilder kml = new StringBuilder();
        ShapeInfo tempModifier = null;
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        int len = shapes.size();
        kml.append("<Folder id=\"" + id + "\">");
        kml.append("<name>" + cdataStart + name + cdataEnd + "</name>");
        kml.append("<visibility>1</visibility>");
        for (int i = 0; i < len; ++i) {
            String shapesToAdd = MultiPointHandler.ShapeToKMLString(name, description, symbolCode, shapes.get(i), ipc, normalize);
            kml.append(shapesToAdd);
        }
        int len2 = modifiers.size();
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            String labelsToAdd = MultiPointHandler.LabelToKMLString(tempModifier, ipc, normalize, textColor);
            kml.append(labelsToAdd);
        }
        kml.append("</Folder>");
        return kml.toString();
    }

    private static String JSONize(ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize) {
        String polygons = "";
        String lines = "";
        String labels = "";
        String jstr = "";
        ShapeInfo tempModifier = null;
        int len = shapes.size();
        for (int i = 0; i < len; ++i) {
            String shapesToAdd;
            if (jstr.length() > 0) {
                jstr = jstr + ",";
            }
            if ((shapesToAdd = MultiPointHandler.ShapeToJSONString(shapes.get(i), ipc, normalize)).length() <= 0) continue;
            if (shapesToAdd.startsWith("line", 2)) {
                if (lines.length() > 0) {
                    lines = lines + ",";
                }
                lines = lines + shapesToAdd;
                continue;
            }
            if (!shapesToAdd.startsWith("polygon", 2)) continue;
            if (polygons.length() > 0) {
                polygons = polygons + ",";
            }
            polygons = polygons + shapesToAdd;
        }
        jstr = jstr + "\"polygons\": [" + polygons + "],\"lines\": [" + lines + "],";
        int len2 = modifiers.size();
        labels = "";
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            String labelsToAdd = MultiPointHandler.LabelToJSONString(tempModifier, ipc, normalize);
            if (labelsToAdd.length() <= 0) continue;
            if (labels.length() > 0) {
                labels = labels + ",";
            }
            labels = labels + labelsToAdd;
        }
        jstr = jstr + "\"labels\": [" + labels + "]";
        return jstr;
    }

    private static String GeoJSONize(ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize, Color textColor, Color textBackgroundColor) {
        String jstr = "";
        ShapeInfo tempModifier = null;
        StringBuilder fc = new StringBuilder();
        fc.append("[");
        int len = shapes.size();
        for (int i = 0; i < len; ++i) {
            String shapesToAdd = MultiPointHandler.ShapeToGeoJSONString(shapes.get(i), ipc, normalize);
            if (shapesToAdd.length() > 0) {
                fc.append(shapesToAdd);
            }
            if (i >= len - 1) continue;
            fc.append(",");
        }
        int len2 = modifiers.size();
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            String labelsToAdd = MultiPointHandler.LabelToGeoJSONString(tempModifier, ipc, normalize, textColor, textBackgroundColor);
            if (labelsToAdd.length() <= 0) continue;
            fc.append(",");
            fc.append(labelsToAdd);
        }
        fc.append("]");
        String GeoJSON = fc.toString();
        return GeoJSON;
    }

    private static String GenerateGroundOverlayKML(String urlImage, IPointConversion ipc, Rectangle symbolBounds, boolean normalize) {
        double x = 0.0;
        double y = 0.0;
        double height = 0.0;
        double width = 0.0;
        StringBuilder sb = new StringBuilder();
        Boolean lineFill = false;
        Map<String, String> params = null;
        int symbolSize = 0;
        int imageOffset = 0;
        try {
            int index = -1;
            index = urlImage.indexOf(SYMBOL_LINE_IDS);
            if (index > 0) {
                lineFill = true;
                params = SinglePointRendererService.getInstance().processParams(urlImage);
                if (params.containsKey(SYMBOL_FILL_ICON_SIZE)) {
                    String size = params.get(SYMBOL_FILL_ICON_SIZE);
                    symbolSize = Integer.decode(size);
                } else {
                    symbolSize = 25;
                }
                imageOffset = symbolSize / 2 + 3;
            }
            Rectangle bounds = null;
            bounds = symbolBounds;
            height = ((RectangularShape)bounds).getHeight() + (double)(imageOffset * 2);
            width = ((RectangularShape)bounds).getWidth() + (double)(imageOffset * 2);
            x = ((RectangularShape)bounds).getX() - (double)imageOffset;
            y = ((RectangularShape)bounds).getY() - (double)imageOffset;
            Point2D.Double coord = new Point2D.Double(x, y);
            Point2D topLeft = ipc.PixelsToGeo((Point2D)coord);
            coord = new Point2D.Double(x + width, y + height);
            Point2D bottomRight = ipc.PixelsToGeo((Point2D)coord);
            if (normalize) {
                topLeft = MultiPointHandler.NormalizeCoordToGECoord(topLeft);
                bottomRight = MultiPointHandler.NormalizeCoordToGECoord(bottomRight);
            }
            String cdataStart = "<![CDATA[";
            String cdataEnd = "]]>";
            sb.append("<GroundOverlay>");
            sb.append("<name>symbol fill</name>");
            sb.append("<description>symbol fill</description>");
            sb.append("<Icon>");
            sb.append("<href>");
            sb.append(cdataStart);
            sb.append(urlImage);
            sb.append(cdataEnd);
            sb.append("</href>");
            sb.append("</Icon>");
            sb.append("<LatLonBox>");
            sb.append("<north>");
            sb.append(String.valueOf(topLeft.getY()));
            sb.append("</north>");
            sb.append("<south>");
            sb.append(String.valueOf(bottomRight.getY()));
            sb.append("</south>");
            sb.append("<east>");
            sb.append(String.valueOf(bottomRight.getX()));
            sb.append("</east>");
            sb.append("<west>");
            sb.append(String.valueOf(topLeft.getX()));
            sb.append("</west>");
            sb.append("<rotation>");
            sb.append(0);
            sb.append("</rotation>");
            sb.append("</LatLonBox>");
            sb.append("</GroundOverlay>");
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        String kml = sb.toString();
        return kml;
    }

    private static void MakeWWReady(ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize) {
        ShapeInfo temp = null;
        int len = shapes.size();
        for (int i = 0; i < len; ++i) {
            temp = MultiPointHandler.ShapeToWWReady(shapes.get(i), ipc, normalize);
            shapes.set(i, temp);
        }
        int len2 = modifiers.size();
        ShapeInfo tempModifier = null;
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            tempModifier = MultiPointHandler.LabelToWWReady(tempModifier, ipc, normalize);
            modifiers.set(j, tempModifier);
        }
    }

    private static Boolean IsOnePointSymbolCode(String symbolCode) {
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        String basicCode = SymbolUtilities.getBasicSymbolID((String)symbolCode);
        SymbolDef sd = null;
        if (SymbolDefTable.getInstance().HasSymbolDef(basicCode, symStd).booleanValue()) {
            sd = SymbolDefTable.getInstance().getSymbolDef(basicCode, symStd);
            if (symbolCode.charAt(0) == 'G' && sd.getMaxPoints() == 1) {
                return true;
            }
        }
        if (symbolCode.equals("CAKE-----------")) {
            return true;
        }
        if (symbolCode.equals("CYLINDER-------")) {
            return true;
        }
        if (symbolCode.equals("RADARC---------")) {
            return true;
        }
        return false;
    }

    private static Boolean normalizePoints(ArrayList<Point2D.Double> shape, IPointConversion ipc) {
        ArrayList<Point2D.Double> geoCoords = new ArrayList<Point2D.Double>();
        for (int j = 0; j < shape.size(); ++j) {
            Point2D coord = shape.get(j);
            Point2D geoCoord = ipc.PixelsToGeo(coord);
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
            double latitude = geoCoord.getY();
            double longitude = geoCoord.getX();
            Point2D.Double pt2d = new Point2D.Double(longitude, latitude);
            geoCoords.add(pt2d);
        }
        Boolean normalize = MultiPointHandler.crossesIDL(geoCoords);
        return normalize;
    }

    private static String ShapeToKMLString(String name, String description, String symbolCode, ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        StringBuilder kml = new StringBuilder();
        Color lineColor = null;
        Color fillColor = null;
        String googleLineColor = null;
        String googleFillColor = null;
        BasicStroke stroke = null;
        int lineWidth = 4;
        symbolCode = JavaRendererUtilities.normalizeSymbolCode(symbolCode);
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        kml.append("<Placemark>");
        kml.append("<description>" + cdataStart + "<b>" + name + "</b><br/>\n" + description + cdataEnd + "</description>");
        kml.append("<Style>");
        lineColor = shapeInfo.getLineColor();
        if (lineColor != null) {
            googleLineColor = Integer.toHexString(shapeInfo.getLineColor().getRGB());
            stroke = (BasicStroke)shapeInfo.getStroke();
            if (stroke != null) {
                lineWidth = (int)stroke.getLineWidth();
            }
            while (googleLineColor.length() < 8) {
                googleLineColor = "0" + googleLineColor;
            }
            googleLineColor = JavaRendererUtilities.ARGBtoABGR(googleLineColor);
            kml.append("<LineStyle>");
            kml.append("<color>" + googleLineColor + "</color>");
            kml.append("<colorMode>normal</colorMode>");
            kml.append("<width>" + String.valueOf(lineWidth) + "</width>");
            kml.append("</LineStyle>");
        }
        if ((fillColor = shapeInfo.getFillColor()) != null) {
            googleFillColor = Integer.toHexString(shapeInfo.getFillColor().getRGB());
            while (googleFillColor.length() < 8) {
                googleFillColor = "0" + googleFillColor;
            }
            googleFillColor = JavaRendererUtilities.ARGBtoABGR(googleFillColor);
            kml.append("<PolyStyle>");
            kml.append("<color>" + googleFillColor + "</color>");
            kml.append("<colorMode>normal</colorMode>");
            kml.append("<fill>1</fill>");
            if (lineColor != null) {
                kml.append("<outline>1</outline>");
            } else {
                kml.append("<outline>0</outline>");
            }
            kml.append("</PolyStyle>");
        }
        kml.append("</Style>");
        ArrayList shapesArray = shapeInfo.getPolylines();
        int len = shapesArray.size();
        kml.append("<MultiGeometry>");
        for (int i = 0; i < len; ++i) {
            Point2D geoCoord;
            double longitude;
            ArrayList shape = (ArrayList)shapesArray.get(i);
            normalize = MultiPointHandler.normalizePoints(shape, ipc);
            if (lineColor != null && fillColor == null) {
                kml.append("<LineString>");
                kml.append("<tessellate>1</tessellate>");
                kml.append("<altitudeMode>clampToGround</altitudeMode>");
                kml.append("<coordinates>");
                for (int j = 0; j < shape.size(); ++j) {
                    Point2D coord = (Point2D)shape.get(j);
                    Point2D geoCoord2 = ipc.PixelsToGeo(coord);
                    if (normalize) {
                        geoCoord2 = MultiPointHandler.NormalizeCoordToGECoord(geoCoord2);
                    }
                    double latitude = (double)Math.round(geoCoord2.getY() * 1.0E8) / 1.0E8;
                    longitude = (double)Math.round(geoCoord2.getX() * 1.0E8) / 1.0E8;
                    kml.append(longitude);
                    kml.append(",");
                    kml.append(latitude);
                    if (j >= shape.size() - 1) continue;
                    kml.append(" ");
                }
                kml.append("</coordinates>");
                kml.append("</LineString>");
            }
            if (fillColor == null) continue;
            if (i == 0) {
                kml.append("<Polygon>");
            }
            if (i == 1 && len > 1) {
                kml.append("<innerBoundaryIs>");
            } else {
                kml.append("<outerBoundaryIs>");
            }
            kml.append("<LinearRing>");
            kml.append("<altitudeMode>clampToGround</altitudeMode>");
            kml.append("<tessellate>1</tessellate>");
            kml.append("<coordinates>");
            double lastLongitude = Double.MIN_VALUE;
            if (!normalize && MultiPointHandler.IsOnePointSymbolCode(symbolCode).booleanValue()) {
                for (int j = 0; j < shape.size(); ++j) {
                    Point2D coord = (Point2D)shape.get(j);
                    geoCoord = ipc.PixelsToGeo(coord);
                    longitude = geoCoord.getX();
                    if (lastLongitude != Double.MIN_VALUE && Math.abs(longitude - lastLongitude) > 180.0) {
                        normalize = true;
                        break;
                    }
                    lastLongitude = longitude;
                }
            }
            for (int j = 0; j < shape.size(); ++j) {
                Point2D coord = (Point2D)shape.get(j);
                geoCoord = ipc.PixelsToGeo(coord);
                double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
                double longitude2 = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
                if (normalize && longitude2 > 0.0) {
                    longitude2 -= 360.0;
                }
                kml.append(longitude2);
                kml.append(",");
                kml.append(latitude);
                if (j >= shape.size() - 1) continue;
                kml.append(" ");
            }
            kml.append("</coordinates>");
            kml.append("</LinearRing>");
            if (i == 1 && len > 1) {
                kml.append("</innerBoundaryIs>");
            } else {
                kml.append("</outerBoundaryIs>");
            }
            if (i != len - 1) continue;
            kml.append("</Polygon>");
        }
        kml.append("</MultiGeometry>");
        kml.append("</Placemark>");
        return kml.toString();
    }

    private static ShapeInfo ShapeToWWReady(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        ArrayList shapesArray = shapeInfo.getPolylines();
        int len = shapesArray.size();
        for (int i = 0; i < len; ++i) {
            Point2D geoCoord;
            Point2D coord;
            int j;
            ArrayList shape = (ArrayList)shapesArray.get(i);
            if (shapeInfo.getLineColor() != null) {
                for (j = 0; j < shape.size(); ++j) {
                    coord = (Point2D)shape.get(j);
                    geoCoord = ipc.PixelsToGeo(coord);
                    if (normalize) {
                        geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                    }
                    shape.set(j, geoCoord);
                }
            }
            if (shapeInfo.getFillColor() == null) continue;
            for (j = 0; j < shape.size(); ++j) {
                coord = (Point2D)shape.get(j);
                geoCoord = ipc.PixelsToGeo(coord);
                shape.set(j, geoCoord);
            }
        }
        return shapeInfo;
    }

    private static ShapeInfo LabelToWWReady(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        try {
            Point2D.Double coord = new Point2D.Double(shapeInfo.getGlyphPosition().getX(), shapeInfo.getGlyphPosition().getY());
            Point2D geoCoord = ipc.PixelsToGeo((Point2D)coord);
            if (normalize) {
                geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
            }
            double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
            double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
            long angle = Math.round(shapeInfo.getModifierStringAngle());
            String text = shapeInfo.getModifierString();
            if (text == null || text.equals("")) {
                return null;
            }
            shapeInfo.setModifierStringPosition(geoCoord);
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
        return shapeInfo;
    }

    private static void AdjustModifierPointToCenter(ShapeInfo modifier) {
        AffineTransform at = null;
        try {
            Rectangle2D bounds = modifier.getTextLayout().getBounds();
            at = modifier.getAffineTransform();
            if (at != null) {
                bounds = at.createTransformedShape(bounds).getBounds2D();
            }
            modifier.setGlyphPosition((Point2D)new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
    }

    private static String ShapeToJSONString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        StringBuilder JSONed = new StringBuilder();
        String fillColor = null;
        String lineColor = null;
        if (shapeInfo.getLineColor() != null) {
            lineColor = Integer.toHexString(shapeInfo.getLineColor().getRGB());
        }
        if (shapeInfo.getFillColor() != null) {
            fillColor = Integer.toHexString(shapeInfo.getFillColor().getRGB());
        }
        BasicStroke stroke = null;
        stroke = (BasicStroke)shapeInfo.getStroke();
        int lineWidth = 4;
        if (stroke != null) {
            lineWidth = (int)stroke.getLineWidth();
        }
        ArrayList shapesArray = shapeInfo.getPolylines();
        for (int i = 0; i < shapesArray.size(); ++i) {
            ArrayList shape = (ArrayList)shapesArray.get(i);
            normalize = MultiPointHandler.normalizePoints(shape, ipc);
            if (fillColor != null) {
                JSONed.append("{\"polygon\":[");
            } else {
                JSONed.append("{\"line\":[");
            }
            for (int j = 0; j < shape.size(); ++j) {
                Point2D coord = (Point2D)shape.get(j);
                Point2D geoCoord = ipc.PixelsToGeo(coord);
                if (normalize) {
                    geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                }
                double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
                double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
                if (normalize && fillColor != null && longitude > 0.0) {
                    longitude -= 360.0;
                }
                coord = new Point2D.Double(longitude, latitude);
                shape.set(j, coord);
                JSONed.append("[");
                JSONed.append(longitude);
                JSONed.append(",");
                JSONed.append(latitude);
                JSONed.append("]");
                if (j >= shape.size() - 1) continue;
                JSONed.append(",");
            }
            JSONed.append("]");
            if (lineColor != null) {
                JSONed.append(",\"lineColor\":\"");
                JSONed.append(lineColor);
                JSONed.append("\"");
            }
            if (fillColor != null) {
                JSONed.append(",\"fillColor\":\"");
                JSONed.append(fillColor);
                JSONed.append("\"");
            }
            JSONed.append(",\"lineWidth\":\"");
            JSONed.append(String.valueOf(lineWidth));
            JSONed.append("\"");
            JSONed.append("}");
            if (i >= shapesArray.size() - 1) continue;
            JSONed.append(",");
        }
        return JSONed.toString();
    }

    private static String ShapeToGeoJSONString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        StringBuilder JSONed = new StringBuilder();
        StringBuilder properties = new StringBuilder();
        StringBuilder geometry = new StringBuilder();
        String geometryType = null;
        Color lineColor = shapeInfo.getLineColor();
        Color fillColor = shapeInfo.getFillColor();
        geometryType = shapeInfo.getShapeType() == ShapeInfo.SHAPE_TYPE_FILL || fillColor != null ? "\"Polygon\"" : "\"MultiLineString\"";
        BasicStroke stroke = null;
        stroke = (BasicStroke)shapeInfo.getStroke();
        int lineWidth = 4;
        if (stroke != null) {
            lineWidth = (int)stroke.getLineWidth();
        }
        properties.append("\"properties\":{");
        properties.append("\"label\":\"\",");
        if (lineColor != null) {
            properties.append("\"strokeColor\":\"" + SymbolUtilities.colorToHexString((Color)lineColor, (Boolean)false) + "\",");
            properties.append("\"lineOpacity\":" + String.valueOf((float)lineColor.getAlpha() / 255.0f) + ",");
        }
        if (fillColor != null) {
            properties.append("\"fillColor\":\"" + SymbolUtilities.colorToHexString((Color)fillColor, (Boolean)false) + "\",");
            properties.append("\"fillOpacity\":" + String.valueOf((float)fillColor.getAlpha() / 255.0f) + ",");
        }
        String strokeWidth = String.valueOf(lineWidth);
        properties.append("\"strokeWidth\":" + strokeWidth + ",");
        properties.append("\"strokeWeight\":" + strokeWidth + "");
        properties.append("}");
        geometry.append("\"geometry\":{\"type\":");
        geometry.append(geometryType);
        geometry.append(",\"coordinates\":[");
        ArrayList shapesArray = shapeInfo.getPolylines();
        for (int i = 0; i < shapesArray.size(); ++i) {
            ArrayList pointList = (ArrayList)shapesArray.get(i);
            normalize = MultiPointHandler.normalizePoints(pointList, ipc);
            geometry.append("[");
            for (int j = 0; j < pointList.size(); ++j) {
                Point2D coord = (Point2D)pointList.get(j);
                Point2D geoCoord = ipc.PixelsToGeo(coord);
                if (normalize) {
                    geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                }
                double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
                double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
                if (normalize && fillColor != null && longitude > 0.0) {
                    longitude -= 360.0;
                }
                coord = new Point2D.Double(longitude, latitude);
                pointList.set(j, coord);
                geometry.append("[");
                geometry.append(longitude);
                geometry.append(",");
                geometry.append(latitude);
                geometry.append("]");
                if (j >= pointList.size() - 1) continue;
                geometry.append(",");
            }
            geometry.append("]");
            if (i >= shapesArray.size() - 1) continue;
            geometry.append(",");
        }
        geometry.append("]}");
        JSONed.append("{\"type\":\"Feature\",");
        JSONed.append((CharSequence)properties);
        JSONed.append(",");
        JSONed.append((CharSequence)geometry);
        JSONed.append("}");
        return JSONed.toString();
    }

    private static String LabelToKMLString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize, Color textColor) {
        StringBuilder kml = new StringBuilder();
        Point2D.Double coord = new Point2D.Double(shapeInfo.getModifierStringPosition().getX(), shapeInfo.getModifierStringPosition().getY());
        Point2D geoCoord = ipc.PixelsToGeo((Point2D)coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
        double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
        long angle = Math.round(shapeInfo.getModifierStringAngle());
        String text = shapeInfo.getModifierString();
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        String color = SymbolUtilities.colorToHexString((Color)textColor, (Boolean)true);
        color = JavaRendererUtilities.ARGBtoABGR(color.substring(1));
        float kmlScale = RendererSettings.getInstance().getKMLLabelScale();
        if (!(kmlScale > 0.0f) || text == null || text.equals("")) {
            return "";
        }
        kml.append("<Placemark>");
        kml.append("<name>" + cdataStart + text + cdataEnd + "</name>");
        kml.append("<Style>");
        kml.append("<IconStyle>");
        kml.append("<scale>.7</scale>");
        kml.append("<heading>" + angle + "</heading>");
        kml.append("<Icon>");
        kml.append("<href></href>");
        kml.append("</Icon>");
        kml.append("</IconStyle>");
        kml.append("<LabelStyle>");
        kml.append("<color>" + color + "</color>");
        kml.append("<scale>" + String.valueOf(kmlScale) + "</scale>");
        kml.append("</LabelStyle>");
        kml.append("</Style>");
        kml.append("<Point>");
        kml.append("<extrude>1</extrude>");
        kml.append("<altitudeMode>relativeToGround</altitudeMode>");
        kml.append("<coordinates>");
        kml.append(longitude);
        kml.append(",");
        kml.append(latitude);
        kml.append("</coordinates>");
        kml.append("</Point>");
        kml.append("</Placemark>");
        return kml.toString();
    }

    private static String LabelToJSONString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        StringBuilder JSONed = new StringBuilder();
        JSONed.append("{\"label\":");
        Point2D.Double coord = new Point2D.Double(shapeInfo.getGlyphPosition().getX(), shapeInfo.getGlyphPosition().getY());
        Point2D geoCoord = ipc.PixelsToGeo((Point2D)coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
        double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
        double angle = shapeInfo.getModifierStringAngle();
        ((Point2D)coord).setLocation(longitude, latitude);
        shapeInfo.setGlyphPosition((Point2D)coord);
        String text = shapeInfo.getModifierString();
        if (text == null || text.equals("")) {
            return "";
        }
        JSONed.append("[");
        JSONed.append(longitude);
        JSONed.append(",");
        JSONed.append(latitude);
        JSONed.append("]");
        JSONed.append(",\"text\":\"");
        JSONed.append(text);
        JSONed.append("\"");
        JSONed.append(",\"angle\":\"");
        JSONed.append(angle);
        JSONed.append("\"}");
        return JSONed.toString();
    }

    private static String LabelToGeoJSONString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize, Color textColor, Color textBackgroundColor) {
        StringBuilder JSONed = new StringBuilder();
        StringBuilder properties = new StringBuilder();
        StringBuilder geometry = new StringBuilder();
        Color outlineColor = SymbolDraw.getIdealTextBackgroundColor((Color)textColor);
        if (textBackgroundColor != null) {
            outlineColor = textBackgroundColor;
        }
        Point2D.Double coord = new Point2D.Double(shapeInfo.getModifierStringPosition().getX(), shapeInfo.getModifierStringPosition().getY());
        Point2D geoCoord = ipc.PixelsToGeo((Point2D)coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
        double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
        double angle = shapeInfo.getModifierStringAngle();
        ((Point2D)coord).setLocation(longitude, latitude);
        shapeInfo.setGlyphPosition((Point2D)coord);
        String text = shapeInfo.getModifierString();
        int justify = shapeInfo.getTextJustify();
        String strJustify = "left";
        if (justify == 0) {
            strJustify = "left";
        } else if (justify == 1) {
            strJustify = "center";
        } else if (justify == 2) {
            strJustify = "right";
        }
        RendererSettings RS = RendererSettings.getInstance();
        if (text != null && !text.equals("")) {
            JSONed.append("{\"type\":\"Feature\",\"properties\":{\"label\":\"");
            JSONed.append(text);
            JSONed.append("\",\"pointRadius\":0,\"fontColor\":\"");
            JSONed.append(SymbolUtilities.colorToHexString((Color)textColor, (Boolean)false));
            JSONed.append("\",\"fontSize\":\"");
            JSONed.append(String.valueOf(RS.getLabelFontSize()) + "pt\"");
            JSONed.append(",\"fontFamily\":\"");
            JSONed.append(RS.getLabelFontName());
            JSONed.append(", sans-serif");
            if (RS.getLabelFontType() == 1) {
                JSONed.append("\",\"fontWeight\":\"bold\"");
            } else {
                JSONed.append("\",\"fontWeight\":\"normal\"");
            }
        } else {
            return "";
        }
        JSONed.append(",\"labelAlign\":\"");
        JSONed.append(strJustify);
        JSONed.append("\",\"labelBaseline\":\"alphabetic");
        JSONed.append("\",\"labelXOffset\":0");
        JSONed.append(",\"labelYOffset\":0");
        JSONed.append(",\"labelOutlineColor\":\"");
        JSONed.append(SymbolUtilities.colorToHexString((Color)outlineColor, (Boolean)false));
        JSONed.append("\",\"labelOutlineWidth\":");
        JSONed.append(4);
        JSONed.append(",\"rotation\":");
        JSONed.append(angle);
        JSONed.append(",\"angle\":");
        JSONed.append(angle);
        JSONed.append("},");
        JSONed.append("\"geometry\":{\"type\":\"Point\",\"coordinates\":[");
        JSONed.append(longitude);
        JSONed.append(",");
        JSONed.append(latitude);
        JSONed.append("]");
        JSONed.append("}}");
        return JSONed.toString();
    }

    public static String getModififerKML(String id, String name, String description, String symbolCode, String controlPoints, Double scale, String bbox, String symbolModifiers, int format, int symStd) {
        String output = "";
        LinkedList<String> placemarks = new LinkedList<String>();
        try {
            double maxAlt = 0.0;
            double minAlt = 0.0;
            output = MultiPointHandler.RenderSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, symbolModifiers, format, symStd);
            int pmiStart = output.indexOf("<Placemark");
            int pmiEnd = 0;
            boolean curr = false;
            int count = 0;
            String tempPlacemark = "";
            while (pmiStart > 0) {
                if (count > 0) {
                    pmiEnd = output.indexOf("</Placemark>", pmiStart) + 12;
                    tempPlacemark = output.substring(pmiStart, pmiEnd);
                    if (tempPlacemark.contains("<Point>")) {
                        placemarks.add(output.substring(pmiStart, pmiEnd));
                    }
                    pmiStart = output.indexOf("<Placemark", pmiEnd - 2);
                }
                ++count;
            }
            StringBuilder sb = new StringBuilder();
            for (String pm : placemarks) {
                sb.append(pm);
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return output;
        }
    }

    public static String getModifierKML2(String symbolID, JSONObject modifiersJSON, String strPoints) {
        String[] points = strPoints.split(" ");
        Object altitudeDepthJSON = null;
        Object distanceJSON = null;
        Object azimuthJSON = null;
        boolean altitudeDepthLength = false;
        boolean distanceLength = false;
        boolean azimuthLength = false;
        StringBuilder sb = new StringBuilder();
        String name = "<![CDATA[name1<br>name2]]>";
        String description = "<![CDATA[X1<br>X2]]>";
        String lat = "0.0";
        String lon = "0.0";
        String alt = "100.0";
        try {
            System.out.println("generating description KML");
            System.out.println("points: " + points[0]);
            String[] point = points[0].split(",");
            lat = point[0];
            lon = point[1];
            alt = point.length < 3 ? "0" : point[2];
            sb.append("<Placemark>");
            sb.append("<name>" + name + "</name>");
            sb.append("<Style>");
            sb.append("<IconStyle>");
            sb.append("<scale>.7</scale>");
            sb.append("<heading>0</heading>");
            sb.append("<Icon><href/></Icon>");
            sb.append("</IconStyle>");
            sb.append("<LabelStyle>");
            sb.append("<scale>.8</scale>");
            sb.append("</LabelStyle>");
            sb.append("<description>" + description + "</description>");
            sb.append("<Point>");
            sb.append("<coordinates>" + lat + "," + lon + "," + alt + "</coordinates>");
            sb.append("</Point>");
            sb.append("</Placemark>");
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
        System.out.println("KML segment: ");
        System.out.println(sb.toString());
        return sb.toString();
    }
}

