/*
 * Decompiled with CFR 0.152.
 */
package sec.geo.shape;

import org.gavaghan.geodesy.GlobalPosition;

public class Point {
    private final double longitudeDegrees;
    private final double latitudeDegrees;
    private final double altitudeMeters;

    public Point(double longitudeDegrees, double latitudeDegrees) {
        this(longitudeDegrees, latitudeDegrees, 0.0);
    }

    public Point(double longitudeDegrees, double latitudeDegrees, double altitudeMeters) {
        this.longitudeDegrees = longitudeDegrees;
        this.latitudeDegrees = latitudeDegrees;
        this.altitudeMeters = altitudeMeters;
    }

    public double getLongitude() {
        return this.longitudeDegrees;
    }

    public double getLatitude() {
        return this.latitudeDegrees;
    }

    public double getAltitude() {
        return this.altitudeMeters;
    }

    public GlobalPosition toGlobalPos() {
        return new GlobalPosition(this.getLatitude(), this.getLongitude(), this.getAltitude());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        return this.longitudeDegrees == other.longitudeDegrees && this.latitudeDegrees == other.latitudeDegrees && this.altitudeMeters == other.altitudeMeters;
    }

    public String toString() {
        return "[" + this.longitudeDegrees + "," + this.latitudeDegrees + "," + this.altitudeMeters + "]";
    }
}

