/*
 * Decompiled with CFR 0.152.
 */
package sec.geo.kml;

import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sec.geo.kml.KmlPolygon;
import sec.geo.shape.AComposite;
import sec.geo.shape.AExtrusion;
import sec.geo.shape.Point;

public class KmlRenderer {
    private static final String EXCEPTION = "EXCEPTION:";
    private String colorDefault = "ff003fff";
    private String descriptionField = "#DESCRIPTION#";
    private String extendedData = "#EXTENDEDDATA#";
    private String colorField = "#COLOR#";
    private String nameField = "#NAME#";
    private String idField = "#ID#";
    private String placemarkidField = "#PLACEMARKID#";
    private String KML_START = "<Folder id=\"" + this.idField + "\">\n";
    private String KML_END = "</Folder>\n";
    private String PLACEMARK_START = "\t\t<Placemark id=\"" + this.placemarkidField + "\">\n                      <Style>\n                          <PolyStyle>\n                              <color>" + this.colorField + "</color>\n                          </PolyStyle>\n                          <LineStyle>\n                              <color>" + this.colorField + "</color>\n                          </LineStyle>\n                       </Style>\n\t\t\t<name>" + this.nameField + "</name>\n\t\t\t<description>" + this.descriptionField + "</description>\n\t\t\t<ExtendedData>" + this.extendedData + "</ExtendedData>\n\t\t\t<MultiGeometry>\n";
    private String PLACEMARK_END = "\t\t\t</MultiGeometry>\n\t\t</Placemark>\n";
    private String DEFAULT_EXDAT = "<Data name='sid'><value>#ID#</value></Data><Data name='shapeType'><value>#SHAPETYPE#</value></Data><Data name='lat'><value>#LAT#</value></Data><Data name='lon'><value>#LON#</value></Data><Data name='alt'><value>#ALT#</value></Data>";
    private String DEFAULT_BLSTY = "<![CDATA[$[sid]]]>";

    public Set<KmlPolygon> renderPolygons(AExtrusion ext) {
        HashSet<KmlPolygon> polys = new HashSet<KmlPolygon>();
        ext.setMaxDistance(200000.0);
        ext.setFlatness(2.0);
        ext.setLimit(8);
        ArrayList<Point> perimeterPoints = new ArrayList<Point>();
        PathIterator it = ext.getShape().getPathIterator(null);
        Point pre = null;
        while (!it.isDone()) {
            double[] strokePoints = new double[6];
            int type = it.currentSegment(strokePoints);
            double longitudeDegrees = strokePoints[0];
            double latitudeDegrees = strokePoints[1];
            switch (type) {
                case 0: 
                case 1: {
                    if (pre != null) {
                        ArrayList<Point> ps = new ArrayList<Point>();
                        ps.add(new Point(pre.getLongitude(), pre.getLatitude(), ext.getMinAltitude()));
                        ps.add(new Point(pre.getLongitude(), pre.getLatitude(), ext.getMaxAltitude()));
                        ps.add(new Point(longitudeDegrees, latitudeDegrees, ext.getMaxAltitude()));
                        ps.add(new Point(longitudeDegrees, latitudeDegrees, ext.getMinAltitude()));
                        ps.add(new Point(pre.getLongitude(), pre.getLatitude(), ext.getMinAltitude()));
                        polys.add(new KmlPolygon(ps, ext.getAltitudeMode()));
                    }
                    pre = new Point(longitudeDegrees, latitudeDegrees);
                    perimeterPoints.add(pre);
                }
            }
            it.next();
        }
        if (perimeterPoints.size() > 0) {
            if (((Point)perimeterPoints.get(0)).equals(perimeterPoints.get(perimeterPoints.size() - 1))) {
                polys.add(new KmlPolygon(this.transformPoints(perimeterPoints, ext.getMinAltitude()), ext.getAltitudeMode()));
                polys.add(new KmlPolygon(this.transformPoints(perimeterPoints, ext.getMaxAltitude()), ext.getAltitudeMode()));
            } else {
                perimeterPoints.add((Point)perimeterPoints.get(0));
                polys.add(new KmlPolygon(this.transformPoints(perimeterPoints, ext.getMinAltitude()), ext.getAltitudeMode()));
                polys.add(new KmlPolygon(this.transformPoints(perimeterPoints, ext.getMaxAltitude()), ext.getAltitudeMode()));
            }
        }
        return polys;
    }

    public String getPlacemarkKml(AExtrusion ext, String id, String name, String description, String lineColor, String fillColor) {
        try {
            StringBuilder sb = new StringBuilder();
            Set<KmlPolygon> polys = this.renderPolygons(ext);
            sb.append(this.PLACEMARK_START);
            int placemarkIdIndex = sb.indexOf(this.placemarkidField);
            int placemarkIdLength = this.placemarkidField.length();
            if (id != null) {
                sb.replace(placemarkIdIndex, placemarkIdIndex + placemarkIdLength, id + "_mg");
            }
            int descriptionIndex = sb.indexOf(this.descriptionField);
            int descriptionLength = this.descriptionField.length();
            if (description != null) {
                sb.replace(descriptionIndex, descriptionIndex + descriptionLength, "<![CDATA[" + description + "]]>");
            }
            int colorIndex = sb.indexOf(this.colorField);
            int colorLength = this.colorField.length();
            if (fillColor != null) {
                sb.replace(colorIndex, colorIndex + colorLength, fillColor);
            } else {
                sb.replace(colorIndex, colorIndex + colorLength, this.colorDefault);
            }
            int lineColorIndex = sb.indexOf(this.colorField, colorIndex + colorLength);
            if (lineColor != null) {
                sb.replace(lineColorIndex, lineColorIndex + colorLength, lineColor);
            } else {
                sb.replace(lineColorIndex, lineColorIndex + colorLength, this.colorDefault);
            }
            int nameIndex = sb.indexOf(this.nameField);
            int nameLength = this.nameField.length();
            if (name != null) {
                sb.replace(nameIndex, nameIndex + nameLength, "<![CDATA[" + name + "]]>");
            }
            for (KmlPolygon poly : polys) {
                sb.append(poly.toString());
            }
            sb.append(this.PLACEMARK_END);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return EXCEPTION + e.getMessage();
        }
    }

    public String getKml(AExtrusion ext, String id, String name, String description, String lineColor, String fillColor) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.KML_START);
            int idIndex = sb.indexOf(this.idField);
            int idLength = this.idField.length();
            sb.replace(idIndex, idIndex + idLength, id);
            sb.append(this.getPlacemarkKml(ext, id, name, description, lineColor, fillColor));
            sb.append(this.KML_END);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return EXCEPTION + e.getMessage();
        }
    }

    public String getKml(AComposite com, String id, String name, String description, String lineColor, String fillColor) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.KML_START);
        int idIndex = sb.indexOf(this.idField);
        int idLength = this.idField.length();
        sb.replace(idIndex, idIndex + idLength, id);
        for (AExtrusion ext : com.getElements()) {
            String extStr = this.getPlacemarkKml(ext, id, name, description, lineColor, fillColor);
            if (extStr.startsWith(EXCEPTION)) continue;
            sb.append(extStr);
        }
        sb.append(this.KML_END);
        return sb.toString();
    }

    public String[] getCoords(AExtrusion ext) {
        Set<KmlPolygon> polys = this.renderPolygons(ext);
        String[] coords = new String[polys.size()];
        int i = 0;
        for (KmlPolygon poly : polys) {
            coords[i] = poly.toCoordString();
            ++i;
        }
        return coords;
    }

    private List<Point> transformPoints(List<Point> points, double altitudeMeters) {
        ArrayList<Point> returnPoints = new ArrayList<Point>();
        for (Point p : points) {
            returnPoints.add(new Point(p.getLongitude(), p.getLatitude(), altitudeMeters));
        }
        return returnPoints;
    }
}

