/*
 * Decompiled with CFR 0.152.
 */
package io.github.miracelwhipp.net.nuget.plugin;

import io.github.miracelwhipp.net.nuget.plugin.NugetArtifact;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=NugetPackageDownloadManager.class, instantiationStrategy="singleton")
public class NugetPackageDownloadManager {
    @Requirement
    private Logger logger;
    private final Map<String, File> localResources = new HashMap<String, File>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void get(Wagon delegate, NugetArtifact artifact, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File lock;
        this.logger.debug("downloadmanager.get " + artifact.toString() + " to " + destination.getAbsolutePath());
        if (destination.exists()) {
            this.logger.debug("File already exists. Nothing to be done.");
            return;
        }
        String key = artifact.resourceString();
        this.logger.debug("Acquiring lock for " + key + "...");
        File file = lock = this.getLock(key, destination);
        synchronized (file) {
            this.logger.debug("Lock acquired for " + key + "...");
            if (destination.exists()) {
                this.logger.debug("File was created while waiting for lock. Nothing to be done.");
                return;
            }
            File tempFile = new File(destination.getAbsolutePath() + ".tmp" + UUID.randomUUID().toString());
            this.logger.debug("downloading temp-file " + tempFile.getAbsolutePath());
            delegate.get(key, tempFile);
            if (!tempFile.renameTo(destination)) {
                throw new TransferFailedException("cannot rename file. source = " + tempFile.getAbsolutePath() + " target = " + destination.getAbsolutePath());
            }
            this.logger.debug("Download done. tempfile renamed to " + destination.getAbsolutePath());
        }
    }

    private synchronized File getLock(String key, File destination) {
        File result = this.localResources.get(key);
        if (result != null) {
            return result;
        }
        this.localResources.put(key, destination);
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getIfNewer(Wagon delegate, NugetArtifact artifact, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File lock;
        this.logger.debug("downloadmanager.getIfNewer " + artifact.toString() + " to " + destination.getAbsolutePath() + " for timestamp " + timestamp);
        if (destination.exists() && destination.lastModified() > timestamp) {
            this.logger.debug("File already exists and is last modified " + destination.lastModified() + ". Nothing to be done.");
            return true;
        }
        String key = artifact.resourceString();
        this.logger.debug("Acquiring lock for " + key + "...");
        File file = lock = this.getLock(key, destination);
        synchronized (file) {
            this.logger.debug("Lock acquired for " + key + "...");
            if (destination.exists() && destination.lastModified() > timestamp) {
                this.logger.debug("File was modified at " + destination.lastModified() + " while waiting for lock. Nothing to be done.");
                return true;
            }
            File tempFile = new File(destination.getAbsolutePath() + ".tmp" + UUID.randomUUID().toString());
            this.logger.debug("downloading temp-file " + tempFile.getAbsolutePath());
            boolean result = delegate.getIfNewer(key, tempFile, timestamp);
            if (!result) {
                this.logger.debug("Delegate omitted download.");
                return false;
            }
            if (!tempFile.renameTo(destination)) {
                throw new TransferFailedException("cannot rename file. source = " + tempFile.getAbsolutePath() + " target = " + destination.getAbsolutePath());
            }
            this.logger.debug("Download done. tempfile renamed to " + destination.getAbsolutePath());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNugetFile(Wagon delegate, NugetArtifact artifact, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File lock;
        this.logger.debug("downloadmanager.getNugetFile " + artifact.toString() + " to " + destination.getAbsolutePath());
        File wrappedDestination = new File(destination.getAbsolutePath() + ".working");
        if (wrappedDestination.exists()) {
            this.logger.debug("File already exists. Nothing to be done.");
            return;
        }
        String key = artifact.resourceString();
        this.logger.debug("Acquiring lock for " + key + "...");
        File file = lock = this.getLock(key, wrappedDestination);
        synchronized (file) {
            this.logger.debug("Lock acquired for " + key + "...");
            if (wrappedDestination.exists()) {
                this.logger.debug("File was created while waiting for lock. Nothing to be done.");
                return;
            }
            try {
                File parentDirectory = wrappedDestination.getParentFile();
                if (!parentDirectory.exists()) {
                    parentDirectory.mkdirs();
                }
                wrappedDestination.createNewFile();
            }
            catch (IOException e) {
                throw new TransferFailedException(e.getMessage(), (Throwable)e);
            }
            delegate.get(key, destination);
        }
    }

    public void getMd5Hash(Repository repository, NugetArtifact artifact, File destination) throws TransferFailedException, ResourceDoesNotExistException {
        this.logger.debug("downloadmanager.getMd5Hash " + artifact.toString() + " to " + destination.getAbsolutePath());
        if (!artifact.isNugetFile()) {
            this.logger.debug("hash for files extracted from nuget archive not supported.");
            throw new ResourceDoesNotExistException("hash for files extracted from nuget archive not supported.");
        }
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpHead headRequest = new HttpHead(repository.getUrl() + "/" + artifact.resourceString());
            this.logger.debug("invoking HTTP HEAD " + repository.getUrl() + "/" + artifact.resourceString());
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)headRequest);){
                Header checkSum = response.getFirstHeader("Content-MD5");
                if (checkSum == null) {
                    this.logger.debug("Content-MD5 header not set");
                    throw new ResourceDoesNotExistException("Content-MD5 header not set");
                }
                this.logger.debug("wrting md5 hash to " + destination.getAbsolutePath());
                FileUtils.write((File)destination, (CharSequence)checkSum.getValue(), (Charset)StandardCharsets.ISO_8859_1);
            }
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }
}

