/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.util;

import io.github.millij.poi.util.Spreadsheet;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Beans {
    private static final Logger LOGGER = LoggerFactory.getLogger(Spreadsheet.class);

    private Beans() {
    }

    public static String getFieldName(Method method) {
        String methodName;
        return Introspector.decapitalize(methodName.substring((methodName = method.getName()).startsWith("is") ? 2 : 3));
    }

    public static String getFieldValueAsString(Object beanObj, String fieldName) throws Exception {
        PropertyDescriptor pd = new PropertyDescriptor(fieldName, beanObj.getClass());
        Method getterMtd = pd.getReadMethod();
        Object value = getterMtd.invoke(beanObj, new Object[0]);
        String cellValue = value != null ? String.valueOf(value) : null;
        return cellValue;
    }

    public static boolean isInstantiableType(Class<?> clz) {
        if (clz == null) {
            return false;
        }
        int modifiers = clz.getModifiers();
        LOGGER.debug("Modifiers of Class : {} - {}", clz, (Object)modifiers);
        return !clz.isPrimitive() && !Modifier.isAbstract(modifiers) && !clz.isInterface() && !clz.isArray();
    }
}

