/*
 * Decompiled with CFR 0.152.
 */
package io.github.mightguy.spellcheck.symspell.impl;

import io.github.mightguy.spellcheck.symspell.api.DataHolder;
import io.github.mightguy.spellcheck.symspell.api.HashFunction;
import io.github.mightguy.spellcheck.symspell.common.DictionaryItem;
import io.github.mightguy.spellcheck.symspell.common.SpellCheckSettings;
import io.github.mightguy.spellcheck.symspell.common.SpellHelper;
import io.github.mightguy.spellcheck.symspell.exception.SpellCheckException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InMemoryDataHolder
implements DataHolder {
    private Map<String, Double> wordsDictionary = new HashMap<String, Double>();
    private Map<String, Double> bigramsDictionary = new HashMap<String, Double>();
    private Map<String, String> exclusionDictionary = new HashMap<String, String>();
    private Map<String, Double> belowThresholdWords = new HashMap<String, Double>();
    private Map<Long, String[]> deletes = new HashMap<Long, String[]>();
    private SpellCheckSettings spellCheckSettings;
    private HashFunction hashFunction;

    public InMemoryDataHolder(SpellCheckSettings spellCheckSettings, HashFunction hashFunction) {
        this.spellCheckSettings = spellCheckSettings;
        this.hashFunction = hashFunction;
    }

    @Override
    public boolean addItem(DictionaryItem dictionaryItem) throws SpellCheckException {
        if (dictionaryItem.getFrequency() <= 0.0 && this.spellCheckSettings.getCountThreshold() > 0L) {
            return false;
        }
        double frequency = dictionaryItem.getFrequency();
        String key = dictionaryItem.getTerm();
        if (this.spellCheckSettings.isLowerCaseTerms()) {
            key = key.toLowerCase();
        }
        if (frequency <= 0.0) {
            frequency = 0.0;
        }
        if ((frequency = this.addItemToBelowThreshold(key, frequency)) == Double.MIN_VALUE) {
            return false;
        }
        if (!this.addToDictionary(key, frequency)) {
            return false;
        }
        if (key.length() > this.spellCheckSettings.getMaxLength()) {
            this.spellCheckSettings.setMaxLength(key.length());
        }
        Set<String> editDeletes = SpellHelper.getEditDeletes(key, this.spellCheckSettings.getMaxEditDistance(), this.spellCheckSettings.getPrefixLength(), this.spellCheckSettings.getEditFactor());
        for (String delete : editDeletes) {
            String[] suggestions;
            Long hash = this.hashFunction.hash(delete);
            if (this.deletes.containsKey(hash)) {
                suggestions = this.deletes.get(hash);
                String[] newSuggestions = Arrays.copyOf(suggestions, suggestions.length + 1);
                this.deletes.put(hash, newSuggestions);
                suggestions = newSuggestions;
            } else {
                suggestions = new String[1];
                this.deletes.put(hash, suggestions);
            }
            suggestions[suggestions.length - 1] = key;
        }
        return true;
    }

    private boolean addToDictionary(String key, double frequency) {
        if (this.spellCheckSettings.isDoKeySplit() && key.split(this.spellCheckSettings.getKeySplitRegex()).length > 1) {
            this.bigramsDictionary.put(key, frequency);
            if (frequency < this.spellCheckSettings.getBigramCountMin()) {
                this.spellCheckSettings.setBigramCountMin(frequency);
            }
            return false;
        }
        this.wordsDictionary.put(key, frequency);
        return true;
    }

    @Override
    public Double getItemFrequency(String term) throws SpellCheckException {
        return this.wordsDictionary.getOrDefault(term, null);
    }

    @Override
    public Double getItemFrequencyBiGram(String term) throws SpellCheckException {
        return this.bigramsDictionary.getOrDefault(term, null);
    }

    @Override
    public String[] getDeletes(String key) {
        return this.deletes.getOrDefault(this.hashFunction.hash(key), null);
    }

    @Override
    public int getSize() {
        return this.wordsDictionary.size();
    }

    @Override
    public boolean clear() {
        this.wordsDictionary.clear();
        this.deletes.clear();
        this.belowThresholdWords.clear();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private double addItemToBelowThreshold(String key, double frequency) {
        double prevFreq;
        if (this.spellCheckSettings.getCountThreshold() > 1L && this.belowThresholdWords.containsKey(key)) {
            double prevFreq2;
            frequency = prevFreq2 + (Double.MAX_VALUE - (prevFreq2 = this.belowThresholdWords.get(key).doubleValue()) > frequency ? frequency : Double.MAX_VALUE);
            if (frequency > (double)this.spellCheckSettings.getCountThreshold()) {
                this.belowThresholdWords.remove(key);
                return frequency;
            }
            this.belowThresholdWords.put(key, frequency);
            return Double.MIN_VALUE;
        }
        if (!this.wordsDictionary.containsKey(key)) {
            if (!(frequency < (double)this.spellCheckSettings.getCountThreshold())) return frequency;
            this.belowThresholdWords.put(key, frequency);
            return Double.MIN_VALUE;
        }
        frequency = prevFreq + (Double.MAX_VALUE - (prevFreq = this.wordsDictionary.get(key).doubleValue()) > frequency ? frequency : Double.MAX_VALUE);
        this.addToDictionary(key, frequency);
        return Double.MIN_VALUE;
    }

    @Override
    public void addExclusionItem(String key, String value) {
        this.exclusionDictionary.put(key, value);
    }

    @Override
    public void addExclusionItems(Map<String, String> values) {
        this.exclusionDictionary.putAll(values);
    }

    @Override
    public String getExclusionItem(String key) {
        return this.exclusionDictionary.getOrDefault(key, null);
    }
}

