/*
 * Decompiled with CFR 0.152.
 */
package io.github.mightguy.spellcheck.symspell.common;

import io.github.mightguy.spellcheck.symspell.common.SpellHelper;
import java.util.Comparator;

public class SuggestionItem
implements Comparator<SuggestionItem>,
Comparable<SuggestionItem> {
    private String term;
    private double distance;
    private double count;
    private double score;

    public SuggestionItem(String term, double distance, double count) {
        this.term = term;
        this.distance = distance;
        this.count = count;
    }

    @Override
    public int compareTo(SuggestionItem other) {
        if (SpellHelper.isEqualDouble(this.distance, other.distance, 0.001f)) {
            return Double.compare(other.count, this.count);
        }
        return Double.compare(this.distance, other.distance);
    }

    @Override
    public int compare(SuggestionItem suggestItem, SuggestionItem suggestItem2) {
        return suggestItem.compareTo(suggestItem2);
    }

    public String getTerm() {
        return this.term;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getCount() {
        return this.count;
    }

    public double getScore() {
        return this.score;
    }

    public String toString() {
        return "SuggestionItem(term=" + this.getTerm() + ", distance=" + this.getDistance() + ", count=" + this.getCount() + ", score=" + this.getScore() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuggestionItem)) {
            return false;
        }
        SuggestionItem other = (SuggestionItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getDistance(), other.getDistance()) != 0) {
            return false;
        }
        if (Double.compare(this.getCount(), other.getCount()) != 0) {
            return false;
        }
        if (Double.compare(this.getScore(), other.getScore()) != 0) {
            return false;
        }
        String this$term = this.getTerm();
        String other$term = other.getTerm();
        return !(this$term == null ? other$term != null : !this$term.equals(other$term));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SuggestionItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $distance = Double.doubleToLongBits(this.getDistance());
        result = result * 59 + (int)($distance >>> 32 ^ $distance);
        long $count = Double.doubleToLongBits(this.getCount());
        result = result * 59 + (int)($count >>> 32 ^ $count);
        long $score = Double.doubleToLongBits(this.getScore());
        result = result * 59 + (int)($score >>> 32 ^ $score);
        String $term = this.getTerm();
        result = result * 59 + ($term == null ? 43 : $term.hashCode());
        return result;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setCount(double count) {
        this.count = count;
    }

    public void setScore(double score) {
        this.score = score;
    }
}

