/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.quarkus.deployment;

import io.github.microcks.quarkus.deployment.DevServicesConfig;
import io.github.microcks.quarkus.deployment.MicrocksBuildTimeConfig;
import io.github.microcks.testcontainers.MicrocksContainer;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;
import org.testcontainers.Testcontainers;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class DevServicesMicrocksProcessor {
    private static final Logger log = Logger.getLogger(DevServicesMicrocksProcessor.class);
    private static final String MICROCKS_UBER_LATEST = "quay.io/microcks/microcks-uber:latest";
    private static final String MICROCKS_SCHEME = "http://";
    private static final String DEV_SERVICE_NAME = "microcks";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-microcks";
    private static final ContainerLocator microcksContainerLocator = new ContainerLocator("quarkus-dev-service-microcks", 8080);
    private static final String CONFIG_PREFIX = "quarkus.microcks.";
    private static final String HTTP_SUFFIX = ".http";
    private static final String HTTP_HOST_SUFFIX = ".http.host";
    private static final String HTTP_PORT_SUFFIX = ".http.port";
    private static final String GRPC_SUFFIX = ".grpc";
    private static final String GRPC_HOST_SUFFIX = ".grpc.host";
    private static final String GRPC_PORT_SUFFIX = ".grpc.port";
    private static final List<String> PRIMARY_ARTIFACTS_EXTENSIONS = Arrays.asList("-openapi.yml", "-openapi.yaml", "-openapi.json", ".proto", ".graphql", "-asyncapi.yml", "-asyncapi.yaml", "-asyncapi.json", "-soapui-project.xml");
    private static final List<String> SECONDARY_ARTIFACTS_EXTENSIONS = Arrays.asList("postman-collection.json", "postman_collection.json", "-metadata.yml", "-metadata.yaml", ".har");
    private static volatile MicrocksBuildTimeConfig.DevServiceConfiguration capturedDevServicesConfig;
    private static volatile List<DevServicesResultBuildItem.RunningDevService> devServices;
    private static volatile Map<DevServicesResultBuildItem.RunningDevService, MicrocksContainer> devServiceMicrocksContainerMap;
    private static volatile boolean first;

    @BuildStep
    public List<DevServicesResultBuildItem> startMicrocksContainers(LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, MicrocksBuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, CurateOutcomeBuildItem outcomeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        MicrocksBuildTimeConfig.DevServiceConfiguration currentDevServicesConfig = config.defaultDevService();
        if (devServices != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !currentDevServicesConfig.equals(capturedDevServicesConfig);
            if (!restartRequired) {
                return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
            }
            for (Closeable closeable : devServices) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop microcks container", e);
                }
            }
            devServices = null;
            capturedDevServicesConfig = null;
            devServiceMicrocksContainerMap = null;
        }
        capturedDevServicesConfig = currentDevServicesConfig;
        ArrayList<DevServicesResultBuildItem.RunningDevService> newDevServices = new ArrayList<DevServicesResultBuildItem.RunningDevService>();
        devServiceMicrocksContainerMap = new HashMap<DevServicesResultBuildItem.RunningDevService, MicrocksContainer>();
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Microcks Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesResultBuildItem.RunningDevService runningDevService = this.startContainer(currentDevServicesConfig.devservices(), dockerStatusBuildItem, launchMode.getLaunchMode(), outcomeBuildItem, !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (runningDevService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
                newDevServices.add(runningDevService);
                String configKey = "quarkus.microcks.default.http";
                log.infof("The '%s' microcks container is ready on %s", (Object)"default", runningDevService.getConfig().get(configKey));
            }
        }
        catch (Throwable throwable) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(throwable);
        }
        devServices = newDevServices;
        if (first) {
            first = false;
            Runnable runnable = () -> {
                if (devServices != null) {
                    for (Closeable closeable : devServices) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable t) {
                            log.error((Object)"Failed to stop microcks", t);
                        }
                    }
                }
                first = true;
                devServices = null;
                capturedDevServicesConfig = null;
            };
            closeBuildItem.addCloseTask(runnable, true);
        }
        return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public CardPageBuildItem pages(List<DevServicesResultBuildItem> devServicesResultBuildItems) {
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        String microcksUIUrl = null;
        if (!devServices.isEmpty()) {
            microcksUIUrl = (String)devServices.get(0).getConfig().get("quarkus.microcks.default.http");
        }
        if (microcksUIUrl != null) {
            cardPageBuildItem.addPage((PageBuilder)Page.externalPageBuilder((String)"Microcks UI").url(microcksUIUrl).isHtmlContent().icon("font-awesome-solid:plug-circle-bolt"));
        }
        return cardPageBuildItem;
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DevServicesConfig devServicesConfig, DockerStatusBuildItem dockerStatusBuildItem, LaunchMode launchMode, CurateOutcomeBuildItem outcomeBuildItem, boolean useSharedNetwork, Optional<Duration> timeout) {
        if (!devServicesConfig.enabled()) {
            log.debug((Object)"Not starting devservices for Microcks as it has been disabled in the config");
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)"Please configure quarkus.microcks.hosts or get a working docker instance");
            return null;
        }
        DockerImageName dockerImageName = DockerImageName.parse((String)devServicesConfig.imageName().orElse(MICROCKS_UBER_LATEST)).asCompatibleSubstituteFor(MICROCKS_UBER_LATEST);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultMicrocksSupplier = () -> this.lambda$startContainer$1(dockerImageName, devServicesConfig, timeout, launchMode, useSharedNetwork, outcomeBuildItem);
        return microcksContainerLocator.locateContainer(devServicesConfig.serviceName(), devServicesConfig.shared(), launchMode).map(containerAddress -> {
            String microcksUrl = MICROCKS_SCHEME + containerAddress.getUrl();
            return new DevServicesResultBuildItem.RunningDevService(DEV_SERVICE_NAME, containerAddress.getId(), null, "quarkus.microcks.default.http", microcksUrl);
        }).orElseGet(defaultMicrocksSupplier);
    }

    private boolean scanAndLoadPrimaryArtifacts(MicrocksContainer microcksContainer, CurateOutcomeBuildItem outcomeBuildItem) throws Exception {
        return this.scanAndLoadArtifacts(microcksContainer, outcomeBuildItem, PRIMARY_ARTIFACTS_EXTENSIONS, true);
    }

    private boolean scanAndLoadSecondaryArtifacts(MicrocksContainer microcksContainer, CurateOutcomeBuildItem outcomeBuildItem) throws Exception {
        return this.scanAndLoadArtifacts(microcksContainer, outcomeBuildItem, SECONDARY_ARTIFACTS_EXTENSIONS, false);
    }

    private boolean scanAndLoadArtifacts(MicrocksContainer microcksContainer, CurateOutcomeBuildItem outcomeBuildItem, List<String> validSuffixes, boolean primary) throws Exception {
        boolean foundSomething = false;
        ArrayList resourceDirs = new ArrayList();
        resourceDirs.addAll(outcomeBuildItem.getApplicationModel().getApplicationModule().getMainSources().getResourceDirs());
        resourceDirs.addAll(outcomeBuildItem.getApplicationModel().getApplicationModule().getTestSources().getResourceDirs());
        for (SourceDir resourceDir : resourceDirs) {
            Set<String> filesPaths = this.collectFiles(resourceDir.getDir(), validSuffixes);
            for (String filePath : filesPaths) {
                if (primary) {
                    log.infof("Load '%s' as primary artifact", (Object)filePath);
                    microcksContainer.importAsMainArtifact(new File(filePath));
                } else {
                    log.infof("Load '%s' as secondary artifact", (Object)filePath);
                    microcksContainer.importAsSecondaryArtifact(new File(filePath));
                }
                foundSomething = true;
            }
        }
        return foundSomething;
    }

    private Set<String> collectFiles(Path dir, List<String> validSuffixes) throws IOException {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, 2, new FileVisitOption[0]);){
                Set<String> set = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).filter(candidate -> this.endsWithOneOf((String)candidate, validSuffixes)).collect(Collectors.toSet());
                return set;
            }
        }
        return Collections.emptySet();
    }

    private boolean endsWithOneOf(String candidate, List<String> validSuffixes) {
        for (String validSuffix : validSuffixes) {
            if (!candidate.endsWith(validSuffix)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ DevServicesResultBuildItem.RunningDevService lambda$startContainer$1(DockerImageName dockerImageName, DevServicesConfig devServicesConfig, Optional timeout, LaunchMode launchMode, boolean useSharedNetwork, CurateOutcomeBuildItem outcomeBuildItem) {
        microcksContainer = new MicrocksContainer(dockerImageName);
        microcksContainer.withAccessToHost(true);
        globalConfig = ConfigProviderResolver.instance().getConfig();
        testPort = ((OptionalInt)globalConfig.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081);
        if (testPort > 0) {
            Testcontainers.exposeHostPorts((int[])new int[]{testPort});
        }
        microcksContainer.withEnv(devServicesConfig.containerEnv());
        timeout.ifPresent((Consumer<Duration>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, withStartupTimeout(java.time.Duration ), (Ljava/time/Duration;)V)((MicrocksContainer)microcksContainer));
        if (launchMode == LaunchMode.DEVELOPMENT) {
            microcksContainer.withLabel("quarkus-dev-service-microcks", devServicesConfig.serviceName());
        }
        hostName = null;
        if (useSharedNetwork) {
            hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)microcksContainer, (String)"microcks");
        }
        microcksContainer.start();
        if (devServicesConfig.artifacts().isPresent()) {
            try {
                artifactsConfig = devServicesConfig.artifacts().get();
                for (String primaryArtifact : artifactsConfig.primaries()) {
                    DevServicesMicrocksProcessor.log.infof("Load '%s' as primary artifact", (Object)primaryArtifact);
                    microcksContainer.importAsMainArtifact(new File(primaryArtifact));
                }
                if (!artifactsConfig.secondaries().isPresent()) ** GOTO lbl45
                for (String secondaryArtifact : artifactsConfig.secondaries().get()) {
                    DevServicesMicrocksProcessor.log.infof("Load '%s' as secondary artifact", (Object)secondaryArtifact);
                    microcksContainer.importAsSecondaryArtifact(new File(secondaryArtifact));
                }
            }
            catch (Exception e) {
                DevServicesMicrocksProcessor.log.error((Object)"Failed to load Artifacts in microcks", (Throwable)e);
            }
        } else {
            try {
                found = this.scanAndLoadPrimaryArtifacts(microcksContainer, outcomeBuildItem);
                if (found) {
                    this.scanAndLoadSecondaryArtifacts(microcksContainer, outcomeBuildItem);
                }
            }
            catch (Exception e) {
                DevServicesMicrocksProcessor.log.error((Object)"Failed to load Artifacts in microcks", (Throwable)e);
            }
        }
lbl45:
        // 5 sources

        visiblehost = hostName != null ? hostName : microcksContainer.getHost();
        microcksHttpHost = "http://" + visiblehost + ":" + microcksContainer.getMappedPort(8080);
        microcksGrpcHost = "http://" + visiblehost + ":" + microcksContainer.getMappedPort(9090);
        devService = new DevServicesResultBuildItem.RunningDevService("microcks", microcksContainer.getContainerId(), (Closeable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)((MicrocksContainer)microcksContainer), Map.of("quarkus.microcks.default.http", microcksHttpHost, "quarkus.microcks.default.http.host", visiblehost, "quarkus.microcks.default.http.port", microcksContainer.getMappedPort(8080).toString(), "quarkus.microcks.default.grpc", microcksGrpcHost, "quarkus.microcks.default.grpc.host", visiblehost, "quarkus.microcks.default.grpc.port", microcksContainer.getMappedPort(9090).toString()));
        DevServicesMicrocksProcessor.devServiceMicrocksContainerMap.put(devService, microcksContainer);
        return devService;
    }

    static {
        first = true;
    }
}

