/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.microcks.util.openapi.OpenAPISchemaValidator;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerSchemaValidator {
    private static Logger log = LoggerFactory.getLogger(SwaggerSchemaValidator.class);

    public static List<String> validateJsonMessage(JsonNode specificationNode, JsonNode jsonNode, String messagePathPointer) {
        return SwaggerSchemaValidator.validateJsonMessage(specificationNode, jsonNode, messagePathPointer, null);
    }

    public static List<String> validateJsonMessage(JsonNode specificationNode, JsonNode jsonNode, String messagePathPointer, String namespace) {
        JsonNode messageNode = specificationNode.at(messagePathPointer);
        if (messageNode == null || messageNode.isMissingNode()) {
            log.debug("messagePathPointer {} is not a valid JSON Pointer", (Object)messagePathPointer);
            return Arrays.asList("messagePathPointer does not represent a valid JSON Pointer in OpenAPI specification");
        }
        if (messageNode.has("$ref")) {
            String ref = messageNode.path("$ref").asText();
            messageNode = specificationNode.at(ref.substring(1));
        }
        if (messageNode == null || messageNode.isMissingNode()) {
            log.debug("Schema node for message cannot be found into Swagger specification");
            return Arrays.asList("messagePathPointer does not represent an existing JSON Pointer in OpenAPI specification");
        }
        JsonNode schemaNode = messageNode.path("schema").deepCopy();
        ((ObjectNode)schemaNode).set("definitions", specificationNode.path("definitions").deepCopy());
        return OpenAPISchemaValidator.validateJson(schemaNode, jsonNode, namespace);
    }
}

