/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.openapi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.microcks.util.JsonSchemaValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;

public class OpenAPISchemaValidator {
    private static final Logger log = LoggerFactory.getLogger(OpenAPISchemaValidator.class);
    private static final String ONE_OF = "oneOf";
    private static final String NULLABLE = "nullable";
    private static final String[] STRUCTURES = new String[]{"allOf", "anyOf", "oneOf", "not", "items", "additionalProperties"};
    private static final String[] COMPOSITION_STRUCTURES = new String[]{"allOf", "anyOf", "oneOf"};
    private static final String[] NOT_SUPPORTED_ATTRIBUTES = new String[]{"nullable", "discriminator", "readOnly", "writeOnly", "xml", "externalDocs", "example", "deprecated"};

    private OpenAPISchemaValidator() {
    }

    public static boolean isJsonValid(String schemaText, String jsonText) throws IOException {
        return OpenAPISchemaValidator.isJsonValid(schemaText, jsonText, null);
    }

    public static boolean isJsonValid(String schemaText, String jsonText, String namespace) throws IOException {
        List<String> errors = OpenAPISchemaValidator.validateJson(schemaText, jsonText, namespace);
        if (!errors.isEmpty()) {
            log.debug("Get validation errors, returning false");
            return false;
        }
        return true;
    }

    public static List<String> validateJson(String schemaText, String jsonText) throws IOException {
        return OpenAPISchemaValidator.validateJson(schemaText, jsonText, null);
    }

    public static List<String> validateJson(String schemaText, String jsonText, String namespace) throws IOException {
        return OpenAPISchemaValidator.validateJson(OpenAPISchemaValidator.getJsonNodeForSchema(schemaText), JsonSchemaValidator.getJsonNode(jsonText), namespace);
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode) {
        return OpenAPISchemaValidator.validateJson(schemaNode, jsonNode, null);
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode, String namespace) {
        schemaNode = OpenAPISchemaValidator.convertOpenAPISchemaToJsonSchema(schemaNode);
        return JsonSchemaValidator.validateJson(schemaNode, jsonNode, namespace);
    }

    public static List<String> validateJsonMessage(JsonNode specificationNode, JsonNode jsonNode, String messagePathPointer, String contentType) {
        return OpenAPISchemaValidator.validateJsonMessage(specificationNode, jsonNode, messagePathPointer, contentType, null);
    }

    public static List<String> validateJsonMessage(JsonNode specificationNode, JsonNode jsonNode, String messagePathPointer, String contentType, String namespace) {
        JsonNode messageNode = specificationNode.at(messagePathPointer);
        if (messageNode == null || messageNode.isMissingNode()) {
            log.debug("messagePathPointer {} is not a valid JSON Pointer", (Object)messagePathPointer);
            return List.of("messagePathPointer does not represent a valid JSON Pointer in OpenAPI specification");
        }
        if (messageNode.has("$ref")) {
            String ref = messageNode.path("$ref").asText();
            messageNode = specificationNode.at(ref.substring(1));
        }
        if ((messageNode = OpenAPISchemaValidator.getMessageContentNode(messageNode, contentType)) == null || messageNode.isMissingNode()) {
            log.debug("content for {} cannot be found into OpenAPI specification", (Object)contentType);
            return List.of("messagePathPointer does not represent an existing JSON Pointer in OpenAPI specification");
        }
        JsonNode schemaNode = messageNode.path("schema").deepCopy();
        if (schemaNode == null || schemaNode.isMissingNode()) {
            log.debug("schema for {} cannot be found into OpenAPI specification", (Object)messageNode);
            return List.of("schemaPathPointer does not represent an existing JSON Pointer in OpenAPI specification");
        }
        ((ObjectNode)schemaNode).set("components", specificationNode.path("components").deepCopy());
        return OpenAPISchemaValidator.validateJson(schemaNode, jsonNode, namespace);
    }

    public static JsonNode getJsonNode(String jsonText) throws IOException {
        return JsonSchemaValidator.getJsonNode(jsonText);
    }

    public static JsonNode getJsonNodeForSchema(String schemaText) throws IOException {
        boolean isYaml = true;
        String line = null;
        int lineNumber = 0;
        BufferedReader reader = new BufferedReader(new StringReader(schemaText));
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            if (lineNumber == 0 && (line.startsWith("{") || line.startsWith("["))) {
                isYaml = false;
                break;
            }
            if (line.startsWith("---") || line.startsWith("-") || line.startsWith("openapi: ")) break;
            ++lineNumber;
        }
        reader.close();
        ObjectMapper mapper = null;
        if (isYaml) {
            log.debug("Guessing OpenAPI spec format is YAML");
            LoaderOptions options = new LoaderOptions();
            if (schemaText.getBytes(StandardCharsets.UTF_8).length > 0x300000) {
                log.warn("OpenAPI schema is too big, increasing code point limit to 9MB");
                options.setCodePointLimit(schemaText.getBytes(StandardCharsets.UTF_8).length + 256);
            }
            mapper = new ObjectMapper((JsonFactory)YAMLFactory.builder().loaderOptions(options).build());
        } else {
            log.debug("Guessing OpenAPI spec format is JSON");
            mapper = new ObjectMapper();
        }
        return mapper.readTree(schemaText);
    }

    protected static JsonNode getMessageContentNode(JsonNode responseCodeNode, String contentType) {
        JsonNode contentNode = responseCodeNode.at("/content/" + contentType.replace("/", "~1"));
        if (contentNode == null || contentNode.isMissingNode()) {
            Iterator contents = responseCodeNode.path("content").fields();
            while (contents.hasNext()) {
                Map.Entry contentTypeNode = (Map.Entry)contents.next();
                if (!((String)contentTypeNode.getKey()).replace(" ", "").equalsIgnoreCase(contentType.replace(" ", ""))) continue;
                return (JsonNode)contentTypeNode.getValue();
            }
            if (contentType.contains("charset=") && contentType.indexOf(";") > 0) {
                return OpenAPISchemaValidator.getMessageContentNode(responseCodeNode, contentType.substring(0, contentType.indexOf(";")));
            }
        }
        return contentNode;
    }

    private static JsonNode convertOpenAPISchemaToJsonSchema(JsonNode jsonNode) {
        if (jsonNode.has("components")) {
            OpenAPISchemaValidator.convertProperties(jsonNode.path("components").path("schemas").elements());
        }
        for (String structure : STRUCTURES) {
            if (!jsonNode.has(structure) || !jsonNode.path(structure).isArray()) continue;
            ArrayNode arrayNode = (ArrayNode)jsonNode.path(structure);
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode structureNode = arrayNode.get(i);
                structureNode = OpenAPISchemaValidator.convertOpenAPISchemaToJsonSchema(structureNode);
            }
        }
        if (jsonNode.has("type") && jsonNode.path("type").asText().equals("object")) {
            OpenAPISchemaValidator.convertProperties(jsonNode.path("properties").elements());
        } else {
            OpenAPISchemaValidator.convertType(jsonNode);
        }
        for (String notSupported : NOT_SUPPORTED_ATTRIBUTES) {
            if (!jsonNode.has(notSupported)) continue;
            ((ObjectNode)jsonNode).remove(notSupported);
        }
        return jsonNode;
    }

    private static void convertProperties(Iterator<JsonNode> properties) {
        while (properties.hasNext()) {
            JsonNode property = properties.next();
            JsonNode jsonNode = OpenAPISchemaValidator.convertOpenAPISchemaToJsonSchema(property);
        }
    }

    private static Optional<String> getCompositionStructureType(JsonNode node) {
        for (String current : COMPOSITION_STRUCTURES) {
            if (!node.has(current)) continue;
            return Optional.of(current);
        }
        return Optional.empty();
    }

    private static boolean isOneOfNullable(ArrayNode oneOf) {
        for (JsonNode current : oneOf) {
            if (!current.isObject() || !((ObjectNode)current).has("type") || !((ObjectNode)current).get("type").asText().equals("null")) continue;
            return true;
        }
        return false;
    }

    private static void convertType(JsonNode node) {
        Optional<String> maybeStructure;
        if (node.has("type") && !node.path("type").asText().equals("object") && node.path(NULLABLE).asBoolean()) {
            String type = node.path("type").asText();
            ArrayNode typeArray = ((ObjectNode)node).putArray("type");
            typeArray.add(type).add("null");
        }
        if (node.path(NULLABLE).asBoolean() && (maybeStructure = OpenAPISchemaValidator.getCompositionStructureType(node)).isPresent()) {
            String structure = maybeStructure.get();
            if (structure.equals(ONE_OF)) {
                ArrayNode oneOf = (ArrayNode)node.path(ONE_OF);
                if (!OpenAPISchemaValidator.isOneOfNullable(oneOf)) {
                    ObjectNode nullNode = new ObjectMapper().createObjectNode();
                    nullNode.put("type", "null");
                    ((ArrayNode)node.path(ONE_OF)).add((JsonNode)nullNode);
                }
            } else {
                ObjectNode allOfChildObject = new ObjectMapper().createObjectNode();
                allOfChildObject.set(structure, node.path(structure));
                ((ObjectNode)node).remove(structure);
                ((ObjectNode)node).putArray(ONE_OF);
                ((ArrayNode)node.path(ONE_OF)).add((JsonNode)allOfChildObject);
                ObjectNode nullNode = new ObjectMapper().createObjectNode();
                nullNode.put("type", "null");
                ((ArrayNode)node.path(ONE_OF)).add((JsonNode)nullNode);
            }
        }
    }
}

