/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XmlSchemaURLResolver
implements LSResourceResolver {
    private static Logger log = LoggerFactory.getLogger(XmlSchemaURLResolver.class);
    private static final Map<String, String> LOCAL_RESOLUTIONS = Map.of("http://www.w3.org/2001/xml.xsd", "xml.xsd");
    private String baseResourceURL;

    public XmlSchemaURLResolver(String baseResourceURL) {
        this.baseResourceURL = baseResourceURL;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        log.debug("Resolving resource with systemId: {}", (Object)systemId);
        InputStream resourceStream = null;
        if (LOCAL_RESOLUTIONS.containsKey(systemId)) {
            log.debug("Got a local resolution, loading it from classloader");
            resourceStream = this.getClass().getClassLoader().getResourceAsStream(LOCAL_RESOLUTIONS.get(systemId));
        } else if (!(this.baseResourceURL == null || systemId.startsWith("http://") && systemId.startsWith("https://"))) {
            log.debug("Got a baseResourceURL defined and relative reference, loading it from URL");
            String sanitizedSystemId = systemId;
            if (systemId.startsWith("./")) {
                sanitizedSystemId = systemId.substring(2);
            }
            try {
                URL resourceURL = new URL(this.baseResourceURL + (this.baseResourceURL.endsWith("/") ? "" : "/") + sanitizedSystemId);
                resourceStream = resourceURL.openStream();
            }
            catch (Exception e) {
                log.error("Failed to open stream on {}/{}", new Object[]{this.baseResourceURL, sanitizedSystemId, e});
            }
        }
        if (resourceStream != null) {
            Input input = new Input(this);
            input.setSystemId(systemId);
            input.setPublicId(publicId);
            input.setBaseURI(baseURI);
            input.setCharacterStream(new InputStreamReader(resourceStream));
            return input;
        }
        return null;
    }

    public class Input
    implements LSInput {
        private Reader characterStream;
        private InputStream byteStream;
        private String stringData;
        private String systemId;
        private String publicId;
        private String baseURI;
        private String encoding;
        private boolean certifiedText;

        public Input(XmlSchemaURLResolver this$0) {
        }

        @Override
        public Reader getCharacterStream() {
            return this.characterStream;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this.characterStream = characterStream;
        }

        @Override
        public InputStream getByteStream() {
            return this.byteStream;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public void setStringData(String stringData) {
            this.stringData = stringData;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public void setBaseURI(String baseURI) {
            this.baseURI = baseURI;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            this.certifiedText = certifiedText;
        }
    }
}

