/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.testcontainers.model;

import io.github.microcks.testcontainers.model.Header;
import io.github.microcks.testcontainers.model.TestRunnerType;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class TestRequest {
    private String serviceId;
    private String testEndpoint;
    private String runnerType;
    private String secretName;
    private Long timeout = 5000L;
    private List<String> filteredOperations;
    private Map<String, List<Header>> operationsHeaders;

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getTestEndpoint() {
        return this.testEndpoint;
    }

    public void setTestEndpoint(String testEndpoint) {
        this.testEndpoint = testEndpoint;
    }

    public String getRunnerType() {
        return this.runnerType;
    }

    public void setRunnerType(String runnerType) {
        this.runnerType = runnerType;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public List<String> getFilteredOperations() {
        return this.filteredOperations;
    }

    public void setFilteredOperations(List<String> filteredOperations) {
        this.filteredOperations = filteredOperations;
    }

    public Map<String, List<Header>> getOperationsHeaders() {
        return this.operationsHeaders;
    }

    public void setOperationsHeaders(Map<String, List<Header>> operationsHeaders) {
        this.operationsHeaders = operationsHeaders;
    }

    public static class Builder {
        private String serviceId;
        private String testEndpoint;
        private String runnerType;
        private String secretName;
        private Long timeout;
        private List<String> filteredOperations;
        private Map<String, List<Header>> operationsHeaders;

        public Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder testEndpoint(String testEndpoint) {
            this.testEndpoint = testEndpoint;
            return this;
        }

        public Builder runnerType(String runnerType) {
            this.runnerType = runnerType;
            return this;
        }

        public Builder runnerType(TestRunnerType runnerType) {
            this.runnerType = runnerType.name();
            return this;
        }

        public Builder secretName(String secretName) {
            this.secretName = secretName;
            return this;
        }

        public Builder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder timeout(Duration duration) {
            this.timeout = duration.toMillis();
            return this;
        }

        public Builder filteredOperations(List<String> filteredOperations) {
            this.filteredOperations = filteredOperations;
            return this;
        }

        public Builder operationsHeaders(Map<String, List<Header>> operationsHeaders) {
            this.operationsHeaders = operationsHeaders;
            return this;
        }

        public TestRequest build() {
            TestRequest request = new TestRequest();
            request.setServiceId(this.serviceId);
            request.setRunnerType(this.runnerType);
            request.setTestEndpoint(this.testEndpoint);
            if (this.secretName != null) {
                request.setSecretName(this.secretName);
            }
            if (this.timeout != null) {
                request.setTimeout(this.timeout);
            }
            if (this.filteredOperations != null) {
                request.setFilteredOperations(this.filteredOperations);
            }
            if (this.operationsHeaders != null) {
                request.setOperationsHeaders(this.operationsHeaders);
            }
            return request;
        }
    }
}

