/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.config;

import io.github.microcks.web.filter.CorsFilter;
import io.github.microcks.web.filter.DynamicCorsFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Arrays;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class WebConfiguration
implements ServletContextInitializer {
    private static Logger log = LoggerFactory.getLogger(WebConfiguration.class);
    @Autowired
    private Environment env;
    @Value(value="${mocks.rest.enable-cors-policy}")
    private Boolean enableCorsPolicy = null;
    @Value(value="${mocks.rest.cors.allowedOrigins}")
    private String corsAllowedOrigins;
    @Value(value="${mocks.rest.cors.allowCredentials}")
    private Boolean corsAllowCredentials;

    public void onStartup(ServletContext servletContext) throws ServletException {
        log.info("Starting web application configuration, using profiles: {}", (Object)Arrays.toString(this.env.getActiveProfiles()));
        EnumSet<DispatcherType> disps = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC);
        this.initCORSFilter(servletContext, disps);
        log.info("Web application fully configured");
    }

    private void initCORSFilter(ServletContext servletContext, EnumSet<DispatcherType> disps) {
        FilterRegistration.Dynamic corsFilter = servletContext.addFilter("corsFilter", (Filter)new CorsFilter());
        corsFilter.addMappingForUrlPatterns(disps, true, new String[]{"/api/*"});
        corsFilter.addMappingForUrlPatterns(disps, true, new String[]{"/dynarest/*"});
        corsFilter.setAsyncSupported(true);
        if (Boolean.TRUE.equals(this.enableCorsPolicy)) {
            FilterRegistration.Dynamic dynamicCorsFilter = servletContext.addFilter("dynamicCorsFilter", (Filter)new DynamicCorsFilter(this.corsAllowedOrigins, this.corsAllowCredentials));
            dynamicCorsFilter.addMappingForUrlPatterns(disps, true, new String[]{"/rest/*"});
        }
    }
}

