/*
 * Decompiled with CFR 0.152.
 */
package com.gobrs.async.spi;

import com.gobrs.async.spi.ExtensionFactory;
import com.gobrs.async.spi.Realize;
import com.gobrs.async.spi.SPI;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionLoader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final String GOBRS_ASYNC_DIRECTORY = "META-INF/gobrs/";
    private static final Map<Class<?>, ExtensionLoader<?>> LOADERS = new ConcurrentHashMap();
    private final Class<T> clazz;
    private final ClassLoader classLoader;
    private final Holder<Map<String, ClassEntity>> cachedClasses = new Holder();
    private final Map<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private final Map<Class<?>, Object> realizeInstances = new ConcurrentHashMap();
    private String cachedDefaultName;
    private final Comparator<Holder<Object>> holderComparator = (o1, o2) -> {
        if (o1.getOrder() > o2.getOrder()) {
            return 1;
        }
        if (o1.getOrder() < o2.getOrder()) {
            return -1;
        }
        return 0;
    };
    private final Comparator<ClassEntity> classEntityComparator = (o1, o2) -> {
        if (o1.getOrder() > o2.getOrder()) {
            return 1;
        }
        if (o1.getOrder() < o2.getOrder()) {
            return -1;
        }
        return 0;
    };

    private ExtensionLoader(Class<T> clazz, ClassLoader cl) {
        this.clazz = clazz;
        this.classLoader = cl;
        if (!Objects.equals(clazz, ExtensionFactory.class)) {
        }
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> clazz, ClassLoader cl) {
        Objects.requireNonNull(clazz, "extension clazz is null");
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("extension clazz (" + clazz + ") is not interface!");
        }
        if (!clazz.isAnnotationPresent(SPI.class)) {
            throw new IllegalArgumentException("extension clazz (" + clazz + ") without @" + SPI.class + " Annotation");
        }
        ExtensionLoader<?> extensionLoader = LOADERS.get(clazz);
        if (Objects.nonNull(extensionLoader)) {
            return extensionLoader;
        }
        LOADERS.putIfAbsent(clazz, new ExtensionLoader<T>(clazz, cl));
        return LOADERS.get(clazz);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> clazz) {
        return ExtensionLoader.getExtensionLoader(clazz, ExtensionLoader.class.getClassLoader());
    }

    public T getDefaultRealize() {
        this.getExtensionClassesEntity();
        if (StringUtils.isBlank((CharSequence)this.cachedDefaultName)) {
            return null;
        }
        return this.getRealize(this.cachedDefaultName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getRealize(String name) {
        Object value;
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new NullPointerException("get realize name is null");
        }
        Holder<Object> objectHolder = this.cachedInstances.get(name);
        if (Objects.isNull(objectHolder)) {
            this.cachedInstances.putIfAbsent(name, new Holder());
            objectHolder = this.cachedInstances.get(name);
        }
        if (Objects.isNull(value = objectHolder.getValue())) {
            Map<String, Holder<Object>> map = this.cachedInstances;
            synchronized (map) {
                value = objectHolder.getValue();
                if (Objects.isNull(value)) {
                    Holder<T> pair = this.createExtension(name);
                    value = pair.getValue();
                    int order = pair.getOrder();
                    objectHolder.setValue(value);
                    objectHolder.setOrder(order);
                }
            }
        }
        return (T)value;
    }

    public List<T> getRealizes() {
        Map<String, ClassEntity> extensionClassesEntity = this.getExtensionClassesEntity();
        if (extensionClassesEntity.isEmpty()) {
            return Collections.emptyList();
        }
        if (Objects.equals(extensionClassesEntity.size(), this.cachedInstances.size())) {
            return this.cachedInstances.values().stream().sorted(this.holderComparator).map(e -> e.getValue()).collect(Collectors.toList());
        }
        ArrayList realizes = new ArrayList();
        List<ClassEntity> classEntities = extensionClassesEntity.values().stream().sorted(this.classEntityComparator).collect(Collectors.toList());
        classEntities.forEach(v -> {
            T realize = this.getRealize(v.getName());
            realizes.add(realize);
        });
        return realizes;
    }

    public T getRealLizesFirst() {
        List<T> realizes = this.getRealizes();
        return realizes.size() == 0 ? null : (T)realizes.get(0);
    }

    private Holder<T> createExtension(String name) {
        ClassEntity classEntity = this.getExtensionClassesEntity().get(name);
        if (Objects.isNull(classEntity)) {
            throw new IllegalArgumentException("name is error");
        }
        Class<?> aClass = classEntity.getClazz();
        Object o = this.realizeInstances.get(aClass);
        if (Objects.isNull(o)) {
            try {
                this.realizeInstances.putIfAbsent(aClass, aClass.newInstance());
                o = this.realizeInstances.get(aClass);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Extension instance(name: " + name + ", class: " + aClass + ")  could not be instantiated: " + e.getMessage(), e);
            }
        }
        Holder<Object> objectHolder = new Holder<Object>();
        objectHolder.setOrder(classEntity.getOrder());
        objectHolder.setValue(o);
        return objectHolder;
    }

    public Map<String, Class<?>> getRealizesMaps() {
        Map<String, ClassEntity> classes = this.getExtensionClassesEntity();
        return classes.values().stream().collect(Collectors.toMap(e -> e.getName(), x -> x.getClazz(), (a, b) -> a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ClassEntity> getExtensionClassesEntity() {
        Map<String, ClassEntity> classes = this.cachedClasses.getValue();
        if (Objects.isNull(classes)) {
            Holder<Map<String, ClassEntity>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.getValue();
                if (Objects.isNull(classes)) {
                    classes = this.loadExtensionClass();
                    this.cachedClasses.setValue(classes);
                    this.cachedClasses.setOrder(0);
                }
            }
        }
        return classes;
    }

    private Map<String, ClassEntity> loadExtensionClass() {
        String value;
        SPI annotation = this.clazz.getAnnotation(SPI.class);
        if (Objects.nonNull(annotation) && StringUtils.isNotBlank((CharSequence)(value = annotation.value()))) {
            this.cachedDefaultName = value;
        }
        HashMap<String, ClassEntity> classes = new HashMap<String, ClassEntity>(16);
        this.loadDirectory(classes);
        return classes;
    }

    private void loadDirectory(Map<String, ClassEntity> classes) {
        String fileName = GOBRS_ASYNC_DIRECTORY + this.clazz.getName();
        try {
            Enumeration<URL> urls;
            Enumeration<URL> enumeration = urls = Objects.nonNull(this.classLoader) ? this.classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (Objects.nonNull(urls)) {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    this.loadResources(classes, url);
                }
            }
        }
        catch (IOException t) {
            LOG.error("load extension class error {}", (Object)fileName, (Object)t);
        }
    }

    private void loadResources(Map<String, ClassEntity> classes, URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            Properties properties = new Properties();
            properties.load(inputStream);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String name = (String)k;
                String classPath = (String)v;
                if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)classPath)) {
                    try {
                        this.loadClass(classes, name, classPath);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("load extension resources error", e);
                    }
                }
            }));
        }
        catch (IOException e) {
            throw new IllegalStateException("load extension resources error", e);
        }
    }

    private void loadClass(Map<String, ClassEntity> classes, String name, String classPath) throws ClassNotFoundException {
        Class<?> subClass;
        Class<?> clazz = subClass = Objects.nonNull(this.classLoader) ? Class.forName(classPath, true, this.classLoader) : Class.forName(classPath);
        if (!this.clazz.isAssignableFrom(subClass)) {
            throw new IllegalStateException("load extension resources error," + subClass + " subtype is not of " + this.clazz);
        }
        if (!subClass.isAnnotationPresent(Realize.class)) {
            throw new IllegalStateException("load extension resources error," + subClass + " without @" + Realize.class + " annotation");
        }
        ClassEntity oldClassEntity = classes.get(name);
        if (Objects.isNull(oldClassEntity)) {
            Realize realizeAnnotation = subClass.getAnnotation(Realize.class);
            ClassEntity classEntity = new ClassEntity(name, realizeAnnotation.order(), subClass);
            classes.put(name, classEntity);
        } else if (!Objects.equals(oldClassEntity.getClazz(), subClass)) {
            throw new IllegalStateException("load extension resources error,Duplicate class " + this.clazz.getName() + " name " + name + " on " + oldClassEntity.getClazz().getName() + " or " + subClass.getName());
        }
    }

    static final class ClassEntity {
        private String name;
        private Integer order;
        private Class<?> clazz;

        private ClassEntity(String name, Integer order, Class<?> clazz) {
            this.name = name;
            this.order = order;
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public String getName() {
            return this.name;
        }

        public Integer getOrder() {
            return this.order;
        }
    }

    public static class Holder<T> {
        private volatile T value;
        private Integer order;

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public Integer getOrder() {
            return this.order;
        }
    }
}

