/*
 * Decompiled with CFR 0.152.
 */
package com.gobrs.async.core.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> String obj2String(T obj) {
        if (obj == null) {
            return null;
        }
        String s = null;
        try {
            s = obj instanceof String ? (String)obj : objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error("JsonUtil obj2String error", (Throwable)e);
        }
        return s;
    }

    public static <T> String obj2StringPretty(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T string2Obj(String str, Class<T> clazz) {
        if (str == null || str.length() == 0 || clazz == null) {
            return null;
        }
        String t = null;
        try {
            t = clazz.equals(String.class) ? str : objectMapper.readValue(str, clazz);
        }
        catch (IOException e) {
            log.error("JsonUtil string2Obj error{}", (Throwable)e);
        }
        return (T)t;
    }

    public static <T> T string2Obj(String str, TypeReference<T> typeReference) {
        if (str == null || str.length() == 0 || typeReference == null) {
            return null;
        }
        try {
            return (T)(typeReference.getType().equals(String.class) ? str : objectMapper.readValue(str, typeReference));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> T string2Obj(String str, Class<?> collectionClazz, Class<?> ... elementClazzes) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(collectionClazz, (Class[])elementClazzes);
        try {
            return (T)objectMapper.readValue(str, javaType);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static JsonBuilder builder() {
        return new JsonBuilder();
    }

    public static class JsonBuilder {
        private Map<String, Object> map = new HashMap<String, Object>();

        JsonBuilder() {
        }

        public JsonBuilder put(String key, Object value) {
            this.map.put(key, value);
            return this;
        }

        public String build() {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return objectMapper.writeValueAsString(this.map);
            }
            catch (JsonProcessingException e) {
                log.error("JsonUtil build error{}", (Throwable)e);
                return "{}";
            }
        }
    }
}

