/*
 * Decompiled with CFR 0.152.
 */
package com.gobrs.async.core.common.util;

import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class IdWorker {
    private final long twepoch = 1588435200000L;
    private final int workerIdBits = 10;
    private final int timestampBits = 41;
    private final int sequenceBits = 12;
    private final int maxWorkerId = 1023;
    private long workerId;
    private AtomicLong timestampAndSequence;
    private final long timestampAndSequenceMask = 0x1FFFFFFFFFFFFFL;

    public IdWorker(Long workerId) {
        this.initTimestampAndSequence();
        this.initWorkerId(workerId);
    }

    private void initTimestampAndSequence() {
        long timestamp = this.getNewestTimestamp();
        long timestampWithSequence = timestamp << 12;
        this.timestampAndSequence = new AtomicLong(timestampWithSequence);
    }

    private void initWorkerId(Long workerId) {
        if (workerId == null) {
            workerId = this.generateWorkerId();
        }
        if (workerId > 1023L || workerId < 0L) {
            String message = String.format("worker Id can't be greater than %d or less than 0", 1023);
            throw new IllegalArgumentException(message);
        }
        this.workerId = workerId << 53;
    }

    public long nextId() {
        this.waitIfNecessary();
        long next = this.timestampAndSequence.incrementAndGet();
        long timestampWithSequence = next & 0x1FFFFFFFFFFFFFL;
        return this.workerId | timestampWithSequence;
    }

    private void waitIfNecessary() {
        long newest;
        long currentWithSequence = this.timestampAndSequence.get();
        long current = currentWithSequence >>> 12;
        if (current >= (newest = this.getNewestTimestamp())) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private long getNewestTimestamp() {
        return System.currentTimeMillis() - 1588435200000L;
    }

    private long generateWorkerId() {
        try {
            return this.generateWorkerIdBaseOnMac();
        }
        catch (Exception e) {
            return this.generateRandomWorkerId();
        }
    }

    private long generateWorkerIdBaseOnMac() throws Exception {
        Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
        while (all.hasMoreElements()) {
            NetworkInterface networkInterface = all.nextElement();
            boolean isLoopback = networkInterface.isLoopback();
            boolean isVirtual = networkInterface.isVirtual();
            if (isLoopback || isVirtual) continue;
            byte[] mac = networkInterface.getHardwareAddress();
            return (mac[4] & 3) << 8 | mac[5] & 0xFF;
        }
        throw new RuntimeException("no available mac found");
    }

    private long generateRandomWorkerId() {
        return new Random().nextInt(1024);
    }
}

