/*
 * Decompiled with CFR 0.152.
 */
package com.gobrs.async.core.common.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class AnnotationUtil {
    private static final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private static final SimpleMetadataReaderFactory register = new SimpleMetadataReaderFactory();
    private static final StandardEnvironment environment = new StandardEnvironment();

    public static boolean hasAnnotationClass(Class zClass, Class annotationClass) {
        Object annotation = zClass.getAnnotation(annotationClass);
        return Objects.nonNull(annotation);
    }

    public static String getResourcePath(String packagePath) {
        if (StringUtils.isEmpty((CharSequence)packagePath)) {
            return "";
        }
        String resourcePath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)environment.resolveRequiredPlaceholders(packagePath)) + '/' + "**/*.class";
        return resourcePath;
    }

    public static Set<Class> getClazzFromAnnotation(String pkgPath, Class<? extends Annotation> annoClazz) {
        String pathPackage = AnnotationUtil.getResourcePath(pkgPath);
        HashSet<Class> paths = new HashSet<Class>();
        Resource[] resources = new Resource[]{};
        try {
            resources = resolver.getResources(pathPackage);
        }
        catch (IOException e) {
            return new HashSet<Class>();
        }
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = resources[i];
            MetadataReader metadataReader = null;
            try {
                metadataReader = register.getMetadataReader(resource);
            }
            catch (IOException e) {
                continue;
            }
            AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
            if (!annotationMetadata.hasAnnotation(annoClazz.getName()) && !annotationMetadata.hasAnnotatedMethods(annoClazz.getName())) continue;
            ClassMetadata classMetadata = metadataReader.getClassMetadata();
            String className = classMetadata.getClassName();
            try {
                Class<?> clazz = Class.forName(className);
                paths.add(clazz);
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return paths;
    }
}

