/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.RequiresPermission;
import android.support.v4.app.Fragment;
import io.github.memfis19.annca.internal.configuration.AnncaConfiguration;
import io.github.memfis19.annca.internal.ui.camera.Camera1Activity;
import io.github.memfis19.annca.internal.ui.camera2.Camera2Activity;
import io.github.memfis19.annca.internal.utils.CameraHelper;

public class Annca {
    private AnncaConfiguration anncaConfiguration;

    public Annca(Activity activity, @IntRange(from=0L) int requestCode) {
        AnncaConfiguration.Builder builder = new AnncaConfiguration.Builder(activity, requestCode);
        this.anncaConfiguration = builder.build();
    }

    public Annca(Fragment fragment, @IntRange(from=0L) int requestCode) {
        AnncaConfiguration.Builder builder = new AnncaConfiguration.Builder(fragment, requestCode);
        this.anncaConfiguration = builder.build();
    }

    public Annca(AnncaConfiguration cameraConfiguration) {
        this.anncaConfiguration = cameraConfiguration;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void launchCamera() {
        if (this.anncaConfiguration == null || this.anncaConfiguration.getActivity() == null && this.anncaConfiguration.getFragment() == null) {
            return;
        }
        Intent cameraIntent = CameraHelper.hasCamera2((Context)this.anncaConfiguration.getActivity()) ? (this.anncaConfiguration.getFragment() != null ? new Intent(this.anncaConfiguration.getFragment().getContext(), Camera2Activity.class) : new Intent((Context)this.anncaConfiguration.getActivity(), Camera2Activity.class)) : (this.anncaConfiguration.getFragment() != null ? new Intent(this.anncaConfiguration.getFragment().getContext(), Camera1Activity.class) : new Intent((Context)this.anncaConfiguration.getActivity(), Camera1Activity.class));
        cameraIntent.putExtra("io.memfis19.annca.request_code", this.anncaConfiguration.getRequestCode());
        cameraIntent.putExtra("io.memfis19.annca.camera_face", this.anncaConfiguration.getCameraFace());
        cameraIntent.putExtra("io.memfis19.annca.camera_video_file_path", this.anncaConfiguration.getOutPutFilePath());
        cameraIntent.putExtra("io.memfis19.annca.media_result_behaviour", this.anncaConfiguration.getMediaResultBehaviour());
        if (this.anncaConfiguration.getMediaAction() > 0) {
            cameraIntent.putExtra("io.memfis19.annca.media_action", this.anncaConfiguration.getMediaAction());
        }
        if (this.anncaConfiguration.getMediaQuality() > 0) {
            cameraIntent.putExtra("io.memfis19.annca.camera_media_quality", this.anncaConfiguration.getMediaQuality());
        }
        if (this.anncaConfiguration.getVideoDuration() > 0) {
            cameraIntent.putExtra("io.memfis19.annca.video_duration", this.anncaConfiguration.getVideoDuration());
        }
        if (this.anncaConfiguration.getVideoFileSize() > 0L) {
            cameraIntent.putExtra("io.memfis19.annca.camera_video_file_size", this.anncaConfiguration.getVideoFileSize());
        }
        if (this.anncaConfiguration.getMinimumVideoDuration() > 0) {
            cameraIntent.putExtra("io.memfis19.annca.minimum.video_duration", this.anncaConfiguration.getMinimumVideoDuration());
        }
        cameraIntent.putExtra("io.memfis19.annca.camera_flash_mode", this.anncaConfiguration.getFlashMode());
        if (this.anncaConfiguration.getFragment() != null) {
            this.anncaConfiguration.getFragment().startActivityForResult(cameraIntent, this.anncaConfiguration.getRequestCode());
        } else {
            this.anncaConfiguration.getActivity().startActivityForResult(cameraIntent, this.anncaConfiguration.getRequestCode());
        }
    }
}

